/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.control.MenuItem;
import javafx.scene.input.PickResult;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Sphere;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.javaFXToolkit.cameraControllers.CameraZoomCalculator;
import us.ihmc.javaFXToolkit.cameraControllers.FocusBasedCameraMouseEventHandler;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SingleViewport3DManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.MenuTools;

public class MainViewport3DManager
implements SingleViewport3DManager {
    private final Pane container;
    private final SubScene subScene;
    private final Group rootNode3D;
    private final PerspectiveCamera camera;
    private final FocusBasedCameraMouseEventHandler cameraController;

    public MainViewport3DManager(Group mainView3DRoot) {
        this.rootNode3D = mainView3DRoot;
        this.subScene = new SubScene((Parent)this.rootNode3D, -1.0, -1.0, true, SceneAntialiasing.BALANCED);
        this.subScene.setFill((Paint)Color.GRAY);
        this.subScene.setOnMousePressed(event -> this.subScene.requestFocus());
        this.container = new Pane(new Node[]{this.subScene});
        this.subScene.heightProperty().bind((ObservableValue)this.heightProperty());
        this.subScene.widthProperty().bind((ObservableValue)this.widthProperty());
        this.camera = new PerspectiveCamera(true);
        this.camera.setNearClip(0.05);
        this.camera.setFarClip(200000.0);
        this.subScene.setCamera((Camera)this.camera);
        this.cameraController = new FocusBasedCameraMouseEventHandler(this.widthProperty(), this.heightProperty(), this.camera, (Vector3DReadOnly)Axis3D.Z, (Vector3DReadOnly)Axis3D.X);
        this.cameraController.enableShiftClickFocusTranslation();
        this.subScene.addEventHandler(Event.ANY, (EventHandler)this.cameraController);
        Sphere focusPointViz = this.cameraController.getFocusPointViz();
        this.rootNode3D.getChildren().add((Object)focusPointViz);
        focusPointViz.visibleProperty().bind((ObservableValue)this.subScene.focusedProperty());
        MainViewport3DManager.setupNodeTrackingContextMenu(this.cameraController, (Node)this.subScene);
    }

    @Override
    public Pane getPane() {
        return this.container;
    }

    public ReadOnlyDoubleProperty widthProperty() {
        return this.container.widthProperty();
    }

    public ReadOnlyDoubleProperty heightProperty() {
        return this.container.heightProperty();
    }

    public SubScene getSubScene() {
        return this.subScene;
    }

    @Override
    public PerspectiveCamera getCamera() {
        return this.camera;
    }

    @Override
    public FocusBasedCameraMouseEventHandler getCameraController() {
        return this.cameraController;
    }

    @Override
    public void dispose() {
        this.cameraController.dispose();
    }

    public void setCameraNodeToTrack(Node nodeToTrack) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.cameraController.getNodeTracker().setNodeToTrack(nodeToTrack));
    }

    public void setCameraPosition(double x, double y, double z) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.cameraController.changeCameraPosition(x, y, z));
    }

    public void setCameraOrientation(double latitude, double longitude, double roll) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.cameraController.getRotationCalculator().setRotation(latitude, longitude, roll));
    }

    public void setCameraFocusPosition(double x, double y, double z) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.cameraController.changeFocusPosition(x, y, z, false));
    }

    public void setCameraZoom(double distanceFromFocus) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            CameraZoomCalculator zoomCalculator = this.cameraController.getZoomCalculator();
            if (zoomCalculator.isInvertZoomDirection()) {
                zoomCalculator.setZoom(-distanceFromFocus);
            } else {
                zoomCalculator.setZoom(distanceFromFocus);
            }
        });
    }

    static void setupNodeTrackingContextMenu(FocusBasedCameraMouseEventHandler cameraController, Node viewport) {
        MainViewport3DManager.setupNodeTrackingContextMenu((ObjectProperty<Node>)cameraController.getNodeTracker().nodeToTrackProperty(), viewport, node -> true);
    }

    static void setupNodeTrackingContextMenu(ObjectProperty<Node> nodeTrackedProperty, Node viewport, Predicate<Node> filter) {
        MenuTools.setupContextMenu(viewport, (owner, event) -> {
            PickResult pickResult = event.getPickResult();
            Node intersectedNode = pickResult.getIntersectedNode();
            if (intersectedNode == null || intersectedNode instanceof SubScene || intersectedNode == viewport || intersectedNode == nodeTrackedProperty.get() || !filter.test(intersectedNode)) {
                return null;
            }
            MenuItem menuItem = new MenuItem("Start tracking node: " + intersectedNode.getId());
            menuItem.setOnAction(e -> nodeTrackedProperty.set((Object)intersectedNode));
            return menuItem;
        }, (owner, event) -> {
            if (nodeTrackedProperty.get() == null) {
                return null;
            }
            MenuItem menuItem = new MenuItem("Stop tracking node: " + ((Node)nodeTrackedProperty.get()).getId());
            menuItem.setOnAction(e -> nodeTrackedProperty.set(null));
            return menuItem;
        });
    }
}

