/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXToggleButton;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.javaFXToolkit.messager.MessageBidirectionalBinding;
import us.ihmc.messager.TopicListener;
import us.ihmc.scs2.session.SessionDataExportRequest;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.SessionVariableFilterPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryIOTools;

public class SessionDataExportStageController
implements VisualizerController {
    @FXML
    private Stage stage;
    @FXML
    private VBox mainPane;
    @FXML
    private JFXSlider currentBufferIndexSlider;
    @FXML
    private JFXToggleButton exportRobotDefinitionToggleButton;
    @FXML
    private JFXToggleButton exportTerrainDefinitionToggleButton;
    @FXML
    private JFXToggleButton exportYoGraphicsDefinitionToggleButton;
    @FXML
    private JFXToggleButton exportRobotStateToggleButton;
    @FXML
    private JFXToggleButton exportDataToggleButton;
    @FXML
    private JFXComboBox<SharedMemoryIOTools.DataFormat> dataFormatComboBox;
    @FXML
    private SessionVariableFilterPaneController variableFilterPaneController;
    private final Property<SessionMode> currentSessionMode = new SimpleObjectProperty((Object)this, "currentSessionMode", null);
    private final Property<YoBufferPropertiesReadOnly> bufferProperties = new SimpleObjectProperty((Object)this, "bufferProperties", null);
    private final List<Runnable> cleanupActions = new ArrayList<Runnable>();
    private Window owner;
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.owner = toolkit.getWindow();
        this.topics = toolkit.getTopics();
        this.messager = toolkit.getMessager();
        MessageBidirectionalBinding currentSessionModeBinding = this.messager.bindBidirectional(this.topics.getSessionCurrentMode(), this.currentSessionMode, false);
        this.cleanupActions.add(() -> {
            this.messager.removeJavaFXSyncedTopicListener(this.topics.getSessionCurrentMode(), (TopicListener)currentSessionModeBinding);
            this.currentSessionMode.removeListener((ChangeListener)currentSessionModeBinding);
        });
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
        MutableBoolean updatingBufferIndex = new MutableBoolean(false);
        TopicListener bufferPropertiesBinding = this.messager.bindPropertyToTopic(this.topics.getYoBufferCurrentProperties(), this.bufferProperties);
        this.cleanupActions.add(() -> this.messager.removeJavaFXSyncedTopicListener(this.topics.getYoBufferCurrentProperties(), bufferPropertiesBinding));
        ChangeListener currentSessionModeChangeListener = (o, oldValue, newValue) -> {
            if (newValue != SessionMode.PAUSE) {
                this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
            } else if (this.bufferProperties.getValue() != null) {
                this.currentBufferIndexSlider.setMax((double)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getSize());
                updatingBufferIndex.setTrue();
                this.currentBufferIndexSlider.setValue((double)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getCurrentIndex());
                updatingBufferIndex.setFalse();
            }
        };
        this.currentSessionMode.addListener(currentSessionModeChangeListener);
        this.cleanupActions.add(() -> this.currentSessionMode.removeListener(currentSessionModeChangeListener));
        TopicListener bufferPropertiesTopicListener = m -> {
            if (this.currentSessionMode.getValue() != SessionMode.PAUSE) {
                return;
            }
            this.currentBufferIndexSlider.setMax((double)m.getSize());
            if (updatingBufferIndex.isFalse()) {
                updatingBufferIndex.setTrue();
                this.currentBufferIndexSlider.setValue((double)m.getCurrentIndex());
                updatingBufferIndex.setFalse();
            }
        };
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getYoBufferCurrentProperties(), bufferPropertiesTopicListener);
        this.cleanupActions.add(() -> this.messager.removeJavaFXSyncedTopicListener(this.topics.getYoBufferCurrentProperties(), bufferPropertiesTopicListener));
        ChangeListener bufferIndexSliderListener = (o, oldValue, newValue) -> {
            if (this.currentSessionMode.getValue() != SessionMode.PAUSE) {
                return;
            }
            if (updatingBufferIndex.isFalse()) {
                updatingBufferIndex.setTrue();
                this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)newValue.intValue());
                updatingBufferIndex.setFalse();
            }
        };
        this.currentBufferIndexSlider.valueProperty().addListener(bufferIndexSliderListener);
        this.cleanupActions.add(() -> this.currentBufferIndexSlider.valueProperty().removeListener(bufferIndexSliderListener));
        this.dataFormatComboBox.setItems(FXCollections.observableArrayList((Object[])SharedMemoryIOTools.DataFormat.values()));
        this.dataFormatComboBox.getSelectionModel().select((Object)SharedMemoryIOTools.DataFormat.ASCII);
        this.variableFilterPaneController.initialize(toolkit.getGlobalToolkit());
        this.cleanupActions.add(this.variableFilterPaneController::dispose);
        EventHandler closeWindowEventHandler = e -> this.close();
        this.owner.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, closeWindowEventHandler);
        this.cleanupActions.add(() -> this.owner.removeEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, closeWindowEventHandler));
        this.stage.setOnCloseRequest(e -> this.close());
        SessionVisualizerIOTools.addSCSIconToWindow((Window)this.stage);
        JavaFXMissingTools.centerWindowInOwner((Window)this.stage, this.owner);
    }

    public Stage getStage() {
        return this.stage;
    }

    public void close() {
        this.stage.close();
        this.cleanupActions.forEach(Runnable::run);
        this.cleanupActions.clear();
    }

    @FXML
    void cancel(ActionEvent event) {
        this.close();
    }

    @FXML
    void exportData(ActionEvent event) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath("export-data"));
        File result = directoryChooser.showDialog(this.owner);
        if (result == null) {
            return;
        }
        SessionVisualizerIOTools.setDefaultFilePath("export-data", result);
        SessionDataExportRequest request = new SessionDataExportRequest();
        request.setFile(result);
        request.setOverwrite(true);
        request.setVariableFilter(this.variableFilterPaneController.buildVariableFilter());
        request.setRegistryFilter(this.variableFilterPaneController.buildRegistryFilter());
        request.setExportRobotDefinitions(this.exportRobotDefinitionToggleButton.isSelected());
        request.setExportTerrainObjectDefinitions(this.exportTerrainDefinitionToggleButton.isSelected());
        request.setExportSessionYoGraphicDefinitions(this.exportYoGraphicsDefinitionToggleButton.isSelected());
        request.setExportRobotStateDefinitions(this.exportRobotStateToggleButton.isSelected());
        request.setExportSessionBufferRegistryDefinition(this.exportDataToggleButton.isSelected());
        if (this.exportDataToggleButton.isSelected()) {
            request.setExportSessionBufferDataFormat((SharedMemoryIOTools.DataFormat)this.dataFormatComboBox.getSelectionModel().getSelectedItem());
        } else {
            request.setExportSessionBufferDataFormat(null);
        }
        request.setOnExportStartCallback(() -> this.messager.submitMessage(this.topics.getDisableUserControls(), (Object)true));
        request.setOnExportEndCallback(() -> this.messager.submitMessage(this.topics.getDisableUserControls(), (Object)false));
        this.close();
        this.messager.submitMessage(this.topics.getSessionDataExportRequest(), (Object)request);
    }
}

