/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoChart.YoChartConfigurationDefinition;
import us.ihmc.scs2.definition.yoChart.YoChartGroupConfigurationDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIdentifier;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartPanelController;

public class ChartTable2D {
    private boolean ignoreSizePropertyListener = false;
    private final Property<ChartTable2DSize> size = new SimpleObjectProperty((Object)new ChartTable2DSize(0, 0));
    private final Property<ChartTable2DSize> maxSize = new SimpleObjectProperty((Object)new ChartTable2DSize(6, 6));
    private final Supplier<YoChartPanelController> chartBuilder;
    private final List<ChartChangeListener> listeners = new ArrayList<ChartChangeListener>();
    private YoChartPanelController[][] chartTable = new YoChartPanelController[0][0];

    public ChartTable2D(Supplier<YoChartPanelController> chartBuilder) {
        this.chartBuilder = chartBuilder;
        this.size.addListener((o, oldValue, newValue) -> {
            if (this.ignoreSizePropertyListener) {
                return;
            }
            this.resize((ChartTable2DSize)oldValue, (ChartTable2DSize)newValue, false);
        });
    }

    public ChartTable2DSize getSize() {
        return (ChartTable2DSize)this.sizeProperty().getValue();
    }

    public Property<ChartTable2DSize> sizeProperty() {
        return this.size;
    }

    public ChartTable2DSize getMaxSize() {
        return (ChartTable2DSize)this.maxSizeProperty().getValue();
    }

    public Property<ChartTable2DSize> maxSizeProperty() {
        return this.maxSize;
    }

    public boolean set(YoChartGroupConfigurationDefinition definition) {
        if (!((ChartTable2DSize)this.maxSize.getValue()).contains(definition.getNumberOfRows(), definition.getNumberOfColumns())) {
            LogTools.warn((String)"Cannot set from configuration, required number of rows/columns is too large.");
            return false;
        }
        this.clear();
        ChartTable2DSize newSize = new ChartTable2DSize(definition.getNumberOfRows(), definition.getNumberOfColumns());
        YoChartPanelController[][] newTable = new YoChartPanelController[newSize.getNumberOfRows()][newSize.getNumberOfCols()];
        YoChartConfigurationDefinition[][] newTableDefinition = ChartTable2D.extractChartDefinitionTable2D(definition);
        for (int row = 0; row < newSize.getNumberOfRows(); ++row) {
            for (int col = 0; col < newSize.getNumberOfCols(); ++col) {
                YoChartPanelController newChart;
                newTable[row][col] = newChart = this.chartBuilder.get();
                newChart.setChartConfiguration(newTableDefinition[row][col]);
                this.notifyChartAdded(newChart, row, col);
            }
        }
        this.chartTable = newTable;
        this.ignoreSizePropertyListener = true;
        this.size.setValue((Object)newSize);
        this.ignoreSizePropertyListener = false;
        return true;
    }

    private static YoChartConfigurationDefinition[][] extractChartDefinitionTable2D(YoChartGroupConfigurationDefinition definition) {
        YoChartConfigurationDefinition[][] tableDefinition = new YoChartConfigurationDefinition[definition.getNumberOfRows()][definition.getNumberOfColumns()];
        if (definition.getChartConfigurations() != null) {
            Iterator iterator = definition.getChartConfigurations().iterator();
            while (iterator.hasNext()) {
                YoChartConfigurationDefinition chartDefinition;
                tableDefinition[chartDefinition.getIdentifier().getRow()][chartDefinition.getIdentifier().getColumn()] = chartDefinition = (YoChartConfigurationDefinition)iterator.next();
            }
        }
        return tableDefinition;
    }

    public void addListener(ChartChangeListener listener) {
        this.listeners.add(listener);
    }

    private void notifyChartAdded(YoChartPanelController chart, int row, int col) {
        ChartChange change = new ChartChange(ChangeType.ADD, chart, null, new ChartIdentifier(row, col));
        for (ChartChangeListener listener : this.listeners) {
            listener.onChange(change);
        }
    }

    private void notifyChartRemoved(YoChartPanelController chart, int row, int col) {
        if (chart == null) {
            return;
        }
        ChartChange change = new ChartChange(ChangeType.REMOVE, chart, new ChartIdentifier(row, col), null);
        for (ChartChangeListener listener : this.listeners) {
            listener.onChange(change);
        }
    }

    private void notifyChartMoved(YoChartPanelController chart, int fromRow, int fromCol, int toRow, int toCol) {
        if (chart == null) {
            return;
        }
        if (fromRow == toRow && fromCol == toCol) {
            return;
        }
        ChartChange change = new ChartChange(ChangeType.MOVE, chart, new ChartIdentifier(fromRow, fromCol), new ChartIdentifier(toRow, toCol));
        for (ChartChangeListener listener : this.listeners) {
            listener.onChange(change);
        }
    }

    public void clear() {
        for (int row = 0; row < ((ChartTable2DSize)this.size.getValue()).getNumberOfRows(); ++row) {
            for (int col = 0; col < ((ChartTable2DSize)this.size.getValue()).getNumberOfCols(); ++col) {
                this.removeChart(row, col);
            }
        }
        this.chartTable = new YoChartPanelController[0][0];
        this.ignoreSizePropertyListener = true;
        this.size.setValue((Object)new ChartTable2DSize(0, 0));
        this.ignoreSizePropertyListener = false;
    }

    public ChartTable2DSize resize(ChartTable2DSize desiredSize) {
        return this.resize(desiredSize, false);
    }

    private ChartTable2DSize resize(ChartTable2DSize desiredSize, boolean onlyConsiderNullForDownsize) {
        ChartTable2DSize newSize = this.resize((ChartTable2DSize)this.size.getValue(), desiredSize, onlyConsiderNullForDownsize);
        this.ignoreSizePropertyListener = true;
        this.size.setValue((Object)newSize);
        this.ignoreSizePropertyListener = false;
        return newSize;
    }

    private ChartTable2DSize resize(ChartTable2DSize oldSize, ChartTable2DSize desiredSize, boolean onlyConsiderNullForDownsize) {
        if (this.chartTable.length != oldSize.getNumberOfRows() || (this.chartTable.length == 0 ? 0 : this.chartTable[0].length) != oldSize.getNumberOfCols()) {
            throw new IllegalStateException(String.format("Unexpected chartTable size: was [row=%d, col=%d], expected [row=%d, col=%d]", this.chartTable.length, this.chartTable.length == 0 ? 0 : this.chartTable[0].length, oldSize.getNumberOfRows(), oldSize.getNumberOfCols()));
        }
        if (Objects.equals(oldSize, desiredSize)) {
            return desiredSize;
        }
        if (!((ChartTable2DSize)this.maxSize.getValue()).contains(desiredSize)) {
            LogTools.warn((String)"Trying to set the size ({}) to be bigger than the max size ({}), reverting resize.", (Object)desiredSize, this.maxSize);
            return oldSize;
        }
        if (oldSize.isEmpty()) {
            this.chartTable = new YoChartPanelController[desiredSize.getNumberOfRows()][desiredSize.getNumberOfCols()];
            for (int row = 0; row < desiredSize.getNumberOfRows(); ++row) {
                for (int col = 0; col < desiredSize.getNumberOfCols(); ++col) {
                    YoChartPanelController yoChartPanelController = this.chartBuilder.get();
                    this.chartTable[row][col] = yoChartPanelController;
                    this.notifyChartAdded(yoChartPanelController, row, col);
                }
            }
        } else if (desiredSize.getNumberOfRows() >= oldSize.getNumberOfRows()) {
            if (desiredSize.getNumberOfCols() > oldSize.getNumberOfCols()) {
                YoChartPanelController[][] newTable = new YoChartPanelController[desiredSize.getNumberOfRows()][desiredSize.getNumberOfCols()];
                for (int row = 0; row < desiredSize.getNumberOfRows(); ++row) {
                    for (int col = 0; col < desiredSize.getNumberOfCols(); ++col) {
                        if (oldSize.contains(row, col)) {
                            newTable[row][col] = this.chartTable[row][col];
                            continue;
                        }
                        YoChartPanelController yoChartPanelController = this.chartBuilder.get();
                        newTable[row][col] = yoChartPanelController;
                        this.notifyChartAdded(yoChartPanelController, row, col);
                    }
                }
                this.chartTable = newTable;
            } else {
                int minCols = this.computeMinColumns(oldSize, onlyConsiderNullForDownsize);
                if (minCols > desiredSize.getNumberOfCols() && oldSize.equals(desiredSize = new ChartTable2DSize(desiredSize.getNumberOfRows(), minCols))) {
                    return oldSize;
                }
                YoChartPanelController[][] newTable = new YoChartPanelController[desiredSize.getNumberOfRows()][desiredSize.getNumberOfCols()];
                int colsToRemove = oldSize.getNumberOfCols() - desiredSize.getNumberOfCols();
                int newCol = desiredSize.getNumberOfCols() - 1;
                for (int oldCol = oldSize.getNumberOfCols() - 1; oldCol >= 0; --oldCol) {
                    int row;
                    if (colsToRemove > 0 && this.isColumnEmpty(oldCol, oldSize, onlyConsiderNullForDownsize)) {
                        --colsToRemove;
                        for (row = 0; row < oldSize.getNumberOfRows(); ++row) {
                            this.notifyChartRemoved(this.chartTable[row][oldCol], row, oldCol);
                        }
                        continue;
                    }
                    for (row = 0; row < desiredSize.getNumberOfRows(); ++row) {
                        if (row < oldSize.getNumberOfRows()) {
                            YoChartPanelController yoChartPanelController = this.chartTable[row][oldCol];
                            newTable[row][newCol] = yoChartPanelController;
                            this.notifyChartMoved(yoChartPanelController, row, oldCol, row, newCol);
                            continue;
                        }
                        YoChartPanelController yoChartPanelController = this.chartBuilder.get();
                        newTable[row][newCol] = yoChartPanelController;
                        this.notifyChartAdded(yoChartPanelController, row, newCol);
                    }
                    --newCol;
                }
                this.chartTable = newTable;
            }
        } else if (desiredSize.getNumberOfCols() >= oldSize.getNumberOfCols()) {
            int minRows = this.computeMinRows(oldSize, onlyConsiderNullForDownsize);
            if (minRows > desiredSize.getNumberOfRows() && oldSize.equals(desiredSize = new ChartTable2DSize(minRows, desiredSize.getNumberOfCols()))) {
                return oldSize;
            }
            YoChartPanelController[][] newTable = new YoChartPanelController[desiredSize.getNumberOfRows()][desiredSize.getNumberOfCols()];
            int rowsToRemove = oldSize.getNumberOfRows() - desiredSize.getNumberOfRows();
            int newRow = desiredSize.getNumberOfRows() - 1;
            for (int oldRow = oldSize.getNumberOfRows() - 1; oldRow >= 0; --oldRow) {
                int col;
                if (rowsToRemove > 0 && this.isRowEmpty(oldRow, oldSize, onlyConsiderNullForDownsize)) {
                    --rowsToRemove;
                    for (col = 0; col < oldSize.getNumberOfCols(); ++col) {
                        this.notifyChartRemoved(this.chartTable[oldRow][col], oldRow, col);
                    }
                    continue;
                }
                for (col = 0; col < desiredSize.getNumberOfCols(); ++col) {
                    if (col < oldSize.getNumberOfCols()) {
                        YoChartPanelController yoChartPanelController = this.chartTable[oldRow][col];
                        newTable[newRow][col] = yoChartPanelController;
                        this.notifyChartMoved(yoChartPanelController, oldRow, col, newRow, col);
                        continue;
                    }
                    YoChartPanelController yoChartPanelController = this.chartBuilder.get();
                    newTable[newRow][col] = yoChartPanelController;
                    this.notifyChartAdded(yoChartPanelController, newRow, col);
                }
                --newRow;
            }
            this.chartTable = newTable;
        } else {
            int minRows = this.computeMinRows(oldSize, onlyConsiderNullForDownsize);
            int minCols = this.computeMinColumns(oldSize, onlyConsiderNullForDownsize);
            if ((minRows > desiredSize.getNumberOfRows() || minCols > desiredSize.getNumberOfCols()) && oldSize.equals(desiredSize = new ChartTable2DSize(minRows, minCols))) {
                return oldSize;
            }
            YoChartPanelController[][] newTable = new YoChartPanelController[desiredSize.getNumberOfRows()][desiredSize.getNumberOfCols()];
            int rowsToRemove = oldSize.getNumberOfRows() - desiredSize.getNumberOfRows();
            int newRow = desiredSize.getNumberOfRows() - 1;
            for (int oldRow = oldSize.getNumberOfRows() - 1; oldRow >= 0; --oldRow) {
                if (rowsToRemove > 0 && this.isRowEmpty(oldRow, oldSize, onlyConsiderNullForDownsize)) {
                    --rowsToRemove;
                    for (int oldCol = 0; oldCol < oldSize.getNumberOfCols(); ++oldCol) {
                        this.notifyChartRemoved(this.chartTable[oldRow][oldCol], oldRow, oldCol);
                    }
                    continue;
                }
                int colsToRemove = oldSize.getNumberOfCols() - desiredSize.getNumberOfCols();
                int newCol = desiredSize.getNumberOfCols() - 1;
                for (int oldCol = oldSize.getNumberOfCols() - 1; oldCol >= 0; --oldCol) {
                    if (colsToRemove > 0 && this.isColumnEmpty(oldCol, oldSize, onlyConsiderNullForDownsize)) {
                        --colsToRemove;
                        this.notifyChartRemoved(this.chartTable[oldRow][oldCol], oldRow, oldCol);
                        continue;
                    }
                    YoChartPanelController yoChartPanelController = this.chartTable[oldRow][oldCol];
                    newTable[newRow][newCol] = yoChartPanelController;
                    this.notifyChartMoved(yoChartPanelController, oldRow, oldCol, newRow, newCol);
                    --newCol;
                }
                --newRow;
            }
            this.chartTable = newTable;
        }
        return desiredSize;
    }

    public void removeNullRowsAndColumns() {
        this.resize(new ChartTable2DSize(0, 0), true);
    }

    public YoChartPanelController get(int row, int col) {
        return this.chartTable[row][col];
    }

    public boolean isChartEmpty(int row, int col) {
        YoChartPanelController chart = this.chartTable[row][col];
        return chart == null || chart.isEmpty();
    }

    public boolean removeChart(YoChartPanelController chart) {
        for (int row = 0; row < ((ChartTable2DSize)this.size.getValue()).getNumberOfRows(); ++row) {
            for (int col = 0; col < ((ChartTable2DSize)this.size.getValue()).getNumberOfCols(); ++col) {
                if (chart != this.chartTable[row][col]) continue;
                this.chartTable[row][col] = null;
                this.notifyChartRemoved(chart, row, col);
                return true;
            }
        }
        return false;
    }

    public void removeChart(ChartIdentifier id) {
        this.removeChart(id.getRow(), id.getColumn());
    }

    public void removeChart(int row, int col) {
        YoChartPanelController chartToRemove = this.chartTable[row][col];
        this.chartTable[row][col] = null;
        this.notifyChartRemoved(chartToRemove, row, col);
    }

    public void removeEmptyCharts() {
        for (int row = 0; row < this.getSize().getNumberOfRows(); ++row) {
            for (int col = 0; col < this.getSize().getNumberOfCols(); ++col) {
                if (!this.isChartEmpty(row, col)) continue;
                this.removeChart(row, col);
            }
        }
    }

    public ChartTable2DSize computeMinSize(ChartTable2DSize currentSize, boolean onlyNull) {
        return new ChartTable2DSize(this.computeMinRows(currentSize, onlyNull), this.computeMinColumns(currentSize, onlyNull));
    }

    private int computeMinRows(ChartTable2DSize currentSize, boolean onlyNull) {
        return currentSize.getNumberOfRows() - this.numberOfEmptyRows(currentSize, onlyNull);
    }

    private int computeMinColumns(ChartTable2DSize currentSize, boolean onlyNull) {
        return currentSize.getNumberOfCols() - this.numberOfEmptyColumns(currentSize, onlyNull);
    }

    private int numberOfEmptyRows(ChartTable2DSize size, boolean onlyNull) {
        int count = 0;
        for (int row = 0; row < size.getNumberOfRows(); ++row) {
            if (!this.isRowEmpty(row, size, onlyNull)) continue;
            ++count;
        }
        return count;
    }

    private boolean isRowEmpty(int row, ChartTable2DSize size, boolean onlyNull) {
        if (row < 0 || row > size.getNumberOfRows()) {
            throw new IndexOutOfBoundsException(String.format("Row (%d) is out of bound, expected range [0,%d[", row, size.getNumberOfRows()));
        }
        YoChartPanelController[] chartRow = this.chartTable[row];
        for (int col = 0; col < chartRow.length; ++col) {
            YoChartPanelController chart = chartRow[col];
            if (!(onlyNull ? chart != null : chart != null && !chart.isEmpty())) continue;
            return false;
        }
        return true;
    }

    private int numberOfEmptyColumns(ChartTable2DSize size, boolean onlyNull) {
        int count = 0;
        for (int col = 0; col < this.chartTable[0].length; ++col) {
            if (!this.isColumnEmpty(col, size, onlyNull)) continue;
            ++count;
        }
        return count;
    }

    private boolean isColumnEmpty(int col, ChartTable2DSize size, boolean onlyNull) {
        if (col < 0 || col > size.getNumberOfCols()) {
            throw new IndexOutOfBoundsException(String.format("Col (%d) is out of bound, expected range [0,%d[", col, size.getNumberOfCols()));
        }
        for (int row = 0; row < this.chartTable.length; ++row) {
            YoChartPanelController chart = this.chartTable[row][col];
            if (!(onlyNull ? chart != null : chart != null && !chart.isEmpty())) continue;
            return false;
        }
        return true;
    }

    public void forEachChart(Consumer<YoChartPanelController> action) {
        for (int row = 0; row < this.getSize().getNumberOfRows(); ++row) {
            for (int col = 0; col < this.getSize().getNumberOfCols(); ++col) {
                YoChartPanelController chart = this.get(row, col);
                if (chart == null) continue;
                action.accept(chart);
            }
        }
    }

    public List<YoChartConfigurationDefinition> toChartDefinitions() {
        ArrayList<YoChartConfigurationDefinition> chartDefinitions = new ArrayList<YoChartConfigurationDefinition>();
        for (int row = 0; row < this.getSize().getNumberOfRows(); ++row) {
            for (int col = 0; col < this.getSize().getNumberOfCols(); ++col) {
                if (this.isChartEmpty(row, col)) continue;
                chartDefinitions.add(this.get(row, col).toYoChartConfigurationDefinition(new ChartIdentifier(row, col)));
            }
        }
        return chartDefinitions;
    }

    public static class ChartTable2DSize {
        private final int numberOfRows;
        private final int numberOfCols;

        public ChartTable2DSize(int numberOfRows, int numberOfCols) {
            this.numberOfRows = numberOfRows;
            this.numberOfCols = numberOfCols;
        }

        public int getNumberOfRows() {
            return this.numberOfRows;
        }

        public int getNumberOfCols() {
            return this.numberOfCols;
        }

        public boolean isEmpty() {
            return this.numberOfRows == 0 && this.numberOfCols == 0;
        }

        public boolean contains(int row, int col) {
            return row < this.numberOfRows && col < this.numberOfCols;
        }

        public boolean contains(ChartTable2DSize other) {
            return this.contains(other.numberOfRows - 1, other.numberOfCols - 1);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ChartTable2DSize) {
                ChartTable2DSize other = (ChartTable2DSize)object;
                return this.numberOfRows == other.numberOfRows && this.numberOfCols == other.numberOfCols;
            }
            return false;
        }

        public String toString() {
            return String.format("Size: [nRows=%d, nCols=%d]", this.numberOfRows, this.numberOfCols);
        }
    }

    public static class ChartChange {
        private final ChangeType type;
        private final YoChartPanelController chart;
        private final ChartIdentifier from;
        private final ChartIdentifier to;

        private ChartChange(ChangeType type, YoChartPanelController chart, ChartIdentifier from, ChartIdentifier to) {
            this.type = type;
            this.chart = chart;
            this.from = from;
            this.to = to;
        }

        public ChangeType type() {
            return this.type;
        }

        public YoChartPanelController getChart() {
            return this.chart;
        }

        public ChartIdentifier from() {
            return this.from;
        }

        public int fromRow() {
            return this.from == null ? -1 : this.from.getRow();
        }

        public int fromCol() {
            return this.from == null ? -1 : this.from.getColumn();
        }

        public ChartIdentifier to() {
            return this.to;
        }

        public int toRow() {
            return this.to == null ? -1 : this.to.getRow();
        }

        public int toCol() {
            return this.to == null ? -1 : this.to.getColumn();
        }

        public String toString() {
            switch (this.type) {
                case ADD: {
                    return String.format("Add    - [row=%d, col=%d]", this.toRow(), this.toCol());
                }
                case REMOVE: {
                    return String.format("Remove - [row=%d, col=%d]", this.fromRow(), this.fromCol());
                }
                case MOVE: {
                    return String.format("Move   - [row=%d, col=%d] => [row=%d, col=%d]", this.fromRow(), this.fromCol(), this.toRow(), this.toCol());
                }
            }
            throw new IllegalArgumentException("Unexpected value: " + this.type);
        }
    }

    public static enum ChangeType {
        ADD,
        REMOVE,
        MOVE;

    }

    public static interface ChartChangeListener {
        public void onChange(ChartChange var1);
    }
}

