/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.animation.AnimationTimer;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Rectangle2D;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.messager.TopicListener;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sessionVisualizer.jfx.SceneVideoRecordingRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.IntegerConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.PositiveIntegerValueFilter;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;

public class VideoRecordingPreviewPaneController {
    @FXML
    private VBox mainPane;
    @FXML
    private AnchorPane imageViewContainer;
    @FXML
    private ImageView imageView;
    @FXML
    private Slider currentBufferIndexSlider;
    @FXML
    private ComboBox<String> resolutionComboBox;
    @FXML
    private TextField frameRateTextField;
    @FXML
    private TextField realTimeRateTextField;
    private WritableImage image;
    private final IntegerProperty width = new SimpleIntegerProperty((Object)this, "width", Resolution.FULL_HD_1920x1080.getWidth());
    private final IntegerProperty height = new SimpleIntegerProperty((Object)this, "height", Resolution.FULL_HD_1920x1080.getHeight());
    private Property<Integer> frameRate;
    private Property<Double> realTimeRate;
    private final Property<SessionMode> currentSessionMode = new SimpleObjectProperty((Object)this, "currentSessionMode", null);
    private AtomicReference<YoBufferPropertiesReadOnly> bufferProperties;
    private Window owner;
    private Stage stage;
    private Group rootNode3D;
    private JavaFXMessager messager;
    private SessionVisualizerTopics topics;
    private final List<Runnable> cleanupActions = new ArrayList<Runnable>();
    private final SnapshotParameters snapshotParameters = new SnapshotParameters();
    private final AnimationTimer refreshViewAnimation = new AnimationTimer(){

        public void handle(long now) {
            VideoRecordingPreviewPaneController.this.refreshView();
        }
    };

    public void initialize(Window owner, Group mainView3DRoot, PerspectiveCamera targetCamera, JavaFXMessager messager, SessionVisualizerTopics topics) {
        this.owner = owner;
        this.rootNode3D = mainView3DRoot;
        this.messager = messager;
        this.topics = topics;
        this.snapshotParameters.setDepthBuffer(true);
        this.snapshotParameters.setCamera((Camera)targetCamera);
        this.snapshotParameters.setFill((Paint)Color.GRAY);
        this.resolutionComboBox.setItems(FXCollections.observableArrayList((Object[])Resolution.allDescriptions));
        this.resolutionComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            Resolution resolution = Resolution.fromDescription(newValue);
            this.width.set(resolution.getWidth());
            this.height.set(resolution.getHeight());
        });
        this.resolutionComboBox.getSelectionModel().select((Object)Resolution.FULL_HD_1920x1080.getDescription());
        messager.bindBidirectional(topics.getSessionCurrentMode(), this.currentSessionMode, false);
        TextFormatter frameRateFormatter = new TextFormatter((StringConverter)new IntegerConverter(), (Object)60, (UnaryOperator)new PositiveIntegerValueFilter());
        TextFormatter realTimeRateFormatter = new TextFormatter((StringConverter)new DoubleStringConverter(), (Object)1.0);
        this.frameRateTextField.setTextFormatter(frameRateFormatter);
        this.realTimeRateTextField.setTextFormatter(realTimeRateFormatter);
        this.frameRate = frameRateFormatter.valueProperty();
        this.realTimeRate = realTimeRateFormatter.valueProperty();
        messager.submitMessage(topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
        MutableBoolean updatingBufferIndex = new MutableBoolean(false);
        this.bufferProperties = messager.createInput(topics.getYoBufferCurrentProperties());
        this.cleanupActions.add(() -> messager.removeInput(topics.getYoBufferCurrentProperties(), this.bufferProperties));
        ChangeListener currentSessionModeListener = (o, oldValue, newValue) -> {
            if (newValue != SessionMode.PAUSE) {
                messager.submitMessage(topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
            } else if (this.bufferProperties.get() != null) {
                this.currentBufferIndexSlider.setMax((double)this.bufferProperties.get().getSize());
                updatingBufferIndex.setTrue();
                this.currentBufferIndexSlider.setValue((double)this.bufferProperties.get().getCurrentIndex());
                updatingBufferIndex.setFalse();
            }
        };
        this.currentSessionMode.addListener(currentSessionModeListener);
        this.cleanupActions.add(() -> this.currentSessionMode.removeListener(currentSessionModeListener));
        TopicListener currentBufferPropertiesListener = m -> {
            if (this.currentSessionMode.getValue() != SessionMode.PAUSE) {
                return;
            }
            this.currentBufferIndexSlider.setMax((double)m.getSize());
            if (updatingBufferIndex.isFalse()) {
                updatingBufferIndex.setTrue();
                this.currentBufferIndexSlider.setValue((double)m.getCurrentIndex());
                updatingBufferIndex.setFalse();
            }
        };
        messager.registerJavaFXSyncedTopicListener(topics.getYoBufferCurrentProperties(), currentBufferPropertiesListener);
        this.cleanupActions.add(() -> messager.removeJavaFXSyncedTopicListener(topics.getYoBufferCurrentProperties(), currentBufferPropertiesListener));
        ChangeListener currentBufferIndexSliderListener = (o, oldValue, newValue) -> {
            if (this.currentSessionMode.getValue() != SessionMode.PAUSE) {
                return;
            }
            if (updatingBufferIndex.isFalse()) {
                updatingBufferIndex.setTrue();
                messager.submitMessage(topics.getYoBufferCurrentIndexRequest(), (Object)newValue.intValue());
                updatingBufferIndex.setFalse();
            }
        };
        this.currentBufferIndexSlider.valueProperty().addListener(currentBufferIndexSliderListener);
        this.cleanupActions.add(() -> this.currentBufferIndexSlider.valueProperty().removeListener(currentBufferIndexSliderListener));
        this.stage = new Stage(StageStyle.UTILITY);
        this.stage.setTitle("Video export preview and properties");
        this.stage.setScene(new Scene((Parent)this.mainPane));
        this.refreshViewAnimation.start();
        this.stage.setOnCloseRequest(e -> this.close());
        owner.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, e -> this.close());
    }

    public void close() {
        this.cleanupActions.forEach(Runnable::run);
        this.cleanupActions.clear();
        this.refreshViewAnimation.stop();
        this.stage.close();
    }

    public Stage getStage() {
        return this.stage;
    }

    private void refreshView() {
        int localWidth = this.width.get();
        int localHeight = this.height.get();
        if (this.image == null || (double)localHeight != this.image.getHeight() || (double)localWidth != this.image.getWidth()) {
            this.snapshotParameters.setViewport(new Rectangle2D(0.0, 0.0, (double)localWidth, (double)localHeight));
            this.image = new WritableImage(localWidth, localHeight);
            this.imageView.setImage((Image)this.image);
            this.stage.sizeToScene();
        }
        this.rootNode3D.snapshot(this.snapshotParameters, this.image);
    }

    @FXML
    void cancel(ActionEvent event) {
        this.close();
    }

    @FXML
    void exportVideo(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath("video"));
        fileChooser.getExtensionFilters().add((Object)SessionVisualizerIOTools.videoExtensionFilter);
        File result = fileChooser.showSaveDialog(this.owner);
        if (result == null) {
            return;
        }
        SessionVisualizerIOTools.setDefaultFilePath("video", result);
        SceneVideoRecordingRequest request = new SceneVideoRecordingRequest();
        request.setFile(result);
        request.setFrameRate(((Integer)this.frameRate.getValue()).intValue());
        request.setRealTimeRate((Double)this.realTimeRate.getValue());
        request.setWidth(this.width.get());
        request.setHeight(this.height.get());
        this.close();
        this.messager.submitMessage(this.topics.getSceneVideoRecordingRequest(), (Object)request);
    }

    private static enum Resolution {
        SD_640x480("SD (640 x 480)", 640, 480),
        HD_1280x720("HD (1280 x 720)", 1280, 720),
        FULL_HD_1920x1080("Full HD (1920 x 1080)", 1920, 1080),
        QUAD_HD_2560x1440("Quad HD (2560 x 1440)", 2560, 1440);

        private static final Map<String, Resolution> descriptionToEnumConstant;
        private static final String[] allDescriptions;
        private final String description;
        private final int width;
        private final int height;

        private Resolution(String description, int width, int height) {
            this.description = description;
            this.width = width;
            this.height = height;
        }

        public String getDescription() {
            return this.description;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public static Resolution fromDescription(String description) {
            return descriptionToEnumConstant.get(description);
        }

        static {
            descriptionToEnumConstant = Arrays.stream(Resolution.values()).collect(Collectors.toMap(e -> e.getDescription(), Function.identity()));
            allDescriptions = (String[])Arrays.stream(Resolution.values()).map(Resolution::getDescription).toArray(String[]::new);
        }
    }
}

