/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.stage.Window;
import javafx.util.Pair;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.MainWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.SCSGuiConfiguration;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.session.SessionControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.SessionInfoController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.LogSessionManagerController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.remote.RemoteSessionManagerController;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.BufferedJavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;

public class MultiSessionManager {
    private final SessionVisualizerToolkit toolkit;
    private final MainWindowController mainWindowController;
    private final Map<Class<? extends SessionControlsController>, SessionControlsController> inactiveControllerMap = new HashMap<Class<? extends SessionControlsController>, SessionControlsController>();
    private final ObjectProperty<SessionControlsController> activeController = new SimpleObjectProperty((Object)this, "activeSessionControls", null);
    private final ObjectProperty<Session> activeSession = new SimpleObjectProperty((Object)this, "activeSession", null);
    private String robotName;
    private String sessionName;

    public MultiSessionManager(SessionVisualizerToolkit toolkit, MainWindowController mainWindowController) {
        this.toolkit = toolkit;
        this.mainWindowController = mainWindowController;
        this.activeSession.addListener((o, oldValue, newValue) -> {
            JavaFXMissingTools.runAndWait(this.getClass(), () -> {
                if (toolkit.hasActiveSession()) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to save the default configuration?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
                    alert.initOwner((Window)toolkit.getMainWindow());
                    JavaFXMissingTools.centerDialogInOwner(alert);
                    alert.setOnShown(e -> JavaFXMissingTools.runLater(this.getClass(), () -> JavaFXMissingTools.centerDialogInOwner(alert)));
                    SessionVisualizerIOTools.addSCSIconToDialog(alert);
                    Optional result = alert.showAndWait();
                    this.stopSession(result.isPresent() && result.get() == ButtonType.YES, true);
                    if (oldValue != null) {
                        oldValue.shutdownSession();
                    }
                }
            });
            if (newValue != null) {
                this.startSession((Session)newValue, () -> {
                    if (this.activeController.get() != null) {
                        ((SessionControlsController)this.activeController.get()).notifySessionLoaded();
                    }
                });
            }
        });
        SessionVisualizerTopics topics = toolkit.getTopics();
        BufferedJavaFXMessager messager = toolkit.getMessager();
        messager.registerTopicListener(topics.getStartNewSessionRequest(), m -> this.activeSession.set(m));
        messager.registerJavaFXSyncedTopicListener(topics.getRemoteSessionControlsRequest(), m -> this.openRemoteSessionControls());
        messager.registerJavaFXSyncedTopicListener(topics.getLogSessionControlsRequest(), m -> this.openLogSessionControls());
        messager.registerJavaFXSyncedTopicListener(topics.getSessionVisualizerConfigurationLoadRequest(), m -> this.loadSessionConfiguration((File)m));
        messager.registerJavaFXSyncedTopicListener(topics.getSessionVisualizerConfigurationSaveRequest(), m -> this.saveSessionConfiguration((File)m));
        messager.registerJavaFXSyncedTopicListener(topics.getSessionVisualizerDefaultConfigurationLoadRequest(), m -> this.loadSessionDefaultConfiguration(toolkit.getSession()));
        messager.registerJavaFXSyncedTopicListener(topics.getSessionVisualizerDefaultConfigurationSaveRequest(), m -> this.saveSessionDefaultConfiguration());
    }

    public void startSession(Session session, Runnable sessionLoadedCallback) {
        Runnable callback = () -> {
            try {
                this.loadSessionDefaultConfiguration(session);
            }
            finally {
                if (sessionLoadedCallback != null) {
                    sessionLoadedCallback.run();
                }
            }
        };
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            this.toolkit.startSession(session, callback);
            this.mainWindowController.startSession();
        });
    }

    public void stopSession(boolean saveConfiguration, boolean shutdownSession) {
        if (!this.toolkit.hasActiveSession()) {
            return;
        }
        if (saveConfiguration) {
            this.saveSessionDefaultConfiguration();
        }
        this.toolkit.stopSession(shutdownSession);
        this.mainWindowController.stopSession();
        this.inactiveControllerMap.values().forEach(SessionControlsController::unloadSession);
    }

    public void openRemoteSessionControls() {
        this.openSessionControls(RemoteSessionManagerController.class, SessionVisualizerIOTools.REMOTE_SESSION_MANAGER_PANE_FXML_URL);
    }

    public void openLogSessionControls() {
        this.openSessionControls(LogSessionManagerController.class, SessionVisualizerIOTools.LOG_SESSION_MANAGER_PANE_FXML_URL);
    }

    private void openSessionControls(Class<? extends SessionControlsController> controllerType, URL fxml) {
        SessionInfoController sessionInfoController;
        SessionControlsController controller;
        SessionControlsController activeSessionControls = (SessionControlsController)this.activeController.get();
        if (activeSessionControls != null) {
            if (!controllerType.isInstance(activeSessionControls)) {
                this.closeSessionControls(activeSessionControls);
            } else {
                activeSessionControls.bringUp();
                return;
            }
        }
        if ((controller = this.inactiveControllerMap.remove(controllerType)) == null) {
            try {
                FXMLLoader loader = new FXMLLoader(fxml);
                loader.load();
                controller = (SessionControlsController)loader.getController();
                controller.initialize(this.toolkit);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((sessionInfoController = controller.getSessionInfoController()) != null) {
            Pane infoPane = sessionInfoController.getMainPane();
            this.mainWindowController.getSceneAnchorPane().getChildren().add((Object)infoPane);
            AnchorPane.setLeftAnchor((Node)infoPane, (Double)5.0);
            AnchorPane.setBottomAnchor((Node)infoPane, (Double)5.0);
        }
        this.activeController.set((Object)controller);
        controller.bringUp();
    }

    private void closeSessionControls(SessionControlsController controller) {
        SessionInfoController sessionInfo = controller.getSessionInfoController();
        if (sessionInfo != null) {
            this.mainWindowController.getSceneAnchorPane().getChildren().remove((Object)sessionInfo.getMainPane());
        }
        controller.getStage().close();
        if (this.activeController.get() != null) {
            this.inactiveControllerMap.put(((SessionControlsController)this.activeController.get()).getClass(), (SessionControlsController)this.activeController.get());
        }
        if (this.activeController.get() == controller) {
            this.activeController.set(null);
        }
    }

    public void loadSessionDefaultConfiguration(Session session) {
        this.robotName = session.getRobotDefinitions().isEmpty() ? "UnknownRobot" : EuclidCoreIOTools.getCollectionString((String)"-", (Collection)session.getRobotDefinitions(), RobotDefinition::getName);
        this.sessionName = session.getSessionName();
        SCSGuiConfiguration configuration = SCSGuiConfiguration.defaultLoader(this.robotName, this.sessionName);
        this.loadSessionConfiguration(configuration);
    }

    private void loadSessionConfiguration(SCSGuiConfiguration configuration) {
        if (!configuration.exists()) {
            return;
        }
        BufferedJavaFXMessager messager = this.toolkit.getMessager();
        SessionVisualizerTopics topics = this.toolkit.getTopics();
        if (configuration.hasYoGraphicsConfiguration()) {
            messager.submitMessage(topics.getYoGraphicLoadRequest(), configuration.getYoGraphicsConfigurationFile());
        }
        if (configuration.hasYoCompositeConfiguration()) {
            messager.submitMessage(topics.getYoCompositePatternLoadRequest(), configuration.getYoCompositeConfigurationFile());
        }
        if (configuration.hasYoEntryConfiguration()) {
            JavaFXMissingTools.runLaterWhen(this.getClass(), () -> this.toolkit.getYoCompositeSearchManager().isSessionLoaded(), () -> this.mainWindowController.getSidePaneController().getYoEntryTabPaneController().load(configuration.getYoEntryConfigurationFile()));
        }
        if (configuration.hasMainYoChartGroupConfiguration()) {
            messager.submitMessage(topics.getYoChartGroupLoadConfiguration(), new Pair((Object)this.toolkit.getMainWindow(), (Object)configuration.getMainYoChartGroupConfigurationFile()));
        }
        this.toolkit.getWindowManager().loadSessionConfiguration(configuration);
        if (configuration.hasBufferSize()) {
            messager.submitMessage(topics.getYoBufferInitializeSize(), configuration.getBufferSize());
        }
        if (configuration.hasRecordTickPeriod()) {
            messager.submitMessage(topics.getInitializeBufferRecordTickPeriod(), configuration.getRecordTickPeriod());
        }
        if (configuration.hasNumberPrecision()) {
            messager.submitMessage(topics.getControlsNumberPrecision(), configuration.getNumberPrecision());
        }
        messager.submitMessage(topics.getShowOverheadPlotter(), configuration.getShowOverheadPlotter());
        messager.submitMessage(topics.getShowAdvancedControls(), configuration.getShowAdvancedControls());
        if (configuration.hasYoSliderboardConfiguration()) {
            messager.submitMessage(topics.getYoSliderboardLoadConfiguration(), configuration.getYoSliderboardConfigurationFile());
        }
    }

    public void loadSessionConfiguration(File configurationFile) {
        if (!configurationFile.exists() || !configurationFile.isFile()) {
            return;
        }
        try {
            File unzippedConfiguration = SessionIOTools.getTemporaryDirectory((String)"configuration");
            SessionIOTools.unzipFile((File)configurationFile, (File)unzippedConfiguration);
            this.loadSessionConfiguration(SCSGuiConfiguration.loaderFromDirectory(this.robotName, this.sessionName, unzippedConfiguration));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    public void saveSessionDefaultConfiguration() {
        SCSGuiConfiguration configuration = SCSGuiConfiguration.defaultSaver(this.robotName, this.sessionName);
        this.saveSessionConfiguration(configuration);
    }

    private void saveSessionConfiguration(SCSGuiConfiguration configuration) {
        Integer numberPrecision;
        this.toolkit.getYoGraphicFXManager().saveYoGraphicToFile(configuration.getYoGraphicsConfigurationFile());
        this.toolkit.getYoCompositeSearchManager().saveYoCompositePatternToFile(configuration.getYoCompositeConfigurationFile());
        this.mainWindowController.getSidePaneController().getYoEntryTabPaneController().exportAllTabs(configuration.getYoEntryConfigurationFile());
        this.mainWindowController.getYoChartGroupPanelController().saveChartGroupConfiguration((Window)this.toolkit.getMainWindow(), configuration.getMainYoChartGroupConfigurationFile());
        this.toolkit.getWindowManager().saveSessionConfiguration(configuration);
        configuration.setMainStage(this.toolkit.getMainWindow());
        SessionVisualizerTopics topics = this.toolkit.getTopics();
        BufferedJavaFXMessager messager = this.toolkit.getMessager();
        int currentBufferSize = this.toolkit.getYoManager().getBufferSize();
        configuration.setBufferSize(currentBufferSize);
        Integer bufferRecordTickPeriod = messager.getLastValue(topics.getBufferRecordTickPeriod());
        if (bufferRecordTickPeriod != null) {
            configuration.setRecordTickPeriod(bufferRecordTickPeriod);
        }
        if ((numberPrecision = messager.getLastValue(topics.getControlsNumberPrecision())) != null) {
            configuration.setNumberPrecision(numberPrecision);
        }
        configuration.setShowOverheadPlotter((Boolean)this.mainWindowController.showOverheadPlotterProperty().getValue());
        configuration.setShowAdvancedControls(this.mainWindowController.showAdvancedControlsProperty().get());
        configuration.writeConfiguration();
    }

    public void saveSessionConfiguration(File destinationFile) {
        try {
            File intermediate = SessionIOTools.getTemporaryDirectory((String)"configuration");
            this.saveSessionConfiguration(SCSGuiConfiguration.saverToDirectory(this.robotName, this.sessionName, intermediate));
            SessionIOTools.zipFile((File)intermediate, (File)destinationFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.inactiveControllerMap.values().forEach(controller -> controller.shutdown());
    }
}

