/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Message;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.MessagerStateListener;
import us.ihmc.messager.TopicListener;

public class SharedMemoryMessager
implements Messager {
    private final MessagerAPIFactory.MessagerAPI messagerAPI;
    private final AtomicBoolean isConnected = new AtomicBoolean(false);
    private final ConcurrentHashMap<MessagerAPIFactory.Topic<?>, ConcurrentLinkedQueue<AtomicReference<Object>>> boundVariables = new ConcurrentHashMap();
    private final ConcurrentHashMap<MessagerAPIFactory.Topic<?>, ConcurrentLinkedQueue<TopicListener<Object>>> topicListenersMap = new ConcurrentHashMap();
    private final List<MessagerStateListener> connectionStateListeners = new ArrayList<MessagerStateListener>();

    public SharedMemoryMessager(MessagerAPIFactory.MessagerAPI messagerAPI) {
        this.messagerAPI = messagerAPI;
    }

    public <T> void submitMessage(Message<T> message) {
        ConcurrentLinkedQueue<TopicListener<Object>> topicListeners;
        if (!this.messagerAPI.containsTopic(message.getTopicID())) {
            throw new RuntimeException("The message is not part of this messager's API.");
        }
        MessagerAPIFactory.Topic messageTopic = this.messagerAPI.findTopic(message.getTopicID());
        if (!this.isConnected.get()) {
            LogTools.warn((String)("This messager is closed, message's topic: " + messageTopic.getSimpleName()));
            return;
        }
        ConcurrentLinkedQueue<AtomicReference<Object>> boundVariablesForTopic = this.boundVariables.get(messageTopic);
        if (boundVariablesForTopic != null) {
            boundVariablesForTopic.forEach((Consumer<AtomicReference<Object>>)((Consumer<AtomicReference>)variable -> variable.set(message.getMessageContent())));
        }
        if ((topicListeners = this.topicListenersMap.get(messageTopic)) != null) {
            topicListeners.forEach((Consumer<TopicListener<Object>>)((Consumer<TopicListener>)listener -> listener.receivedMessageForTopic(message.getMessageContent())));
        }
    }

    public <T> AtomicReference<T> createInput(MessagerAPIFactory.Topic<T> topic, T defaultValue) {
        AtomicReference<T> boundVariable = new AtomicReference<T>(defaultValue);
        this.attachInput(topic, boundVariable);
        return boundVariable;
    }

    public <T> void attachInput(MessagerAPIFactory.Topic<T> topic, AtomicReference<T> input) {
        ConcurrentLinkedQueue boundVariablesForTopic = this.boundVariables.computeIfAbsent(topic, k -> new ConcurrentLinkedQueue());
        boundVariablesForTopic.add(input);
    }

    public <T> boolean removeInput(MessagerAPIFactory.Topic<T> topic, AtomicReference<T> input) {
        ConcurrentLinkedQueue<AtomicReference<Object>> boundVariablesForTopic = this.boundVariables.get(topic);
        if (boundVariablesForTopic == null) {
            return false;
        }
        return boundVariablesForTopic.remove(input);
    }

    public <T> void registerTopicListener(MessagerAPIFactory.Topic<T> topic, TopicListener<T> listener) {
        ConcurrentLinkedQueue<Object> topicListeners = this.topicListenersMap.get(topic);
        if (topicListeners == null) {
            topicListeners = new ConcurrentLinkedQueue();
            this.topicListenersMap.put(topic, topicListeners);
        }
        topicListeners.add(listener);
    }

    public <T> boolean removeTopicListener(MessagerAPIFactory.Topic<T> topic, TopicListener<T> listener) {
        ConcurrentLinkedQueue<TopicListener<Object>> topicListeners = this.topicListenersMap.get(topic);
        if (topicListeners == null) {
            return false;
        }
        return topicListeners.remove(listener);
    }

    public void startMessager() {
        this.isConnected.set(true);
        this.notifyMessagerStateListeners();
    }

    public void closeMessager() {
        this.isConnected.set(false);
        this.notifyMessagerStateListeners();
        this.boundVariables.values().forEach(AbstractQueue::clear);
        this.topicListenersMap.values().forEach(AbstractQueue::clear);
        this.boundVariables.clear();
        this.topicListenersMap.clear();
        this.connectionStateListeners.clear();
    }

    public boolean isMessagerOpen() {
        return this.isConnected.get();
    }

    public void registerMessagerStateListener(MessagerStateListener listener) {
        this.connectionStateListeners.add(listener);
    }

    public boolean removeMessagerStateListener(MessagerStateListener listener) {
        return this.connectionStateListeners.remove(listener);
    }

    public void notifyMessagerStateListeners() {
        this.connectionStateListeners.forEach(listener -> listener.messagerStateChanged(this.isMessagerOpen()));
    }

    public MessagerAPIFactory.MessagerAPI getMessagerAPI() {
        return this.messagerAPI;
    }
}

