/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.util.List;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import us.ihmc.javaFXToolkit.shapes.JavaFXCoordinateSystem;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.Skybox;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;

public class EnvironmentManager
implements Manager {
    private final Group rootNode = new Group();
    private final Group terrainObjectGraphics = new Group();
    private Group staticVisualsRoot;
    private Skybox skybox;
    private final BackgroundExecutorManager backgroundExecutorManager;

    public EnvironmentManager(BackgroundExecutorManager backgroundExecutorManager) {
        this.backgroundExecutorManager = backgroundExecutorManager;
        this.rootNode.getChildren().add((Object)this.terrainObjectGraphics);
    }

    public void addWorldCoordinateSystem(double size) {
        this.backgroundExecutorManager.executeInBackground(() -> {
            JavaFXCoordinateSystem node = new JavaFXCoordinateSystem(size);
            JavaFXMissingTools.runLater(this.getClass(), () -> this.lambda$null$0((Node)node));
        });
    }

    public void addSkybox(Camera mainCamera) {
        if (this.skybox != null) {
            return;
        }
        this.skybox = new Skybox();
        if (Skybox.USE_CLOUDY_CROWN_SKY_BOX) {
            this.skybox.setupCloudyCrown();
        } else {
            this.skybox.setupSCS1Skybox();
        }
        this.skybox.setupCamera(mainCamera);
        this.backgroundExecutorManager.executeInBackground(() -> JavaFXMissingTools.runLater(this.getClass(), () -> this.rootNode.getChildren().add((Object)this.skybox)));
    }

    public void addStaticVisual(VisualDefinition visualDefinition) {
        Node node = JavaFXVisualTools.toNode(visualDefinition, null);
        if (this.staticVisualsRoot == null) {
            this.staticVisualsRoot = new Group();
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                this.staticVisualsRoot.getChildren().add((Object)node);
                this.rootNode.getChildren().add((Object)this.staticVisualsRoot);
            });
        } else {
            JavaFXMissingTools.runLater(this.getClass(), () -> this.staticVisualsRoot.getChildren().add((Object)node));
        }
    }

    @Override
    public void startSession(Session session) {
        List terrainObjectDefinitions = session.getTerrainObjectDefinitions();
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            for (TerrainObjectDefinition definition : terrainObjectDefinitions) {
                Node nodes = JavaFXVisualTools.collectNodes(definition.getVisualDefinitions(), definition.getResourceClassLoader());
                if (nodes == null) continue;
                this.terrainObjectGraphics.getChildren().add((Object)nodes);
            }
        });
    }

    @Override
    public void stopSession() {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.terrainObjectGraphics.getChildren().clear());
    }

    @Override
    public boolean isSessionLoaded() {
        return true;
    }

    public Group getRootNode() {
        return this.rootNode;
    }

    public void dispose() {
        if (this.skybox != null) {
            this.skybox.dispose();
            this.skybox = null;
        }
        this.rootNode.getChildren().clear();
        this.terrainObjectGraphics.getChildren().clear();
        if (this.staticVisualsRoot != null) {
            this.staticVisualsRoot.getChildren().clear();
            this.staticVisualsRoot = null;
        }
    }

    private /* synthetic */ void lambda$null$0(Node node) {
        this.rootNode.getChildren().add((Object)node);
    }
}

