/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import com.jfoenix.controls.JFXSlider;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.Skin;
import us.ihmc.commons.MathTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.CropSliderSkin;

public class CropSlider
extends JFXSlider {
    private static final String DEFAULT_STYLE_CLASS = "crop-slider";
    private BooleanProperty showTrim;
    private DoubleProperty trimGap;
    private DoubleProperty trimStartValue;
    private DoubleProperty trimEndValue;
    private BooleanProperty trimStartValueChanging;
    private BooleanProperty trimEndValueChanging;

    public CropSlider() {
        this.initialize();
    }

    public CropSlider(double min, double max, double value) {
        super(min, max, value);
        this.initialize();
    }

    protected Skin<?> createDefaultSkin() {
        return new CropSliderSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("css/crop-slider.css").toExternalForm();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public boolean isShowTrim() {
        return this.showTrim == null ? false : this.showTrim.get();
    }

    public void setShowTrim(boolean value) {
        this.showTrimProperty().set(value);
    }

    public BooleanProperty showTrimProperty() {
        if (this.showTrim == null) {
            this.showTrim = new SimpleBooleanProperty((Object)this, "showTrim", false);
        }
        return this.showTrim;
    }

    public double getTrimGap() {
        return this.trimGap == null ? 3.0 : this.trimGap.get();
    }

    public void setTrimGap(double value) {
        this.trimGapProperty().set(value);
    }

    public DoubleProperty trimGapProperty() {
        if (this.trimGap == null) {
            this.trimGap = new SimpleDoubleProperty((Object)this, "trimGap", 3.0);
        }
        return this.trimGap;
    }

    public final void setTrimStartValue(double value) {
        if (!this.trimStartValueProperty().isBound()) {
            this.trimStartValueProperty().set(value);
        }
    }

    public final double getTrimStartValue() {
        return this.trimStartValue == null ? 0.0 : this.trimStartValue.get();
    }

    public final DoubleProperty trimStartValueProperty() {
        if (this.trimStartValue == null) {
            this.trimStartValue = new DoublePropertyBase(0.0){

                protected void invalidated() {
                    if (CropSlider.this.getTrimStartValue() < CropSlider.this.getMin() || CropSlider.this.getTrimStartValue() > CropSlider.this.getTrimEndValue()) {
                        CropSlider.this.setTrimStartValue(MathTools.clamp((double)CropSlider.this.getTrimStartValue(), (double)CropSlider.this.getMin(), (double)CropSlider.this.getTrimEndValue()));
                    }
                    CropSlider.this.notifyAccessibleAttributeChanged(AccessibleAttribute.VALUE);
                }

                public Object getBean() {
                    return CropSlider.this;
                }

                public String getName() {
                    return "trimStartValue";
                }
            };
        }
        return this.trimStartValue;
    }

    public final void setTrimEndValue(double value) {
        if (!this.trimEndValueProperty().isBound()) {
            this.trimEndValueProperty().set(value);
        }
    }

    public final double getTrimEndValue() {
        return this.trimEndValue == null ? 0.0 : this.trimEndValue.get();
    }

    public final DoubleProperty trimEndValueProperty() {
        if (this.trimEndValue == null) {
            this.trimEndValue = new DoublePropertyBase(this.getMax()){

                protected void invalidated() {
                    if (CropSlider.this.getTrimEndValue() < CropSlider.this.getTrimStartValue() || CropSlider.this.getTrimEndValue() > CropSlider.this.getMax()) {
                        CropSlider.this.setTrimEndValue(MathTools.clamp((double)CropSlider.this.getTrimEndValue(), (double)CropSlider.this.getTrimStartValue(), (double)CropSlider.this.getMax()));
                    }
                    CropSlider.this.notifyAccessibleAttributeChanged(AccessibleAttribute.VALUE);
                }

                public Object getBean() {
                    return CropSlider.this;
                }

                public String getName() {
                    return "trimEndValue";
                }
            };
        }
        return this.trimEndValue;
    }

    public final void setTrimStartValueChanging(boolean trimStartValue) {
        this.trimStartValueChangingProperty().set(trimStartValue);
    }

    public final boolean isTrimStartValueChanging() {
        return this.trimStartValueChanging == null ? false : this.trimStartValueChanging.get();
    }

    public final BooleanProperty trimStartValueChangingProperty() {
        if (this.trimStartValueChanging == null) {
            this.trimStartValueChanging = new SimpleBooleanProperty((Object)this, "trimStartValueChanging", false);
        }
        return this.trimStartValueChanging;
    }

    public final void setTrimEndValueChanging(boolean trimEndValue) {
        this.trimEndValueChangingProperty().set(trimEndValue);
    }

    public final boolean isTrimEndValueChanging() {
        return this.trimEndValueChanging == null ? false : this.trimEndValueChanging.get();
    }

    public final BooleanProperty trimEndValueChangingProperty() {
        if (this.trimEndValueChanging == null) {
            this.trimEndValueChanging = new SimpleBooleanProperty((Object)this, "trimEndValueChanging", false);
        }
        return this.trimEndValueChanging;
    }

    public void adjustTrimStartValue(double newValue) {
        this.adjustValue(newValue, this.trimStartValue);
    }

    public void adjustTrimEndValue(double newValue) {
        this.adjustValue(newValue, this.trimEndValue);
    }

    public void adjustValue(double newValue, DoubleProperty valueToAdjust) {
        double _min = this.getMin();
        double _max = this.getMax();
        if (_max <= _min) {
            return;
        }
        newValue = newValue < _min ? _min : newValue;
        newValue = newValue > _max ? _max : newValue;
        valueToAdjust.set(this.snapValueToTicks(newValue));
    }

    private double snapValueToTicks(double val) {
        double v = val;
        if (this.isSnapToTicks()) {
            double tickSpacing = 0.0;
            tickSpacing = this.getMinorTickCount() != 0 ? this.getMajorTickUnit() / (double)(Math.max(this.getMinorTickCount(), 0) + 1) : this.getMajorTickUnit();
            int prevTick = (int)((v - this.getMin()) / tickSpacing);
            double prevTickValue = (double)prevTick * tickSpacing + this.getMin();
            double nextTickValue = (double)(prevTick + 1) * tickSpacing + this.getMin();
            v = CropSlider.nearest(prevTickValue, v, nextTickValue);
        }
        return MathTools.clamp((double)v, (double)this.getMin(), (double)this.getMax());
    }

    public static double nearest(double less, double value, double more) {
        double lessDiff = value - less;
        double moreDiff = more - value;
        if (lessDiff < moreDiff) {
            return less;
        }
        return more;
    }
}

