/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart;

import java.io.IOException;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ListView;
import javafx.scene.control.TitledPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartMarker;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartMarkerType;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.ControllerListCell;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartBaselineEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;

public class YoChartBaselinesOptionPaneController {
    private static final double ROW_HEIGHT = 36.0;
    @FXML
    private TitledPane mainPane;
    @FXML
    private ListView<YoChartBaselineEditorPaneController> baselinesListView;
    private ObservableList<YoChartBaselineEditorPaneController> listViewItems;
    private ObservableList<ChartMarker> userMarkers;
    private boolean ignoreChanges = false;

    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.baselinesListView.setCellFactory(param -> new ControllerListCell());
        this.baselinesListView.setPrefHeight(38.0);
        this.listViewItems = this.baselinesListView.getItems();
        this.listViewItems.addListener(change -> {
            int numberOfRows = change.getList().size();
            double prefHeight = (double)numberOfRows * 36.0;
            prefHeight = EuclidCoreTools.clamp((double)prefHeight, (double)36.0, (double)360.0);
            this.baselinesListView.setPrefHeight(prefHeight + 2.0);
            if (this.ignoreChanges) {
                return;
            }
            while (change.next()) {
                if (change.wasAdded()) {
                    for (YoChartBaselineEditorPaneController newController : change.getAddedSubList()) {
                        this.userMarkers.add((Object)newController.getMarker());
                    }
                }
                if (!change.wasRemoved()) continue;
                for (YoChartBaselineEditorPaneController oldController : change.getRemoved()) {
                    this.userMarkers.remove((Object)oldController.getMarker());
                    oldController.dispose();
                }
            }
        });
    }

    public void setInput(ObservableList<ChartMarker> userMarkers) {
        this.userMarkers = userMarkers;
        this.ignoreChanges = true;
        this.listViewItems.clear();
        for (ChartMarker marker : userMarkers) {
            this.listViewItems.add((Object)this.newBaselineEditor(marker));
        }
        this.ignoreChanges = false;
    }

    @FXML
    private void addBaseline() {
        this.listViewItems.add((Object)this.newBaselineEditor(null));
    }

    private YoChartBaselineEditorPaneController newBaselineEditor(ChartMarker marker) {
        FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.CHART_BASELINE_EDITOR_PANE_URL);
        try {
            loader.load();
            YoChartBaselineEditorPaneController editor = (YoChartBaselineEditorPaneController)loader.getController();
            if (marker == null) {
                marker = new ChartMarker(ChartMarkerType.HORIZONTAL, (DoubleProperty)new SimpleDoubleProperty((Object)this, "userMarker" + this.userMarkers.size(), 0.0));
                marker.setStroke((Paint)Color.hsb((double)((double)this.userMarkers.size() * 360.0 / 4.3), (double)0.7, (double)0.8));
            }
            editor.setInput(marker, () -> this.listViewItems.remove((Object)editor));
            return editor;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TitledPane getMainPane() {
        return this.mainPane;
    }
}

