/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import java.util.LinkedHashSet;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.scene.Group;
import javafx.scene.Node;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXItem;

public class YoGroupFX
implements YoGraphicFXItem {
    private final StringProperty nameProperty = new SimpleStringProperty((Object)this, "name", null);
    private final ObjectProperty<YoGroupFX> parentGroupProperty;
    private final ObservableSet<YoGroupFX> children = FXCollections.observableSet(new LinkedHashSet());
    private final ObservableSet<YoGraphicFXItem> itemChildren = FXCollections.observableSet(new LinkedHashSet());
    private final ObservableSet<YoGraphicFX2D> yoGraphicFX2DSet = FXCollections.observableSet(new LinkedHashSet());
    private final ObservableSet<YoGraphicFX3D> yoGraphicFX3DSet = FXCollections.observableSet(new LinkedHashSet());
    private final Group group2D = new Group();
    private final Group group3D = new Group();
    private final BooleanProperty visibleProperty = new SimpleBooleanProperty((Object)this, "visible", true);

    public static YoGroupFX createGUIRoot() {
        return new YoGroupFX("root", true);
    }

    public static YoGroupFX createSessionRoot() {
        return new YoGroupFX("session", true);
    }

    private YoGroupFX(String name, boolean isRoot) {
        if (isRoot) {
            this.nameProperty.set((Object)name);
            this.parentGroupProperty = null;
            this.setupChildrenListener();
            this.setupYoGraphicFXsListener(this.yoGraphicFX2DSet, this.group2D);
            this.setupYoGraphicFXsListener(this.yoGraphicFX3DSet, this.group3D);
        } else {
            Objects.requireNonNull(name);
            this.nameProperty.set((Object)name);
            this.parentGroupProperty = new SimpleObjectProperty((Object)this, "parent", null);
            this.parentGroupProperty.addListener((observable, oldValue, newValue) -> {
                if (oldValue == null || newValue == oldValue) {
                    return;
                }
                if (oldValue != null) {
                    oldValue.children.remove((Object)this);
                }
                if (newValue != null && !newValue.children.contains((Object)this)) {
                    newValue.children.add((Object)this);
                }
            });
            this.setupChildrenListener();
            this.setupYoGraphicFXsListener(this.yoGraphicFX2DSet, this.group2D);
            this.setupYoGraphicFXsListener(this.yoGraphicFX3DSet, this.group3D);
            this.setupVisibilityBindings();
            this.group2D.visibleProperty().bind((ObservableValue)this.visibleProperty);
            this.group3D.visibleProperty().bind((ObservableValue)this.visibleProperty);
        }
    }

    public YoGroupFX(String name) {
        this(name, false);
    }

    private void setupVisibilityBindings() {
        final MutableBoolean updating = new MutableBoolean(false);
        this.visibleProperty.addListener((o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            updating.setTrue();
            this.itemChildren.forEach(child -> child.setVisible((boolean)newValue));
            updating.setFalse();
        });
        this.itemChildren.addListener((SetChangeListener)new SetChangeListener<YoGraphicFXItem>(){
            ObservableBooleanValue observable = null;
            ChangeListener<? super Boolean> changeListener = (o, oldValue, newValue) -> this.updateVisibility();

            public void onChanged(SetChangeListener.Change<? extends YoGraphicFXItem> change) {
                if (this.observable != null) {
                    this.observable.removeListener(this.changeListener);
                }
                if (change.getSet().isEmpty()) {
                    this.observable = null;
                    this.updateVisibility();
                    return;
                }
                for (YoGraphicFXItem itemChild : change.getSet()) {
                    if (this.observable == null) {
                        this.observable = itemChild.visibleProperty();
                        continue;
                    }
                    this.observable = Bindings.or((ObservableBooleanValue)this.observable, (ObservableBooleanValue)itemChild.visibleProperty());
                }
                this.observable.addListener(this.changeListener);
                this.updateVisibility();
            }

            private void updateVisibility() {
                if (updating.isTrue()) {
                    return;
                }
                updating.setTrue();
                YoGroupFX.this.visibleProperty.set(this.observable == null ? false : this.observable.get());
                updating.setFalse();
            }
        });
    }

    private void setupChildrenListener() {
        this.children.addListener(change -> {
            YoGroupFX elementAdded = (YoGroupFX)change.getElementAdded();
            YoGroupFX elementRemoved = (YoGroupFX)change.getElementRemoved();
            if (change.wasAdded() && elementAdded.getParentGroup() != this) {
                if (elementAdded == this) {
                    throw new IllegalArgumentException("Cannot add a group to its own children, group name: " + elementAdded.getFullname());
                }
                elementAdded.detachFromParent();
                elementAdded.parentGroupProperty().set((Object)this);
                this.group3D.getChildren().add((Object)elementAdded.getNode3D());
                this.group2D.getChildren().add((Object)elementAdded.getNode2D());
                this.itemChildren.add((Object)elementAdded);
            }
            if (change.wasRemoved() && elementRemoved.getParentGroup() == this) {
                elementRemoved.parentGroupProperty.set(null);
                this.group3D.getChildren().remove((Object)elementRemoved.getNode3D());
                this.group2D.getChildren().remove((Object)elementRemoved.getNode2D());
                this.itemChildren.remove((Object)elementRemoved);
            }
        });
    }

    private void setupYoGraphicFXsListener(ObservableSet<? extends YoGraphicFX> yoGraphicFXSet, Group groupToRegisterGraphicFX) {
        yoGraphicFXSet.addListener(change -> {
            YoGraphicFX elementAdded = (YoGraphicFX)change.getElementAdded();
            YoGraphicFX elementRemoved = (YoGraphicFX)change.getElementRemoved();
            if (change.wasAdded() && elementAdded.getParentGroup() != this) {
                long numberOfGraphicWithSameName = yoGraphicFXSet.stream().filter(graphic -> graphic.getName().equals(elementAdded.getName())).count();
                if (numberOfGraphicWithSameName > 1L) {
                    throw new IllegalArgumentException(elementAdded.getClass().getSimpleName() + " should have a unique name within a group, graphic causing issue: " + elementAdded.getFullname());
                }
                elementAdded.detachFromParent();
                elementAdded.parentGroupProperty().set((Object)this);
                groupToRegisterGraphicFX.getChildren().add((Object)elementAdded.getNode());
                this.itemChildren.add((Object)elementAdded);
            }
            if (change.wasRemoved() && elementRemoved.getParentGroup() == this) {
                elementRemoved.parentGroupProperty().set(null);
                groupToRegisterGraphicFX.getChildren().remove((Object)elementRemoved.getNode());
                this.itemChildren.remove((Object)elementRemoved);
            }
        });
    }

    @Override
    public void render() {
        this.yoGraphicFX2DSet.forEach(YoGraphicFXItem::render);
        this.yoGraphicFX3DSet.forEach(YoGraphicFXItem::render);
        this.children.forEach(YoGroupFX::render);
    }

    @Override
    public void computeBackground() {
        this.yoGraphicFX2DSet.forEach(YoGraphicFXItem::computeBackground);
        this.yoGraphicFX3DSet.forEach(YoGraphicFXItem::computeBackground);
        this.children.forEach(YoGroupFX::computeBackground);
    }

    @Override
    public void clear() {
        this.children.forEach(child -> child.clear());
        this.yoGraphicFX2DSet.forEach(graphic -> graphic.clear());
        this.yoGraphicFX3DSet.forEach(graphic -> graphic.clear());
        this.children.clear();
        this.yoGraphicFX2DSet.clear();
        this.yoGraphicFX3DSet.clear();
    }

    @Override
    public ObservableSet<YoGraphicFXItem> getItemChildren() {
        return this.itemChildren;
    }

    public ObservableSet<YoGraphicFX2D> getYoGraphicFX2DSet() {
        return this.yoGraphicFX2DSet;
    }

    public boolean addYoGraphicFXItem(YoGraphicFXItem yoGraphicFXItem) {
        if (yoGraphicFXItem instanceof YoGraphicFX2D) {
            return this.addYoGraphicFX2D((YoGraphicFX2D)yoGraphicFXItem);
        }
        if (yoGraphicFXItem instanceof YoGraphicFX3D) {
            return this.addYoGraphicFX3D((YoGraphicFX3D)yoGraphicFXItem);
        }
        if (yoGraphicFXItem instanceof YoGroupFX) {
            return this.addChild((YoGroupFX)yoGraphicFXItem);
        }
        throw new RuntimeException("Unexpected item type: " + yoGraphicFXItem.getClass().getSimpleName());
    }

    public boolean addYoGraphicFX2D(YoGraphicFX2D yoGraphicFX) {
        if (this.containsYoGraphicFX2D(yoGraphicFX.getName())) {
            return false;
        }
        return this.yoGraphicFX2DSet.add((Object)yoGraphicFX);
    }

    public boolean removeYoGraphicFX2D(YoGraphicFX2D yoGraphicFX) {
        return this.yoGraphicFX2DSet.remove((Object)yoGraphicFX);
    }

    public boolean containsYoGraphicFX2D(String graphicName) {
        return this.yoGraphicFX2DSet.stream().filter(graphic -> graphic.getName().equals(graphicName)).findFirst().isPresent();
    }

    public YoGraphicFX2D getYoGraphicFX2D(String graphicName) {
        return this.yoGraphicFX2DSet.stream().filter(graphic -> graphic.getName().equals(graphicName)).findFirst().orElse(null);
    }

    public ObservableSet<YoGraphicFX3D> getYoGraphicFX3DSet() {
        return this.yoGraphicFX3DSet;
    }

    public boolean addYoGraphicFX3D(YoGraphicFX3D yoGraphicFX) {
        if (this.containsYoGraphicFX3D(yoGraphicFX.getName())) {
            return false;
        }
        return this.yoGraphicFX3DSet.add((Object)yoGraphicFX);
    }

    public boolean removeYoGraphicFX3D(YoGraphicFX3D yoGraphicFX) {
        return this.yoGraphicFX3DSet.remove((Object)yoGraphicFX);
    }

    public boolean containsYoGraphicFX3D(String graphicName) {
        return this.yoGraphicFX3DSet.stream().filter(graphic -> graphic.getName().equals(graphicName)).findFirst().isPresent();
    }

    public YoGraphicFX3D getYoGraphicFX3D(String graphicName) {
        return this.yoGraphicFX3DSet.stream().filter(graphic -> graphic.getName().equals(graphicName)).findFirst().orElse(null);
    }

    @Override
    public ObjectProperty<YoGroupFX> parentGroupProperty() {
        return this.parentGroupProperty;
    }

    public void setParent(YoGroupFX yoGraphicFXGroup) {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot set the parent to the root group.");
        }
        this.parentGroupProperty.set((Object)yoGraphicFXGroup);
    }

    @Override
    public void detachFromParent() {
        if (this.isRoot()) {
            return;
        }
        YoGroupFX parentGroup = this.getParentGroup();
        if (parentGroup != null) {
            parentGroup.removeChild(this);
            this.parentGroupProperty.set(null);
        }
    }

    public ObservableSet<YoGroupFX> getChildren() {
        return this.children;
    }

    public boolean addChild(YoGroupFX yoGraphicFXGroup) {
        if (this.containsChild(yoGraphicFXGroup.getName())) {
            return false;
        }
        return this.children.add((Object)yoGraphicFXGroup);
    }

    public boolean removeChild(YoGroupFX yoGraphicFXGroup) {
        return this.children.remove((Object)yoGraphicFXGroup);
    }

    public YoGroupFX getChild(String childName) {
        return this.children.stream().filter(child -> child.getName().equals(childName)).findFirst().orElse(null);
    }

    public boolean containsChild(String childName) {
        return this.children.stream().filter(child -> childName.equals(child.getName())).findFirst().isPresent();
    }

    @Override
    public YoGroupFX clone() {
        YoGroupFX clone = new YoGroupFX((String)this.nameProperty.get());
        return clone;
    }

    @Override
    public StringProperty nameProperty() {
        return this.nameProperty;
    }

    @Override
    public BooleanProperty visibleProperty() {
        return this.visibleProperty;
    }

    public boolean isRoot() {
        return this.parentGroupProperty == null;
    }

    @Override
    public YoGroupFX getRootGroup() {
        if (this.isRoot() || this.parentGroupProperty.get() == null) {
            return this;
        }
        return ((YoGroupFX)this.parentGroupProperty.get()).getRootGroup();
    }

    public Node getNode2D() {
        return this.group2D;
    }

    public Node getNode3D() {
        return this.group3D;
    }
}

