/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.YoVariableDatabase;
import us.ihmc.scs2.sharedMemory.LinkedBufferProperties;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.scs2.sharedMemory.interfaces.LinkedYoVariableFactory;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoManager
extends ObservedAnimationTimer
implements Manager {
    private final LongProperty rootRegistryChangeCounter = new SimpleLongProperty((Object)this, "rootRegistryChangeCounter", 0L);
    private final YoRegistryChangedListener counterUpdater = changer -> this.rootRegistryChangeCounter.set(this.rootRegistryChangeCounter.get() + 1L);
    private YoRegistry rootRegistry;
    private LinkedYoRegistry linkedRootRegistry;
    private LinkedBufferProperties linkedBufferProperties;
    private LinkedYoVariableFactory linkedYoVariableFactory;
    private boolean updatingYoVariables = true;
    private YoVariableDatabase rootRegistryDatabase = null;

    @Override
    public void handleImpl(long now) {
        if (this.linkedRootRegistry != null && !this.updatingYoVariables) {
            this.linkedRootRegistry.pull();
        }
    }

    @Override
    public void startSession(Session session) {
        LogTools.info((String)"Linking YoVariables");
        this.rootRegistry = new YoRegistry("root");
        this.linkedYoVariableFactory = session.getLinkedYoVariableFactory();
        this.linkedRootRegistry = this.linkedYoVariableFactory.newLinkedYoRegistry(this.rootRegistry);
        this.linkedBufferProperties = this.linkedYoVariableFactory.newLinkedBufferProperties();
        this.updatingYoVariables = true;
        this.rootRegistry.addListener(this.counterUpdater);
        this.rootRegistryChangeCounter.set(this.rootRegistryChangeCounter.get() + 1L);
        this.rootRegistryDatabase = new YoVariableDatabase(this.rootRegistry, this.linkedRootRegistry);
        this.updatingYoVariables = false;
        LogTools.info((String)"UI linked YoVariables created");
        this.start();
    }

    @Override
    public void stopSession() {
        this.rootRegistryDatabase.dispose();
        this.rootRegistryDatabase = null;
        this.linkedYoVariableFactory = null;
        this.linkedRootRegistry = null;
        this.linkedBufferProperties = null;
        this.rootRegistry.removeListener(this.counterUpdater);
        this.rootRegistry.clear();
        this.rootRegistry = null;
        this.rootRegistryChangeCounter.set(this.rootRegistryChangeCounter.get() + 1L);
    }

    @Override
    public boolean isSessionLoaded() {
        return this.linkedRootRegistry != null && !this.updatingYoVariables;
    }

    public LinkedYoRegistry newLinkedYoRegistry(YoRegistry registry) {
        return this.linkedYoVariableFactory.newLinkedYoRegistry(registry);
    }

    public LinkedYoVariable<?> newLinkedYoVariable(YoVariable yoVariable) {
        return this.linkedYoVariableFactory.newLinkedYoVariable(yoVariable);
    }

    public YoRegistry getRootRegistry() {
        return this.rootRegistry;
    }

    public YoVariableDatabase getRootRegistryDatabase() {
        return this.rootRegistryDatabase;
    }

    public boolean isUpdatingYoVariables() {
        return this.updatingYoVariables;
    }

    public LinkedYoRegistry getLinkedRootRegistry() {
        return this.linkedRootRegistry;
    }

    public LinkedBufferProperties newLinkedBufferProperties() {
        if (this.linkedYoVariableFactory == null) {
            return null;
        }
        return this.linkedYoVariableFactory.newLinkedBufferProperties();
    }

    public LongProperty rootRegistryChangeCounter() {
        return this.rootRegistryChangeCounter;
    }

    public int getBufferSize() {
        if (this.linkedBufferProperties == null) {
            return -1;
        }
        if (this.linkedBufferProperties.peekCurrentBufferProperties() == null) {
            return -1;
        }
        return this.linkedBufferProperties.peekCurrentBufferProperties().getSize();
    }
}

