/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoComposite;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public class CompositeProperty
implements ReferenceFrameHolder {
    protected String type;
    protected String[] componentIdentifiers;
    protected DoubleProperty[] componentValueProperties;
    protected Property<ReferenceFrame> referenceFrameProperty;

    public CompositeProperty() {
    }

    public CompositeProperty(String type, String[] componentIdentifiers) {
        this.type = type;
        this.componentIdentifiers = componentIdentifiers;
    }

    public CompositeProperty(String type, String[] componentIdentifiers, double ... componentValues) {
        this(type, componentIdentifiers, null, componentValues);
    }

    public CompositeProperty(String type, String[] componentIdentifiers, ReferenceFrame referenceFrame, double ... componentValues) {
        this(type, componentIdentifiers);
        this.set(referenceFrame, componentValues);
    }

    public CompositeProperty(String type, String[] componentIdentifiers, DoubleProperty ... componentValueProperties) {
        this(type, componentIdentifiers, (Property<ReferenceFrame>)null, componentValueProperties);
    }

    public CompositeProperty(String type, String[] componentIdentifiers, Property<ReferenceFrame> referenceFrameProperty, DoubleProperty ... componentValueProperties) {
        this(type, componentIdentifiers);
        this.set(referenceFrameProperty, componentValueProperties);
    }

    public CompositeProperty(CompositeProperty other) {
        this.set(other);
    }

    public void set(CompositeProperty other) {
        this.type = other.type;
        this.componentIdentifiers = other.componentIdentifiers;
        this.componentValueProperties = Arrays.copyOf(other.componentValueProperties, other.componentValueProperties.length);
        this.referenceFrameProperty = other.referenceFrameProperty;
    }

    public final void set(ReferenceFrame referenceFrame, double ... componentValues) {
        this.setComponentValues(componentValues);
        this.setReferenceFrame(referenceFrame);
    }

    public final void set(Property<ReferenceFrame> referenceFrameProperty, DoubleProperty ... componentValueProperties) {
        this.setComponentValueProperties(componentValueProperties);
        this.setReferenceFrameProperty(referenceFrameProperty);
    }

    public final void setComponentValues(double ... componentValues) {
        this.setComponentValueProperties((DoubleProperty[])DoubleStream.of(componentValues).mapToObj(SimpleDoubleProperty::new).toArray(DoubleProperty[]::new));
    }

    public final void setComponentValueProperties(DoubleProperty ... componentValueProperties) {
        this.componentValueProperties = componentValueProperties;
    }

    public final void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.setReferenceFrameProperty((Property<ReferenceFrame>)new SimpleObjectProperty((Object)referenceFrame));
    }

    public final void setReferenceFrameProperty(Property<ReferenceFrame> referenceFrameProperty) {
        this.referenceFrameProperty = referenceFrameProperty;
    }

    public final String getType() {
        return this.type;
    }

    public final String[] getComponentIdentifiers() {
        return this.componentIdentifiers;
    }

    public final DoubleProperty[] componentValueProperties() {
        return this.componentValueProperties;
    }

    public final Property<ReferenceFrame> referenceFrameProperty() {
        return this.referenceFrameProperty;
    }

    public final ReferenceFrame getReferenceFrame() {
        return (ReferenceFrame)this.referenceFrameProperty().getValue();
    }

    public CompositeProperty clone() {
        return new CompositeProperty(this);
    }

    public Point2D toWorld2D(Point2DReadOnly transformable) {
        Point2D result = new Point2D((Tuple2DReadOnly)transformable);
        if (this.referenceFrameProperty() == null || this.getReferenceFrame() == null || this.getReferenceFrame().isRootFrame()) {
            return result;
        }
        this.getReferenceFrame().getTransformToRoot().transform((Point2DBasics)result, false);
        return result;
    }

    public Vector2D toWorld2D(Vector2DReadOnly transformable) {
        Vector2D result = new Vector2D((Tuple2DReadOnly)transformable);
        if (this.referenceFrameProperty() == null || this.getReferenceFrame() == null || this.getReferenceFrame().isRootFrame()) {
            return result;
        }
        this.getReferenceFrame().getTransformToRoot().transform((Vector2DBasics)result, false);
        return result;
    }

    public <T extends Transformable> T toWorld(T transformable) {
        if (this.referenceFrameProperty() == null || this.getReferenceFrame() == null) {
            return transformable;
        }
        this.getReferenceFrame().transformFromThisToDesiredFrame(this.getReferenceFrame().getRootFrame(), transformable);
        return transformable;
    }

    public final String toString() {
        String description = "[" + this.type;
        for (int i = 0; i < this.componentIdentifiers.length; ++i) {
            description = description + ", " + this.componentIdentifiers[i] + ": " + this.componentValueProperties[i];
        }
        description = description + ", frame: " + this.referenceFrameProperty + "]";
        return description;
    }
}

