/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem;

import java.util.List;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.RigidBodyIterable;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaBasics;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.FrameNode;

public class JavaFXRigidBody
implements RigidBodyBasics {
    private final RigidBodyBasics rigidBody;
    private final ObjectProperty<FrameNode> graphicsProperty = new SimpleObjectProperty((Object)this, "graphics", null);

    public JavaFXRigidBody(RigidBodyBasics rigidBody) {
        this.rigidBody = rigidBody;
        if (!rigidBody.isRootBody()) {
            rigidBody.getParentJoint().setSuccessor((RigidBodyBasics)this);
        }
        this.graphicsProperty.addListener((o, oldValue, newValue) -> {
            if (newValue == null || newValue.getNode() == null) {
                return;
            }
            JavaFXVisualTools.setMissingNodeIDs(newValue.getNode(), this.getName());
        });
    }

    public void updateSubtreeGraphics() {
        this.updateGraphics();
        this.subtreeStream().forEach(JavaFXRigidBody::updateGraphics);
    }

    public void updateGraphics() {
        if (this.graphicsProperty.get() != null) {
            ((FrameNode)this.graphicsProperty.get()).updatePose();
        }
    }

    public void setGraphics(FrameNode graphics) {
        this.graphicsProperty.set((Object)graphics);
    }

    public FrameNode getGraphics() {
        return (FrameNode)this.graphicsProperty.get();
    }

    public ObjectProperty<FrameNode> graphicsProperty() {
        return this.graphicsProperty;
    }

    public SpatialInertiaBasics getInertia() {
        return this.rigidBody.getInertia();
    }

    public MovingReferenceFrame getBodyFixedFrame() {
        return this.rigidBody.getBodyFixedFrame();
    }

    public JointBasics getParentJoint() {
        return this.rigidBody.getParentJoint();
    }

    public void addChildJoint(JointBasics joint) {
        this.rigidBody.addChildJoint(joint);
    }

    public List<JointBasics> getChildrenJoints() {
        return this.rigidBody.getChildrenJoints();
    }

    public String toString() {
        return this.rigidBody.toString();
    }

    public String getName() {
        return this.rigidBody.getName();
    }

    public String getNameId() {
        return this.rigidBody.getNameId();
    }

    public Iterable<? extends JavaFXRigidBody> subtreeIterable() {
        return new RigidBodyIterable(JavaFXRigidBody.class, null, (RigidBodyReadOnly)this);
    }

    public Stream<? extends JavaFXRigidBody> subtreeStream() {
        return SubtreeStreams.from(JavaFXRigidBody.class, (RigidBodyReadOnly)this);
    }
}

