/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D;

import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicCone3DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D.YoGraphicFX3DEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoConeFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;

public class YoConeFX3DEditorController
extends YoGraphicFX3DEditorController<YoConeFX3D> {
    @FXML
    private YoCompositeEditorPaneController positionEditorController;
    @FXML
    private YoCompositeEditorPaneController axisEditorController;
    @FXML
    private TextField heightTextField;
    @FXML
    private TextField radiusTextField;
    @FXML
    private ImageView heightValidImageView;
    @FXML
    private ImageView radiusValidImageView;
    private YoGraphicCone3DDefinition definitionBeforeEdits;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoConeFX3D yoGraphicToEdit) {
        super.initialize(toolkit, yoGraphicToEdit);
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicCone3DDefinition(yoGraphicToEdit);
        yoGraphicToEdit.visibleProperty().addListener((observable, oldValue, newValue) -> this.definitionBeforeEdits.setVisible(newValue.booleanValue()));
        this.setupTuple3DPropertyEditor(this.positionEditorController, "Position", true, yoGraphicToEdit.getPosition());
        this.setupTuple3DPropertyEditor(this.axisEditorController, "Axis", true, yoGraphicToEdit.getAxis());
        this.setupDoublePropertyEditor(this.heightTextField, this.heightValidImageView, YoConeFX3D::setHeight);
        this.setupDoublePropertyEditor(this.radiusTextField, this.radiusValidImageView, YoConeFX3D::setRadius);
        this.resetFields();
    }

    @Override
    protected <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals((Object)YoGraphicTools.toYoGraphicCone3DDefinition((YoConeFX3D)this.yoGraphicToEdit)));
    }

    @Override
    public void resetFields() {
        this.positionEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getPosition());
        this.axisEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getAxis());
        this.heightTextField.setText(this.definitionBeforeEdits.getHeight());
        this.radiusTextField.setText(this.definitionBeforeEdits.getRadius());
        this.styleEditorController.setInput((YoGraphic3DDefinition)this.definitionBeforeEdits);
        this.nameEditorController.setInput(this.definitionBeforeEdits.getName(), ((YoConeFX3D)this.yoGraphicToEdit).getNamespace());
    }

    @Override
    public void saveChanges() {
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicCone3DDefinition((YoConeFX3D)this.yoGraphicToEdit);
        this.hasChangesPendingProperty.set(false);
    }
}

