/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.pattern;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import javafx.animation.AnimationTimer;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ListView;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoChart.YoChartGroupModelDefinition;
import us.ihmc.scs2.definition.yoChart.YoChartIdentifierDefinition;
import us.ihmc.scs2.definition.yoComposite.YoCompositePatternDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.ControllerListCell;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.UIElement;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartGroupModelEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.pattern.YoCompositePatternControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ContextMenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ListViewTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;

public class YoCompositePatternEditorController
implements UIElement {
    private static final String NEW_COMPONENT_IDENTIFIER = "c";
    @FXML
    private VBox mainPane;
    @FXML
    private JFXTextField compositeNameTextField;
    @FXML
    private JFXCheckBox crossRegistryCompositeCheckBox;
    @FXML
    private JFXButton addComponentButton;
    @FXML
    private ListView<String> componentIdentifiersListView;
    @FXML
    private ListView<YoChartGroupModelEditorController> chartGroupModelEditorListView;
    @FXML
    private ImageView patternNameValidImageView;
    private final BooleanProperty patternNameValidityProperty = new SimpleBooleanProperty((Object)this, "patternNameValidity", false);
    private final BooleanProperty componentIdentifiersValidityProperty = new SimpleBooleanProperty((Object)this, "componentIdentifiersValidity", false);
    private final BooleanProperty chartGroupModelsValidityProperty = new SimpleBooleanProperty((Object)this, "chartGroupModelsValidity", true);
    private final BooleanBinding inputsValidityProperty = this.patternNameValidityProperty.and((ObservableBooleanValue)this.componentIdentifiersValidityProperty).and((ObservableBooleanValue)this.chartGroupModelsValidityProperty);
    private final ObjectProperty<YoCompositePatternDefinition> patternDefinitionProperty = new SimpleObjectProperty((Object)this, "patternDefinition", null);
    private YoCompositePatternDefinition definitionBeforeEdits;
    private BooleanProperty hasChangesPendingProperty = new SimpleBooleanProperty((Object)this, "hasChangesPending", false);
    private List<String> nameOfOtherPatterns = new ArrayList<String>();
    private SessionVisualizerToolkit toolkit;
    private AnimationTimer prefHeightAdjustmentAnimation;

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.toolkit = toolkit;
        this.compositeNameTextField.textProperty().addListener((o, oldValue, newValue) -> {
            YoCompositePatternDefinition newPattern = new YoCompositePatternDefinition((YoCompositePatternDefinition)this.patternDefinitionProperty.get());
            newPattern.setName(newValue);
            this.patternDefinitionProperty.set((Object)newPattern);
        });
        this.crossRegistryCompositeCheckBox.selectedProperty().addListener((o, oldValue, newValue) -> {
            YoCompositePatternDefinition newPattern = new YoCompositePatternDefinition((YoCompositePatternDefinition)this.patternDefinitionProperty.get());
            newPattern.setCrossRegistry(newValue.booleanValue());
            this.patternDefinitionProperty.set((Object)newPattern);
        });
        this.componentIdentifiersListView.setCellFactory(param -> new TextFieldListCell((StringConverter)new DefaultStringConverter()));
        this.componentIdentifiersListView.getItems().addListener(change -> {
            YoCompositePatternDefinition newPattern = new YoCompositePatternDefinition((YoCompositePatternDefinition)this.patternDefinitionProperty.get());
            newPattern.setIdentifiers(new ArrayList(change.getList()));
        });
        this.componentIdentifiersListView.getItems().addListener(change -> {
            YoCompositePatternDefinition newPattern = new YoCompositePatternDefinition((YoCompositePatternDefinition)this.patternDefinitionProperty.get());
            while (change.next()) {
                if (change.wasPermutated()) {
                    for (int oldIndex = change.getFrom(); oldIndex < change.getTo(); ++oldIndex) {
                        int newIndex = change.getPermutation(oldIndex);
                        Collections.swap(newPattern.getIdentifiers(), oldIndex, newIndex);
                        for (YoChartGroupModelDefinition model : newPattern.getPreferredConfigurations()) {
                            Collections.swap(model.getChartIdentifiers(), oldIndex, newIndex);
                        }
                    }
                } else if (change.wasUpdated()) {
                    LogTools.error((String)"wasUpdated is not handled!");
                } else if (change.wasReplaced()) {
                    for (int i = change.getFrom(); i < change.getTo(); ++i) {
                        newPattern.getIdentifiers().set(i, change.getList().get(i));
                    }
                } else {
                    if (change.wasRemoved()) {
                        for (int i = 0; i < change.getRemovedSize(); ++i) {
                            newPattern.getIdentifiers().remove(change.getFrom());
                            for (YoChartGroupModelDefinition model : newPattern.getPreferredConfigurations()) {
                                model.getChartIdentifiers().remove(change.getFrom());
                            }
                        }
                    }
                    if (change.wasAdded()) {
                        for (int i = change.getFrom(); i < change.getTo(); ++i) {
                            newPattern.getIdentifiers().add(i, change.getList().get(i));
                            for (YoChartGroupModelDefinition model : newPattern.getPreferredConfigurations()) {
                                model.getChartIdentifiers().add(i, new YoChartIdentifierDefinition());
                            }
                        }
                    }
                }
                this.patternDefinitionProperty.set((Object)newPattern);
                ObservableList chartGroupModelControllers = this.chartGroupModelEditorListView.getItems();
                for (int i = 0; i < chartGroupModelControllers.size(); ++i) {
                    YoChartGroupModelEditorController controller = (YoChartGroupModelEditorController)chartGroupModelControllers.get(i);
                    YoChartGroupModelDefinition chartGroupModel = (YoChartGroupModelDefinition)newPattern.getPreferredConfigurations().get(i);
                    controller.setInput(chartGroupModel, newPattern.getIdentifiers());
                }
            }
        });
        this.chartGroupModelEditorListView.setCellFactory(param -> new ControllerListCell());
        this.chartGroupModelEditorListView.getItems().addListener(change -> {
            ObservableList newList = change.getList();
            YoCompositePatternDefinition newPattern = new YoCompositePatternDefinition((YoCompositePatternDefinition)this.patternDefinitionProperty.get());
            List newPreferredConfigurations = newList.stream().map(controller -> (YoChartGroupModelDefinition)controller.chartGroupModelProperty().get()).collect(Collectors.toList());
            newPattern.setPreferredConfigurations(newPreferredConfigurations);
            this.patternDefinitionProperty.set((Object)newPattern);
            for (int i = 0; i < newList.size(); ++i) {
                int indexFinal = i;
                ((YoChartGroupModelEditorController)newList.get(i)).chartGroupModelProperty().addListener((o, oldValue, newValue) -> {
                    YoCompositePatternDefinition updatedPattern = new YoCompositePatternDefinition((YoCompositePatternDefinition)this.patternDefinitionProperty.get());
                    updatedPattern.getPreferredConfigurations().set(indexFinal, newValue);
                    this.patternDefinitionProperty.set((Object)updatedPattern);
                });
            }
        });
        this.setupValidityProperties();
        this.patternDefinitionProperty.addListener((o, oldValue, newValue) -> this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals(newValue)));
        IntFunction<String> addAction = index -> {
            this.startEditingComponentIdentifier(index);
            return NEW_COMPONENT_IDENTIFIER + index;
        };
        ContextMenuTools.setupContextMenu(this.componentIdentifiersListView, new Function[]{ListViewTools.addBeforeMenuItemFactory(addAction), ListViewTools.addAfterMenuItemFactory(addAction), ListViewTools.removeMenuItemFactory(false)});
        ContextMenuTools.setupContextMenu(this.chartGroupModelEditorListView, new Function[]{ListViewTools.addBeforeMenuItemFactory(() -> this.newYoChartGroupModelEditor()), ListViewTools.addAfterMenuItemFactory(() -> this.newYoChartGroupModelEditor()), ListViewTools.removeMenuItemFactory(false)});
        this.setPrefHeight();
    }

    private void setupValidityProperties() {
        YoGraphicFXControllerTools.bindValidityImageView((ObservableBooleanValue)this.patternNameValidityProperty, this.patternNameValidImageView);
        this.compositeNameTextField.textProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == null || newValue.isEmpty()) {
                this.patternNameValidityProperty.set(false);
            } else {
                this.patternNameValidityProperty.set(!this.nameOfOtherPatterns.contains(newValue));
            }
        });
        this.componentIdentifiersListView.setStyle(YoCompositePatternControllerTools.getValidityStyleBorder(this.componentIdentifiersValidityProperty.get()));
        this.componentIdentifiersValidityProperty.addListener((o, oldValue, newValue) -> this.componentIdentifiersListView.setStyle(YoCompositePatternControllerTools.getValidityStyleBorder(newValue)));
        this.componentIdentifiersListView.getItems().addListener(change -> this.componentIdentifiersValidityProperty.set(YoCompositePatternControllerTools.areComponentIdentifierNamesValid((List<? extends String>)change.getList())));
        this.chartGroupModelEditorListView.setStyle(YoCompositePatternControllerTools.getValidityStyleBorder(this.chartGroupModelsValidityProperty.get()));
        this.chartGroupModelsValidityProperty.addListener((o, oldValue, newValue) -> this.chartGroupModelEditorListView.setStyle(YoCompositePatternControllerTools.getValidityStyleBorder(newValue)));
        this.chartGroupModelEditorListView.getItems().addListener(change -> {
            if (change.getList().isEmpty()) {
                this.chartGroupModelsValidityProperty.set(true);
                return;
            }
            while (change.next() && change.wasAdded()) {
                for (YoChartGroupModelEditorController controller : change.getAddedSubList()) {
                    controller.configurationNameProperty().addListener((o, oldValue, newValue) -> this.chartGroupModelsValidityProperty.set(YoCompositePatternControllerTools.areChartGroupModelNamesValid((List<? extends YoChartGroupModelEditorController>)this.chartGroupModelEditorListView.getItems())));
                }
            }
            this.chartGroupModelsValidityProperty.set(YoCompositePatternControllerTools.areChartGroupModelNamesValid((List<? extends YoChartGroupModelEditorController>)change.getList()));
        });
    }

    public void setInput(YoCompositePatternDefinition definitionBeforeEdits) {
        this.definitionBeforeEdits = definitionBeforeEdits;
        this.resetFields();
    }

    public void saveChanges() {
        this.definitionBeforeEdits = new YoCompositePatternDefinition((YoCompositePatternDefinition)this.patternDefinitionProperty.get());
        this.hasChangesPendingProperty.set(false);
    }

    public void resetFields() {
        this.compositeNameTextField.setText(this.definitionBeforeEdits.getName());
        this.crossRegistryCompositeCheckBox.setSelected(this.definitionBeforeEdits.isCrossRegistry());
        ObservableList idsListItems = this.componentIdentifiersListView.getItems();
        while (idsListItems.size() < this.definitionBeforeEdits.getIdentifiers().size()) {
            this.addComponent(false);
        }
        while (idsListItems.size() > this.definitionBeforeEdits.getIdentifiers().size()) {
            idsListItems.remove(idsListItems.size() - 1);
        }
        for (int i = 0; i < idsListItems.size(); ++i) {
            idsListItems.set(i, this.definitionBeforeEdits.getIdentifiers().get(i));
        }
        ObservableList modelListItems = this.chartGroupModelEditorListView.getItems();
        while (modelListItems.size() < this.definitionBeforeEdits.getPreferredConfigurations().size()) {
            this.addChartGroupModel();
        }
        while (modelListItems.size() > this.definitionBeforeEdits.getPreferredConfigurations().size()) {
            YoChartGroupModelEditorController removedController = (YoChartGroupModelEditorController)modelListItems.remove(modelListItems.size() - 1);
            removedController.closeAndDispose();
        }
        for (int i = 0; i < modelListItems.size(); ++i) {
            ((YoChartGroupModelEditorController)modelListItems.get(i)).setInput((YoChartGroupModelDefinition)this.definitionBeforeEdits.getPreferredConfigurations().get(i), this.definitionBeforeEdits.getIdentifiers());
        }
    }

    private void setPrefHeight() {
        if (this.prefHeightAdjustmentAnimation == null) {
            this.prefHeightAdjustmentAnimation = new ObservedAnimationTimer(this.getClass().getSimpleName()){

                @Override
                public void handleImpl(long now) {
                    double minHeight;
                    if (YoCompositePatternEditorController.this.componentIdentifiersListView.getItems().isEmpty()) {
                        YoCompositePatternEditorController.this.componentIdentifiersListView.setMinHeight(0.0);
                        YoCompositePatternEditorController.this.componentIdentifiersListView.setMaxHeight(0.0);
                        YoCompositePatternEditorController.this.componentIdentifiersListView.setPrefHeight(0.0);
                    } else {
                        minHeight = 24.0;
                        int size = YoCompositePatternEditorController.this.componentIdentifiersListView.getItems().size();
                        YoCompositePatternEditorController.this.componentIdentifiersListView.setMinHeight(0.5 * (double)size * minHeight);
                        YoCompositePatternEditorController.this.componentIdentifiersListView.setPrefHeight((double)size * minHeight);
                        YoCompositePatternEditorController.this.componentIdentifiersListView.setMaxHeight(2.0 * (double)size * minHeight);
                    }
                    if (YoCompositePatternEditorController.this.chartGroupModelEditorListView.getItems().isEmpty()) {
                        YoCompositePatternEditorController.this.chartGroupModelEditorListView.setMinHeight(0.0);
                        YoCompositePatternEditorController.this.chartGroupModelEditorListView.setMaxHeight(0.0);
                        YoCompositePatternEditorController.this.chartGroupModelEditorListView.setPrefHeight(0.0);
                    } else {
                        minHeight = ((YoChartGroupModelEditorController)YoCompositePatternEditorController.this.chartGroupModelEditorListView.getItems().get(0)).getMainPane().getHeight() + 10.0;
                        YoCompositePatternEditorController.this.chartGroupModelEditorListView.setMinHeight(minHeight);
                        YoCompositePatternEditorController.this.chartGroupModelEditorListView.setPrefHeight(minHeight);
                        YoCompositePatternEditorController.this.chartGroupModelEditorListView.setMaxHeight(2.0 * minHeight);
                    }
                }
            };
        }
        this.prefHeightAdjustmentAnimation.start();
    }

    public YoCompositePatternDefinition getDefinitionBeforeEdits() {
        return this.definitionBeforeEdits;
    }

    public ObjectProperty<YoCompositePatternDefinition> patternDefinitionProperty() {
        return this.patternDefinitionProperty;
    }

    public void startEditingCompositePatternName() {
        this.compositeNameTextField.requestFocus();
    }

    @FXML
    private void addComponent() {
        this.addComponent(true);
    }

    private void addComponent(boolean startEditing) {
        int newItemIndex = this.componentIdentifiersListView.getItems().size();
        this.componentIdentifiersListView.getItems().add(newItemIndex, (Object)(NEW_COMPONENT_IDENTIFIER + newItemIndex));
        if (startEditing) {
            this.startEditingComponentIdentifier(newItemIndex);
        }
    }

    public void startEditingComponentIdentifier(int editIndex) {
        JavaFXMissingTools.runNFramesLater(1, () -> {
            this.componentIdentifiersListView.requestFocus();
            this.componentIdentifiersListView.getSelectionModel().select(editIndex);
            this.componentIdentifiersListView.edit(editIndex);
        });
    }

    @FXML
    private void addChartGroupModel() {
        this.chartGroupModelEditorListView.getItems().add((Object)this.newYoChartGroupModelEditor());
    }

    private YoChartGroupModelEditorController newYoChartGroupModelEditor() {
        YoChartGroupModelDefinition initialModel = new YoChartGroupModelDefinition("New Chart Group Model");
        while (initialModel.getChartIdentifiers().size() < ((YoCompositePatternDefinition)this.patternDefinitionProperty.get()).getIdentifiers().size()) {
            initialModel.getChartIdentifiers().add(new YoChartIdentifierDefinition());
        }
        return this.newYoChartGroupModelEditor(initialModel);
    }

    private YoChartGroupModelEditorController newYoChartGroupModelEditor(YoChartGroupModelDefinition initialModel) {
        FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.CHART_GROUP_MODEL_EDITOR_PANE_URL);
        try {
            loader.load();
            YoChartGroupModelEditorController editor = (YoChartGroupModelEditorController)loader.getController();
            editor.initialize(this.toolkit);
            if (initialModel != null) {
                editor.setInput(initialModel, ((YoCompositePatternDefinition)this.patternDefinitionProperty.get()).getIdentifiers());
            }
            JavaFXMissingTools.runNFramesLater(1, () -> editor.startEditingChartGroupModelName());
            return editor;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setNameOfOtherPatterns(List<String> names) {
        this.nameOfOtherPatterns.clear();
        this.nameOfOtherPatterns.addAll(names);
    }

    public BooleanExpression inputsValidityProperty() {
        return this.inputsValidityProperty;
    }

    public boolean hasChangesPending() {
        return this.hasChangesPendingProperty.get();
    }

    public ReadOnlyBooleanProperty hasChangesPendingProperty() {
        return this.hasChangesPendingProperty;
    }

    public void closeAndDispose() {
        this.prefHeightAdjustmentAnimation.stop();
    }

    public VBox getMainPane() {
        return this.mainPane;
    }
}

