/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.apache.commons.lang3.mutable.MutableObject;
import us.ihmc.javaFXToolkit.cameraControllers.CameraZoomCalculator;
import us.ihmc.javaFXToolkit.cameraControllers.FocusBasedCameraMouseEventHandler;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.DefinitionIOTools;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.CameraObjectTrackingRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.MainWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.SceneVideoRecordingRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerControls;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.MultiSessionManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.plotter.Plotter2D;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.BufferedJavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.CameraTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXApplicationCreator;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;

public class SessionVisualizer {
    public static final String NO_ACTIVE_SESSION_TITLE = "No Active Session";
    private final SessionVisualizerToolkit toolkit;
    private final MultiSessionManager multiSessionManager;
    private final Group view3DRoot;
    private final Plotter2D plotter2D = new Plotter2D();
    private final MainWindowController mainWindowController;
    private final FocusBasedCameraMouseEventHandler cameraController;
    private final BufferedJavaFXMessager messager;
    private final SessionVisualizerTopics topics;
    private final SessionVisualizerControlsImpl sessionVisualizerControls = new SessionVisualizerControlsImpl();
    private final List<Runnable> stopListeners = new ArrayList<Runnable>();
    private final Stage primaryStage;
    private boolean hasTerminated = false;

    public SessionVisualizer(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        primaryStage.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, this::stop);
        SessionVisualizerIOTools.addSCSIconToWindow((Window)primaryStage);
        primaryStage.setTitle(NO_ACTIVE_SESSION_TITLE);
        View3DFactory view3DFactory = View3DFactory.createSubscene();
        this.view3DRoot = view3DFactory.getRoot();
        view3DFactory.addDefaultLighting();
        this.toolkit = new SessionVisualizerToolkit(primaryStage, view3DFactory.getSubScene(), this.view3DRoot);
        this.messager = this.toolkit.getMessager();
        this.topics = this.toolkit.getTopics();
        FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.MAIN_WINDOW_URL);
        Parent mainPane = (Parent)loader.load();
        this.mainWindowController = (MainWindowController)((Object)loader.getController());
        this.mainWindowController.initialize(new SessionVisualizerWindowToolkit(primaryStage, this.toolkit));
        view3DFactory.addNodeToView((Node)this.toolkit.getYoRobotFXManager().getRootNode());
        view3DFactory.addNodeToView((Node)this.toolkit.getEnvironmentManager().getRootNode());
        this.cameraController = view3DFactory.addCameraController(0.05, 200000.0, true);
        CameraTools.setupNodeTrackingContextMenu(this.cameraController, view3DFactory.getSubScene());
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getCameraTrackObject(), request -> {
            if (request.getNode() != null) {
                this.cameraController.getNodeTracker().setNodeToTrack(request.getNode());
            }
        });
        this.toolkit.getEnvironmentManager().addWorldCoordinateSystem(0.3);
        this.toolkit.getEnvironmentManager().addSkybox(view3DFactory.getSubScene());
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getSessionVisualizerCloseRequest(), m -> this.stop());
        this.mainWindowController.setupPlotter2D(this.plotter2D);
        view3DFactory.addNodeToView(this.toolkit.getYoGraphicFXManager().getRootNode3D());
        this.mainWindowController.setupViewport3D(view3DFactory.getSubSceneWrappedInsidePane());
        Scene mainScene = new Scene(mainPane, 1024.0, 768.0);
        this.toolkit.getSnapshotManager().registerRecordable(mainScene);
        primaryStage.setScene(mainScene);
        this.multiSessionManager = new MultiSessionManager(this.toolkit, this.mainWindowController);
        this.mainWindowController.start();
        this.toolkit.start();
        primaryStage.show();
    }

    public void startSession(Session session) {
        Runnable sessionLoadedCallback = () -> this.sessionVisualizerControls.visualizerReadyLatch.countDown();
        this.multiSessionManager.startSession(session, sessionLoadedCallback);
    }

    public void stop() {
        this.stop(null);
    }

    public void stop(WindowEvent event) {
        boolean saveConfiguration = false;
        if (this.toolkit.hasActiveSession()) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to save the default configuration?", new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL});
            SessionVisualizerIOTools.addSCSIconToDialog(alert);
            Optional result = alert.showAndWait();
            if (!result.isPresent() || result.get() == ButtonType.CANCEL) {
                if (event != null) {
                    event.consume();
                }
                return;
            }
            saveConfiguration = result.get() == ButtonType.YES;
        }
        this.stopNow(saveConfiguration);
    }

    private void stopNow(boolean saveConfiguration) {
        if (this.hasTerminated) {
            return;
        }
        this.hasTerminated = true;
        LogTools.info((String)"Simulation GUI is going down.");
        try {
            this.sessionVisualizerControls.visualizerShutdownLatch.countDown();
            this.cameraController.dispose();
            this.multiSessionManager.stopSession(saveConfiguration);
            this.multiSessionManager.shutdown();
            this.mainWindowController.stop();
            this.toolkit.stop();
            if (this.primaryStage.isShowing()) {
                this.primaryStage.close();
            }
            this.primaryStage.setScene(null);
            this.view3DRoot.getChildren().clear();
            this.stopListeners.forEach(Runnable::run);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AnchorPane getSceneAnchorPane() {
        return this.mainWindowController.getSceneAnchorPane();
    }

    public SessionVisualizerToolkit getToolkit() {
        return this.toolkit;
    }

    public static void main(String[] args) {
        SessionVisualizer.startSessionVisualizer(null, true);
    }

    public static SessionVisualizerControls startSessionVisualizer() {
        return SessionVisualizer.startSessionVisualizer(null);
    }

    public static SessionVisualizerControls startSessionVisualizer(Session session) {
        return SessionVisualizer.startSessionVisualizer(session, null);
    }

    public static SessionVisualizerControls startSessionVisualizer(Session session, Boolean javaFXThreadImplicitExit) {
        if (javaFXThreadImplicitExit != null && Platform.isImplicitExit() != javaFXThreadImplicitExit) {
            Platform.setImplicitExit((boolean)javaFXThreadImplicitExit);
        }
        MutableObject sessionVisualizerControls = new MutableObject();
        JavaFXApplicationCreator.spawnJavaFXMainApplication();
        JavaFXMissingTools.runAndWait(SessionVisualizer.class, () -> {
            try {
                SessionVisualizer sessionVisualizer = new SessionVisualizer(new Stage());
                sessionVisualizerControls.setValue((Object)sessionVisualizer.sessionVisualizerControls);
                if (session != null) {
                    sessionVisualizer.startSession(session);
                }
                JavaFXApplicationCreator.attachStopListener(sessionVisualizer::stop);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return (SessionVisualizerControls)sessionVisualizerControls.getValue();
    }

    static {
        DefinitionIOTools.loadResources();
        YoGraphicFXControllerTools.loadResources();
    }

    private class SessionVisualizerControlsImpl
    implements SessionVisualizerControls {
        private final CountDownLatch visualizerReadyLatch = new CountDownLatch(1);
        private final CountDownLatch visualizerShutdownLatch = new CountDownLatch(1);

        @Override
        public void waitUntilFullyUp() {
            try {
                this.visualizerReadyLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void waitUntilDown() {
            try {
                this.visualizerShutdownLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setCameraOrientation(double latitude, double longitude, double roll) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.cameraController.getRotationCalculator().setRotation(latitude, longitude, roll);
        }

        @Override
        public void setCameraPosition(double x, double y, double z) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.cameraController.changeCameraPosition(x, y, z);
        }

        @Override
        public void setCameraFocusPosition(double x, double y, double z) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.cameraController.changeFocusPosition(x, y, z, false);
        }

        @Override
        public void setCameraZoom(double distanceFromFocus) {
            this.checkVisualizerRunning();
            CameraZoomCalculator zoomCalculator = SessionVisualizer.this.cameraController.getZoomCalculator();
            if (zoomCalculator.isInvertZoomDirection()) {
                distanceFromFocus = -distanceFromFocus;
            }
            zoomCalculator.setZoom(distanceFromFocus);
        }

        @Override
        public void requestCameraRigidBodyTracking(String robotName, String rigidBodyName) {
            this.checkVisualizerRunning();
            this.waitUntilFullyUp();
            SessionVisualizer.this.messager.submitMessage(SessionVisualizer.this.topics.getCameraTrackObject(), new CameraObjectTrackingRequest(robotName, rigidBodyName));
        }

        @Override
        public void addStaticVisual(VisualDefinition visualDefinition) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.toolkit.getEnvironmentManager().addStaticVisual(visualDefinition);
        }

        @Override
        public void addYoGraphic(String namespace, YoGraphicDefinition yoGraphicDefinition) {
            String[] subNames = namespace.split(":");
            if (subNames == null || subNames.length == 0) {
                this.addYoGraphic(yoGraphicDefinition);
            }
            for (int i = subNames.length - 1; i >= 0; --i) {
                yoGraphicDefinition = new YoGraphicGroupDefinition(subNames[i], new YoGraphicDefinition[]{yoGraphicDefinition});
            }
            this.addYoGraphic(yoGraphicDefinition);
        }

        @Override
        public void addYoGraphic(YoGraphicDefinition yoGraphicDefinition) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.messager.submitMessage(SessionVisualizer.this.topics.getAddYoGraphicRequest(), yoGraphicDefinition);
        }

        @Override
        public void exportVideo(SceneVideoRecordingRequest request) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.messager.submitMessage(SessionVisualizer.this.topics.getSceneVideoRecordingRequest(), request);
        }

        @Override
        public void shutdown() {
            JavaFXMissingTools.runAndWait(this.getClass(), () -> SessionVisualizer.this.stop());
        }

        @Override
        public void shutdownNow() {
            JavaFXMissingTools.runAndWait(this.getClass(), () -> SessionVisualizer.this.stopNow(false));
        }

        @Override
        public void addVisualizerShutdownListener(Runnable listener) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.stopListeners.add(listener);
        }

        private void checkVisualizerRunning() {
            if (SessionVisualizer.this.hasTerminated) {
                throw new IllegalOperationException("Unable to perform operation, visualizer has terminated.");
            }
        }
    }
}

