/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javax.xml.bind.JAXBException;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.scs2.definition.configuration.SCSGuiConfigurationDefinition;
import us.ihmc.scs2.definition.configuration.WindowConfigurationDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SecondaryWindowManager;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;

public class SCSGuiConfiguration {
    private final Path configurationFolderPath;
    private final String mainConfigurationFilename;
    private String yoGraphicsFilename;
    private String yoCompositeFilename;
    private String yoEntryConfigurationFilename;
    private String yoSliderboardConfigurationFilename;
    private String mainYoChartGroupFilename;
    private final List<String> secondaryYoChartGroupFilenames = new ArrayList<String>();
    private final Path mainConfigurationPath;
    private Path yoGraphicsPath;
    private Path yoCompositePath;
    private Path yoEntryConfigurationPath;
    private Path yoSliderboardConfigurationPath;
    private Path mainYoChartGroupPath;
    private final List<Path> secondaryYoChartGroupPaths = new ArrayList<Path>();
    private SCSGuiConfigurationDefinition definition;

    public static SCSGuiConfiguration defaultLoader(String robotName, String simulationName) {
        try {
            return new SCSGuiConfiguration(robotName, simulationName, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SCSGuiConfiguration defaultSaver(String robotName, String simulationName) {
        try {
            return new SCSGuiConfiguration(robotName, simulationName, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SCSGuiConfiguration saverToDirectory(String robotName, String simulationName, File configurationDirectory) {
        try {
            return new SCSGuiConfiguration(configurationDirectory.toPath(), robotName + "-" + simulationName, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SCSGuiConfiguration loaderFromDirectory(String robotName, String simulationName, File configurationDirectory) {
        try {
            return new SCSGuiConfiguration(configurationDirectory.toPath(), robotName + "-" + simulationName, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SCSGuiConfiguration(String robotName, String simulationName, boolean isLoading) throws IOException, JAXBException {
        this(Paths.get(SessionVisualizerIOTools.SCS2_CONFIGURATION_DEFAULT_PATH.toString(), robotName, simulationName), robotName + "-" + simulationName, isLoading);
    }

    private SCSGuiConfiguration(Path configurationFolderPath, String configurationName, boolean isLoading) throws IOException, JAXBException {
        this.configurationFolderPath = configurationFolderPath;
        this.mainConfigurationFilename = isLoading ? (this.toPath(this.toFilename("Main", ".scs2")).toFile().exists() ? this.toFilename("Main", ".scs2") : this.toFilename("Main", ".scs2.main")) : this.toFilename("Main", ".scs2.main");
        this.mainConfigurationPath = this.toPath(this.mainConfigurationFilename);
        if (isLoading) {
            if (this.mainConfigurationPath.toFile().exists()) {
                try {
                    this.definition = XMLTools.loadSCSGuiConfigurationDefinition(new FileInputStream(this.mainConfigurationPath.toFile()));
                    this.yoGraphicsFilename = this.definition.getYoGraphicsFilename();
                    this.yoCompositeFilename = this.definition.getYoCompositePatternListFilename();
                    this.yoEntryConfigurationFilename = this.definition.getYoEntryConfigurationFilename();
                    this.yoSliderboardConfigurationFilename = this.definition.getYoSliderboardConfigurationFilename();
                    this.mainYoChartGroupFilename = this.definition.getMainYoChartGroupConfigurationFilename();
                    if (this.definition.getSecondaryYoChartGroupConfigurationsFilenames() != null) {
                        this.secondaryYoChartGroupFilenames.addAll(this.definition.getSecondaryYoChartGroupConfigurationsFilenames());
                    }
                    this.yoGraphicsPath = this.toPath(this.yoGraphicsFilename);
                    this.yoCompositePath = this.toPath(this.yoCompositeFilename);
                    this.yoEntryConfigurationPath = this.toPath(this.yoEntryConfigurationFilename);
                    this.yoSliderboardConfigurationPath = this.toPath(this.yoSliderboardConfigurationFilename);
                    this.mainYoChartGroupPath = this.toPath(this.mainYoChartGroupFilename);
                    for (String filename : this.secondaryYoChartGroupFilenames) {
                        this.secondaryYoChartGroupPaths.add(this.toPath(filename));
                    }
                    for (int i = this.secondaryYoChartGroupFilenames.size() - 1; i >= 0; --i) {
                        if (this.secondaryYoChartGroupPaths.get(i).toFile().exists()) continue;
                        this.secondaryYoChartGroupFilenames.remove(i);
                        this.secondaryYoChartGroupPaths.remove(i);
                    }
                }
                catch (FileNotFoundException | JAXBException e) {
                    e.printStackTrace();
                }
            }
        } else {
            FileTools.ensureFileExists((Path)this.mainConfigurationPath);
            this.yoGraphicsFilename = this.toFilename("YoGraphics", ".scs2.yoGraphic");
            this.yoCompositeFilename = this.toFilename("YoComposite", ".scs2.yoComposite");
            this.yoEntryConfigurationFilename = this.toFilename("YoEntry", ".scs2.yoEntry");
            this.yoSliderboardConfigurationFilename = this.toFilename("YoSliderboard", ".scs2.yoSliderboard");
            this.mainYoChartGroupFilename = this.toFilename("MainYoChartGroup", ".scs2.chart");
            this.yoGraphicsPath = this.toPath(this.yoGraphicsFilename);
            this.yoCompositePath = this.toPath(this.yoCompositeFilename);
            this.yoEntryConfigurationPath = this.toPath(this.yoEntryConfigurationFilename);
            this.yoSliderboardConfigurationPath = this.toPath(this.yoSliderboardConfigurationFilename);
            this.mainYoChartGroupPath = this.toPath(this.mainYoChartGroupFilename);
            this.definition = new SCSGuiConfigurationDefinition();
            this.definition.setName(configurationName);
            this.definition.setYoGraphicsFilename(this.yoGraphicsFilename);
            this.definition.setYoCompositePatternListFilename(this.yoCompositeFilename);
            this.definition.setYoEntryConfigurationFilename(this.yoEntryConfigurationFilename);
            this.definition.setYoSliderboardConfigurationFilename(this.yoSliderboardConfigurationFilename);
            this.definition.setMainYoChartGroupConfigurationFilename(this.mainYoChartGroupFilename);
            this.definition.setSecondaryYoChartGroupConfigurationsFilenames(this.secondaryYoChartGroupFilenames);
        }
    }

    public void setBufferSize(int bufferSize) {
        this.definition.setBufferSize(bufferSize);
    }

    public void setRecordTickPeriod(int recordTickPeriod) {
        this.definition.setRecordTickPeriod(recordTickPeriod);
    }

    public void setNumberPrecision(int numberPrecision) {
        this.definition.setNumberPrecision(numberPrecision);
    }

    public void setShowOverheadPlotter(boolean showOverheadPlotter) {
        this.definition.setShowOverheadPlotter(showOverheadPlotter);
    }

    public void setShowAdvancedControls(boolean showAdvancedControls) {
        this.definition.setShowAdvancedControls(showAdvancedControls);
    }

    public void setMainStage(Stage stage) {
        this.definition.setMainWindowConfiguration(SCSGuiConfiguration.toWindowConfigurationDefinition(stage));
    }

    public void addSecondaryWindowConfiguration(WindowConfigurationDefinition definitionConfigurationDefinition) {
        if (this.definition.getSecondaryWindowConfigurations() == null) {
            this.definition.setSecondaryWindowConfigurations(new ArrayList());
        }
        this.definition.getSecondaryWindowConfigurations().add(definitionConfigurationDefinition);
    }

    public void setSecondaryWindowConfigurations(List<WindowConfigurationDefinition> secondaryWindowConfigurations) {
        this.definition.setSecondaryWindowConfigurations(secondaryWindowConfigurations);
    }

    public void setSecondaryWindows(List<Stage> stages) {
        List<WindowConfigurationDefinition> definitions = stages.stream().map(SCSGuiConfiguration::toWindowConfigurationDefinition).collect(Collectors.toList());
        this.setSecondaryWindowConfigurations(definitions);
    }

    public boolean exists() {
        return this.mainConfigurationPath.toFile().exists();
    }

    public void writeConfiguration() {
        try {
            XMLTools.saveSCSGuiConfigurationDefinition(new FileOutputStream(this.getMainConfigurationFile()), this.definition);
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    public boolean hasYoGraphicsConfiguration() {
        return this.yoGraphicsPath != null && this.yoGraphicsPath.toFile().exists();
    }

    public boolean hasYoCompositeConfiguration() {
        return this.yoCompositePath != null && this.yoCompositePath.toFile().exists();
    }

    public boolean hasYoEntryConfiguration() {
        return this.yoEntryConfigurationPath != null && this.yoEntryConfigurationPath.toFile().exists();
    }

    public boolean hasYoSliderboardConfiguration() {
        return this.yoSliderboardConfigurationPath != null && this.yoSliderboardConfigurationPath.toFile().exists();
    }

    public boolean hasMainYoChartGroupConfiguration() {
        return this.mainYoChartGroupPath != null && this.mainYoChartGroupPath.toFile().exists();
    }

    public int getNumberOfSecondaryYoChartGroupConfigurations() {
        return this.secondaryYoChartGroupPaths.size();
    }

    public boolean hasBufferSize() {
        return this.definition != null && this.definition.getBufferSize() > 0;
    }

    public boolean hasRecordTickPeriod() {
        return this.definition != null && this.definition.getRecordTickPeriod() > 0;
    }

    public boolean hasNumberPrecision() {
        return this.definition != null && this.definition.getNumberPrecision() > 1;
    }

    public boolean hasMainWindowConfiguration() {
        return this.definition != null && this.definition.getMainWindowConfiguration() != null;
    }

    public boolean hasSecondaryWindowConfigurations() {
        return this.definition != null && this.definition.getSecondaryWindowConfigurations() != null && this.definition.getSecondaryWindowConfigurations().size() == this.getNumberOfSecondaryYoChartGroupConfigurations();
    }

    public File getMainConfigurationFile() {
        return this.mainConfigurationPath.toFile();
    }

    public File getYoGraphicsConfigurationFile() {
        return this.yoGraphicsPath.toFile();
    }

    public File getYoCompositeConfigurationFile() {
        return this.yoCompositePath.toFile();
    }

    public File getYoEntryConfigurationFile() {
        return this.yoEntryConfigurationPath.toFile();
    }

    public File getYoSliderboardConfigurationFile() {
        return this.yoSliderboardConfigurationPath.toFile();
    }

    public File getMainYoChartGroupConfigurationFile() {
        return this.mainYoChartGroupPath.toFile();
    }

    public File addSecondaryYoChartGroupConfigurationFile() {
        String filename = this.toFilename("SecondaryYoChartGroup" + this.secondaryYoChartGroupFilenames.size(), ".scs2.chart");
        this.secondaryYoChartGroupFilenames.add(filename);
        Path newPath = this.toPath(filename);
        this.secondaryYoChartGroupPaths.add(newPath);
        return newPath.toFile();
    }

    public File getSecondaryYoChartGroupConfigurationFile(int index) {
        return this.secondaryYoChartGroupPaths.get(index).toFile();
    }

    public int getBufferSize() {
        return this.definition.getBufferSize();
    }

    public int getRecordTickPeriod() {
        return this.definition.getRecordTickPeriod();
    }

    public int getNumberPrecision() {
        return this.definition.getNumberPrecision();
    }

    public boolean getShowOverheadPlotter() {
        return this.definition.isShowOverheadPlotter();
    }

    public boolean getShowAdvancedControls() {
        return this.definition.isShowAdvancedControls();
    }

    public void getMainWindowConfiguration(Stage stage) {
        SCSGuiConfiguration.loadWindowConfigurationDefinition(this.definition.getMainWindowConfiguration(), stage);
    }

    public List<WindowConfigurationDefinition> getSecondaryWindowConfigurations() {
        return this.definition.getSecondaryWindowConfigurations();
    }

    public void getSecondaryWindowConfigurations(List<Stage> stages) {
        for (int i = 0; i < this.definition.getSecondaryWindowConfigurations().size(); ++i) {
            SCSGuiConfiguration.loadWindowConfigurationDefinition((WindowConfigurationDefinition)this.definition.getSecondaryWindowConfigurations().get(i), stages.get(i));
        }
    }

    private String toFilename(String suffix, String extension) {
        return suffix + extension;
    }

    private Path toPath(String filename) {
        if (filename == null) {
            return null;
        }
        return this.configurationFolderPath.resolve(filename);
    }

    public static WindowConfigurationDefinition toWindowConfigurationDefinition(Stage stage) {
        return SecondaryWindowManager.toWindowConfigurationDefinition(stage);
    }

    public static void loadWindowConfigurationDefinition(WindowConfigurationDefinition definition, Stage stage) {
        double height;
        double width;
        double positionY;
        double positionX = definition.getPositionX();
        ObservableList screensForRectangle = Screen.getScreensForRectangle((double)positionX, (double)(positionY = definition.getPositionY()), (double)(width = definition.getWidth() > 0.0 ? definition.getWidth() : stage.getWidth()), (double)(height = definition.getHeight() > 0.0 ? definition.getHeight() : stage.getHeight()));
        if (screensForRectangle.isEmpty()) {
            Screen primary = Screen.getPrimary();
            Rectangle2D visualBounds = primary.getVisualBounds();
            width = Math.min(width, visualBounds.getWidth());
            height = Math.min(height, visualBounds.getHeight());
            positionX = 0.5 * (visualBounds.getMinX() + visualBounds.getMaxX() - width);
            positionY = 0.5 * (visualBounds.getMinY() + visualBounds.getMaxY() - height);
        }
        stage.setX(positionX);
        stage.setY(positionY);
        if (definition.isMaximized()) {
            stage.setMaximized(true);
        } else {
            stage.setWidth(width);
            stage.setHeight(height);
        }
    }
}

