/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoRobot;

import java.util.concurrent.Executor;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.util.Duration;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.JavaFXMultiBodySystemFactories;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.JavaFXRigidBody;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoRobotFX {
    private final Group rootNode = new Group();
    private final RobotDefinition robotDefinition;
    private final YoManager yoManager;
    private final ReferenceFrameManager referenceFrameManager;
    private JavaFXRigidBody rootBody;
    private final YoRegistry robotRegistry;
    private LinkedYoRegistry robotLinkedYoRegistry;
    private boolean initialize = true;

    public YoRobotFX(YoManager yoManager, ReferenceFrameManager referenceFrameManager, RobotDefinition robotDefinition) {
        this.yoManager = yoManager;
        this.referenceFrameManager = referenceFrameManager;
        this.robotDefinition = robotDefinition;
        this.robotRegistry = SharedMemoryTools.newRegistryFromNamespace((String[])new String[]{"root", robotDefinition.getName()});
    }

    public void loadRobot(Executor graphicLoader) {
        LogTools.info((String)("Loading robot: " + this.robotDefinition.getName()));
        ReferenceFrame robotRootFrame = Robot.createRobotRootFrame((RobotDefinition)this.robotDefinition, (ReferenceFrame)this.referenceFrameManager.getWorldFrame());
        this.rootBody = JavaFXMultiBodySystemFactories.toYoJavaFXMultiBodySystem((RigidBodyReadOnly)this.robotDefinition.newIntance(ReferenceFrameTools.constructARootFrame((String)"dummy")), robotRootFrame, this.robotDefinition, this.robotRegistry, graphicLoader);
        LogTools.info((String)("Loaded robot: " + this.robotDefinition.getName()));
        this.attachRobotToScene();
    }

    private void attachRobotToScene() {
        for (JavaFXRigidBody javaFXRigidBody : this.rootBody.subtreeIterable()) {
            ChangeListener listener = (o, oldValue, newValue) -> {
                if (newValue != null) {
                    if (oldValue == null) {
                        Node node = newValue.getNode();
                        node.setScaleX(0.0);
                        node.setScaleY(0.0);
                        node.setScaleZ(0.0);
                        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.25), new KeyValue[]{new KeyValue((WritableValue)node.scaleXProperty(), (Object)1.0), new KeyValue((WritableValue)node.scaleYProperty(), (Object)1.0), new KeyValue((WritableValue)node.scaleZProperty(), (Object)1.0)})});
                        timeline.setCycleCount(1);
                        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
                            newValue.updatePose();
                            timeline.playFromStart();
                            this.rootNode.getChildren().add((Object)newValue.getNode());
                        });
                    } else {
                        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.rootNode.getChildren().remove((Object)oldValue.getNode()));
                        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.rootNode.getChildren().add((Object)newValue.getNode()));
                    }
                } else if (oldValue != null) {
                    JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.rootNode.getChildren().remove((Object)oldValue.getNode()));
                }
            };
            javaFXRigidBody.graphicsProperty().addListener(listener);
            listener.changed(null, null, (Object)javaFXRigidBody.getGraphics());
        }
        this.robotLinkedYoRegistry = this.yoManager.newLinkedYoRegistry(this.robotRegistry);
        this.robotRegistry.getVariables().forEach(var -> {
            LinkedYoVariable linkYoVariable = this.robotLinkedYoRegistry.linkYoVariable(var);
            linkYoVariable.addUser((Object)this);
        });
    }

    public void render() {
        if (this.rootBody != null && this.robotLinkedYoRegistry != null && (this.robotLinkedYoRegistry.pull() || this.initialize)) {
            this.rootBody.updateFramesRecursively();
            this.rootBody.updateSubtreeGraphics();
            this.initialize = false;
        }
    }

    public RigidBodyReadOnly getRootBody() {
        return this.rootBody;
    }

    public JavaFXRigidBody findRigidBody(String rigidBodyName) {
        return (JavaFXRigidBody)MultiBodySystemTools.findRigidBody((RigidBodyBasics)this.rootBody, (String)rigidBodyName);
    }

    public RobotDefinition getRobotDefinition() {
        return this.robotDefinition;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public boolean isRobotLoaded() {
        return !this.initialize;
    }
}

