/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search.YoDoubleSpinnerValueFactory;

public class YoDoubleSpinnerValueFactoryTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testRound() {
        double actual;
        double expected;
        double valueRaw;
        double scale;
        int precision;
        int i;
        Random random = new Random(234245L);
        for (i = 0; i < 1000; ++i) {
            precision = 3;
            scale = 1000.0;
            valueRaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)1000.0);
            expected = (double)Math.round(valueRaw * scale) / scale;
            actual = YoDoubleSpinnerValueFactory.round((double)valueRaw, (long)precision);
            Assertions.assertEquals((double)expected, (double)actual);
        }
        for (i = 0; i < 1000; ++i) {
            precision = 2;
            scale = 100.0;
            valueRaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)1000.0);
            expected = (double)Math.round(valueRaw * scale) / scale;
            actual = YoDoubleSpinnerValueFactory.round((double)valueRaw, (long)precision);
            Assertions.assertEquals((double)expected, (double)actual);
        }
        for (i = 0; i < 1000; ++i) {
            precision = 1;
            scale = 10.0;
            valueRaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)1000.0);
            expected = (double)Math.round(valueRaw * scale) / scale;
            actual = YoDoubleSpinnerValueFactory.round((double)valueRaw, (long)precision);
            Assertions.assertEquals((double)expected, (double)actual);
        }
        for (i = 0; i < 1000; ++i) {
            precision = 0;
            double valueRaw2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1000.0);
            double expected2 = Math.round(valueRaw2);
            double actual2 = YoDoubleSpinnerValueFactory.round((double)valueRaw2, (long)precision);
            Assertions.assertEquals((double)expected2, (double)actual2);
        }
        int precision2 = 1;
        double valueRaw3 = 123456.7890123;
        double expected3 = 123456.8;
        double actual3 = YoDoubleSpinnerValueFactory.round((double)valueRaw3, (long)precision2);
        Assertions.assertEquals((double)expected3, (double)actual3);
        precision2 = 2;
        valueRaw3 = 123456.7890123;
        expected3 = 123456.79;
        actual3 = YoDoubleSpinnerValueFactory.round((double)valueRaw3, (long)precision2);
        Assertions.assertEquals((double)expected3, (double)actual3);
        precision2 = 3;
        valueRaw3 = 123456.7890123;
        expected3 = 123456.789;
        actual3 = YoDoubleSpinnerValueFactory.round((double)valueRaw3, (long)precision2);
        Assertions.assertEquals((double)expected3, (double)actual3);
    }

    @Test
    public void testDecrement() {
        double min = Double.NEGATIVE_INFINITY;
        double max = Double.POSITIVE_INFINITY;
        boolean wrapAround = false;
        double currentValue = 0.0;
        double amountToStepBy = 0.1;
        int steps = 1;
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.1, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.2, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.3, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.4, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.5, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.6, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.7, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.8, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.9, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.0, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.1, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.2, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.3, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.4, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.5, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.6, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.7, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.8, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.9, (double)currentValue);
        currentValue = 100.555;
        amountToStepBy = 0.1;
        steps = 1;
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)100.455, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)100.355, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)100.255, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)100.155, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)100.055, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)99.955, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)99.855, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)99.755, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)99.655, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)99.555, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)99.455, (double)currentValue);
        currentValue = -99.355;
        amountToStepBy = 0.1;
        steps = 1;
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-99.455, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-99.555, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-99.655, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-99.755, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-99.855, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-99.955, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-100.055, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-100.155, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-100.255, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-100.355, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-100.455, (double)currentValue);
        currentValue = 1000.355456987563;
        amountToStepBy = 0.1;
        steps = 1;
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)1000.255456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)1000.155456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)1000.055456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)999.955456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)999.855456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)999.755456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)999.655456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.decrement((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)999.555456987563, (double)currentValue);
    }

    @Test
    public void testIncrement() {
        double min = Double.NEGATIVE_INFINITY;
        double max = Double.POSITIVE_INFINITY;
        boolean wrapAround = false;
        double currentValue = -2.0;
        double amountToStepBy = 0.1;
        int steps = 1;
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.9, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.8, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.7, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.6, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.5, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.4, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.3, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.2, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.1, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-1.0, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.9, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.8, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.7, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.6, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.5, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.4, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.3, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.2, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-0.1, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)0.0, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)0.1, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)0.2, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)0.3, (double)currentValue);
        currentValue = 99.355;
        amountToStepBy = 0.1;
        steps = 1;
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)99.455, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)99.555, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)99.655, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)99.755, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)99.855, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)99.955, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)100.055, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)100.155, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)100.255, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)100.355, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)100.455, (double)currentValue);
        currentValue = -100.555;
        amountToStepBy = 0.1;
        steps = 1;
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-100.455, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-100.355, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-100.255, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-100.155, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-100.055, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-99.955, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-99.855, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-99.755, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-99.655, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-99.555, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)-99.455, (double)currentValue);
        currentValue = 999.455456987563;
        amountToStepBy = 0.1;
        steps = 1;
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)999.555456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)999.655456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)999.755456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)999.855456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)999.955456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)1000.055456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)1000.155456987563, (double)currentValue);
        currentValue = YoDoubleSpinnerValueFactory.increment((double)currentValue, (double)min, (double)max, (boolean)wrapAround, (int)steps, (double)amountToStepBy);
        Assertions.assertEquals((double)1000.255456987563, (double)currentValue);
    }
}

