/*
 * Decompiled with CFR 0.152.
 */
package net.javainthebox.caraibe.svg;

import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import net.javainthebox.caraibe.svg.SVGContent;
import net.javainthebox.caraibe.svg.SVGLoader;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SVGLoaderTest {
    @BeforeAll
    public static void setUpClass() throws Exception {
    }

    @AfterAll
    public static void tearDownClass() throws Exception {
    }

    @BeforeEach
    public void setUp() {
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void loadRectangle() {
        SVGContent content = SVGLoader.load((String)"rectangle.svg");
        Assertions.assertNotNull((Object)content);
        Rectangle rect = (Rectangle)content.getNode("rect");
        Assertions.assertEquals((double)100.0, (double)rect.getX(), (double)1.0E-4);
        Assertions.assertEquals((double)50.0, (double)rect.getY(), (double)1.0E-4);
        Assertions.assertEquals((double)100.0, (double)rect.getWidth(), (double)1.0E-4);
        Assertions.assertEquals((double)80.0, (double)rect.getHeight(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#FFFFFF").getRed(), (double)((Color)rect.getFill()).getRed(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#FFFFFF").getGreen(), (double)((Color)rect.getFill()).getGreen(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#FFFFFF").getBlue(), (double)((Color)rect.getFill()).getBlue(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#FFFFFF").getOpacity(), (double)((Color)rect.getFill()).getOpacity(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#000000").getRed(), (double)((Color)rect.getStroke()).getRed(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#000000").getGreen(), (double)((Color)rect.getStroke()).getGreen(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#000000").getBlue(), (double)((Color)rect.getStroke()).getBlue(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#000000").getOpacity(), (double)((Color)rect.getStroke()).getOpacity(), (double)1.0E-4);
    }

    @Test
    public void loadGroup() {
        SVGContent content = SVGLoader.load((String)"group.svg");
        Assertions.assertNotNull((Object)content);
        Group group = content.getGroup("group");
        Assertions.assertNotNull((Object)group);
        Node node = (Node)group.getChildren().get(0);
        Assertions.assertTrue((boolean)(node instanceof Circle));
        Circle circle = (Circle)node;
        Assertions.assertEquals((double)100.0, (double)circle.getCenterX(), (double)1.0E-4);
        Assertions.assertEquals((double)100.0, (double)circle.getCenterY(), (double)1.0E-4);
        Assertions.assertEquals((double)50.0, (double)circle.getRadius(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#FF0000").getRed(), (double)((Color)circle.getFill()).getRed(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#FF0000").getGreen(), (double)((Color)circle.getFill()).getGreen(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#FF0000").getBlue(), (double)((Color)circle.getFill()).getBlue(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#FF0000").getOpacity(), (double)((Color)circle.getFill()).getOpacity(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#000000").getRed(), (double)((Color)circle.getStroke()).getRed(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#000000").getGreen(), (double)((Color)circle.getStroke()).getGreen(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#000000").getBlue(), (double)((Color)circle.getStroke()).getBlue(), (double)1.0E-4);
        Assertions.assertEquals((double)Color.web((String)"#000000").getOpacity(), (double)((Color)circle.getStroke()).getOpacity(), (double)1.0E-4);
    }

    @Test
    public void loadLines() {
        SVGContent content = SVGLoader.load((String)"lines.svg");
        Assertions.assertNotNull((Object)content);
        Line line1 = (Line)content.getNode("line1");
        Assertions.assertEquals((double)50.0, (double)line1.getStartX(), (double)1.0E-4);
        Assertions.assertEquals((double)60.0, (double)line1.getStartY(), (double)1.0E-4);
        Assertions.assertEquals((double)150.0, (double)line1.getEndX(), (double)1.0E-4);
        Assertions.assertEquals((double)60.0, (double)line1.getEndY(), (double)1.0E-4);
        Assertions.assertNull((Object)line1.getFill());
        Color stroke = (Color)line1.getStroke();
        Assertions.assertEquals((double)1.0, (double)stroke.getRed(), (double)1.0E-4);
        Line line2 = (Line)content.getNode("line2");
        Assertions.assertEquals((double)50.0, (double)line2.getStartX(), (double)1.0E-4);
        Assertions.assertEquals((double)80.0, (double)line2.getStartY(), (double)1.0E-4);
        Assertions.assertEquals((double)150.0, (double)line2.getEndX(), (double)1.0E-4);
        Assertions.assertEquals((double)80.0, (double)line2.getEndY(), (double)1.0E-4);
        Assertions.assertNull((Object)line2.getFill());
        stroke = (Color)line2.getStroke();
        Assertions.assertEquals((double)0.0, (double)stroke.getRed(), (double)1.0E-4);
        Assertions.assertEquals((double)2.0, (double)line2.getStrokeWidth(), (double)1.0E-4);
        Line line3 = (Line)content.getNode("line3");
        Assertions.assertEquals((double)50.0, (double)line3.getStartX(), (double)1.0E-4);
        Assertions.assertEquals((double)100.0, (double)line3.getStartY(), (double)1.0E-4);
        Assertions.assertEquals((double)150.0, (double)line3.getEndX(), (double)1.0E-4);
        Assertions.assertEquals((double)100.0, (double)line3.getEndY(), (double)1.0E-4);
        Assertions.assertNull((Object)line3.getFill());
        stroke = (Color)line3.getStroke();
        Assertions.assertEquals((double)0.0, (double)stroke.getRed(), (double)1.0E-4);
        Assertions.assertEquals((double)3.0, (double)line3.getStrokeWidth(), (double)1.0E-4);
        Assertions.assertEquals((Object)StrokeLineCap.SQUARE, (Object)line3.getStrokeLineCap());
        Line line4 = (Line)content.getNode("line4");
        Assertions.assertEquals((double)50.0, (double)line4.getStartX(), (double)1.0E-4);
        Assertions.assertEquals((double)120.0, (double)line4.getStartY(), (double)1.0E-4);
        Assertions.assertEquals((double)150.0, (double)line4.getEndX(), (double)1.0E-4);
        Assertions.assertEquals((double)120.0, (double)line4.getEndY(), (double)1.0E-4);
        Assertions.assertNull((Object)line4.getFill());
        stroke = (Color)line4.getStroke();
        Assertions.assertEquals((double)1.0, (double)stroke.getRed(), (double)1.0E-4);
        Assertions.assertEquals((double)4.0, (double)line4.getStrokeWidth(), (double)1.0E-4);
        Assertions.assertEquals((Object)StrokeLineCap.ROUND, (Object)line4.getStrokeLineCap());
        Line line5 = (Line)content.getNode("line5");
        Assertions.assertEquals((double)50.0, (double)line5.getStartX(), (double)1.0E-4);
        Assertions.assertEquals((double)140.0, (double)line5.getStartY(), (double)1.0E-4);
        Assertions.assertEquals((double)150.0, (double)line5.getEndX(), (double)1.0E-4);
        Assertions.assertEquals((double)140.0, (double)line5.getEndY(), (double)1.0E-4);
        Assertions.assertNull((Object)line5.getFill());
        stroke = (Color)line5.getStroke();
        Assertions.assertEquals((double)0.0, (double)stroke.getRed(), (double)1.0E-4);
        ObservableList dasharray = line5.getStrokeDashArray();
        Assertions.assertEquals((double)4.0, (double)((Double)dasharray.get(0)), (double)1.0E-4);
        Assertions.assertEquals((double)8.0, (double)((Double)dasharray.get(1)), (double)1.0E-4);
    }
}

