/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Attachment;

class AttachmentDataInputBacked
implements Attachment {
    private final MCAPDataInput dataInput;
    private final long logTime;
    private final long createTime;
    private final String name;
    private final String mediaType;
    private final long dataLength;
    private final long dataOffset;
    private WeakReference<ByteBuffer> dataRef;
    private final long crc32;
    private final long crc32InputStart;
    private final int crc32InputLength;
    private WeakReference<ByteBuffer> crc32InputRef;

    AttachmentDataInputBacked(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        this.dataInput = dataInput;
        dataInput.position(elementPosition);
        this.crc32InputStart = elementPosition;
        this.logTime = MCAP.checkPositiveLong(dataInput.getLong(), "logTime");
        this.createTime = MCAP.checkPositiveLong(dataInput.getLong(), "createTime");
        this.name = dataInput.getString();
        this.mediaType = dataInput.getString();
        this.dataLength = MCAP.checkPositiveLong(dataInput.getLong(), "lengthData");
        this.dataOffset = dataInput.position();
        dataInput.skip(this.dataLength);
        this.crc32InputLength = (int)(dataInput.position() - elementPosition);
        this.crc32 = dataInput.getUnsignedInt();
        MCAP.checkLength(elementLength, this.getElementLength());
    }

    @Override
    public long getElementLength() {
        return 36 + this.name.length() + this.mediaType.length() + (int)this.dataLength;
    }

    @Override
    public ByteBuffer crc32Input() {
        ByteBuffer crc32Input;
        ByteBuffer byteBuffer = crc32Input = this.crc32InputRef == null ? null : (ByteBuffer)this.crc32InputRef.get();
        if (crc32Input == null) {
            crc32Input = this.dataInput.getByteBuffer(this.crc32InputStart, this.crc32InputLength, false);
            this.crc32InputRef = new WeakReference<ByteBuffer>(crc32Input);
        }
        return crc32Input;
    }

    @Override
    public long logTime() {
        return this.logTime;
    }

    @Override
    public long createTime() {
        return this.createTime;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String mediaType() {
        return this.mediaType;
    }

    public long dataOffset() {
        return this.dataOffset;
    }

    @Override
    public long dataLength() {
        return this.dataLength;
    }

    @Override
    public ByteBuffer data() {
        ByteBuffer data;
        ByteBuffer byteBuffer = data = this.dataRef == null ? null : (ByteBuffer)this.dataRef.get();
        if (data == null) {
            data = this.dataInput.getByteBuffer(this.dataOffset, (int)this.dataLength, false);
            this.dataRef = new WeakReference<ByteBuffer>(data);
        }
        return data;
    }

    @Override
    public long crc32() {
        return this.crc32;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        Attachment attachment;
        return object instanceof Attachment && Attachment.super.equals(attachment = (Attachment)object);
    }
}

