/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.Objects;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;

public class Header
implements MCAPElement {
    private final String profile;
    private final String library;

    public Header(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        dataInput.position(elementPosition);
        this.profile = dataInput.getString();
        this.library = dataInput.getString();
        MCAP.checkLength(elementLength, this.getElementLength());
    }

    public Header(String profile, String library) {
        this.profile = profile;
        this.library = library;
    }

    @Override
    public long getElementLength() {
        return 8 + this.profile.length() + this.library.length();
    }

    public String profile() {
        return this.profile;
    }

    public String library() {
        return this.library;
    }

    @Override
    public void write(MCAPDataOutput dataOutput) {
        dataOutput.putString(this.profile);
        dataOutput.putString(this.library);
    }

    @Override
    public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addString(this.profile);
        crc32.addString(this.library);
        return crc32;
    }

    public String toString() {
        String out = this.getClass().getSimpleName() + ": ";
        out = out + "\n\t-profile = " + this.profile;
        out = out + "\n\t-library = " + this.library;
        return out;
    }

    public boolean equals(Object object) {
        Header other;
        return object instanceof Header && this.equals(other = (Header)object);
    }

    @Override
    public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof Header) {
            Header other = (Header)mcapElement;
            if (!Objects.equals(this.profile(), other.profile())) {
                return false;
            }
            return Objects.equals(this.library(), other.library());
        }
        return false;
    }
}

