/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.output;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import us.ihmc.scs2.session.mcap.output.MCAPBufferedFileChannelOutput;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;

public interface MCAPDataOutput {
    public long position();

    public void putLong(long var1);

    public void putInt(int var1);

    default public void putUnsignedInt(long value) {
        this.putInt((int)value);
    }

    public void putShort(short var1);

    default public void putUnsignedShort(int value) {
        this.putShort((short)value);
    }

    public void putByte(byte var1);

    default public void putUnsignedByte(int value) {
        this.putByte((byte)value);
    }

    default public void putBytes(byte[] bytes) {
        this.putBytes(bytes, 0, bytes.length);
    }

    public void putBytes(byte[] var1, int var2, int var3);

    default public void putString(String string) {
        byte[] bytes = string.getBytes();
        this.putUnsignedInt(bytes.length);
        this.putBytes(bytes);
    }

    public void putByteBuffer(ByteBuffer var1);

    default public <T extends MCAPElement> void putCollection(Collection<T> collection) {
        this.putUnsignedInt(collection.stream().mapToLong(MCAPElement::getElementLength).sum());
        collection.forEach(element -> element.write(this));
    }

    public void close();

    public static MCAPDataOutput wrap(FileChannel fileChannel) {
        return new MCAPBufferedFileChannelOutput(fileChannel);
    }
}

