/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.session.SessionIOTools;
import us.ihmc.scs2.session.mcap.MCAPBufferedChunk;
import us.ihmc.scs2.session.mcap.MCAPConsoleLogManager;
import us.ihmc.scs2.session.mcap.MCAPFrameTransformBasedRobotStateUpdater;
import us.ihmc.scs2.session.mcap.MCAPFrameTransformManager;
import us.ihmc.scs2.session.mcap.MCAPMessageManager;
import us.ihmc.scs2.session.mcap.MCAPMujocoBasedRobotStateUpdater;
import us.ihmc.scs2.session.mcap.MCAPSchema;
import us.ihmc.scs2.session.mcap.OMGIDLSchemaParser;
import us.ihmc.scs2.session.mcap.ROS2SchemaParser;
import us.ihmc.scs2.session.mcap.RobotStateUpdater;
import us.ihmc.scs2.session.mcap.YoMCAPMessage;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Channel;
import us.ihmc.scs2.session.mcap.specs.records.Chunk;
import us.ihmc.scs2.session.mcap.specs.records.Message;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.Schema;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoTools;
import us.ihmc.yoVariables.variable.YoLong;

public class MCAPLogFileReader {
    public static final Set<String> SCHEMA_TO_IGNORE = Set.of("foxglove::Grid", "foxglove::SceneUpdate", "foxglove::FrameTransforms", "HandDeviceHealth");
    public static final Path SCS2_MCAP_DEBUG_HOME = SessionIOTools.SCS2_HOME.resolve("mcap-debug");
    private final YoRegistry propertiesRegistry = new YoRegistry("MCAPProperties");
    private final File mcapFile;
    private final YoRegistry mcapRegistry;
    private final MCAP mcap;
    private final MCAPBufferedChunk chunkBuffer;
    private final MCAPMessageManager messageManager;
    private final MCAPConsoleLogManager consoleLogManager;
    private final TIntObjectHashMap<MCAPSchema> schemas = new TIntObjectHashMap();
    private final TIntObjectHashMap<Schema> rawSchemas = new TIntObjectHashMap();
    private final TIntObjectHashMap<YoMCAPMessage> yoMessageMap = new TIntObjectHashMap();
    private final MCAPFrameTransformManager frameTransformManager;
    private final YoLong currentChunkStartTimestamp = new YoLong("MCAPCurrentChunkStartTimestamp", this.propertiesRegistry);
    private final YoLong currentChunkEndTimestamp = new YoLong("MCAPCurrentChunkEndTimestamp", this.propertiesRegistry);
    private final YoLong currentTimestamp = new YoLong("MCAPCurrentTimestamp", this.propertiesRegistry);
    private final long desiredLogDT;
    private final long initialTimestamp;
    private final long finalTimestamp;

    public MCAPLogFileReader(File mcapFile, long desiredLogDT, ReferenceFrame inertialFrame, YoRegistry mcapRegistry, YoRegistry internalRegistry) throws IOException {
        if (SCS2_MCAP_DEBUG_HOME.toFile().exists()) {
            FileUtils.cleanDirectory((File)SCS2_MCAP_DEBUG_HOME.toFile());
        }
        this.mcapFile = mcapFile;
        this.desiredLogDT = desiredLogDT;
        this.mcapRegistry = mcapRegistry;
        mcapRegistry.addChild(this.propertiesRegistry);
        long startTime = System.nanoTime();
        FileInputStream mcapFileInputStream = new FileInputStream(mcapFile);
        FileChannel mcapFileChannel = mcapFileInputStream.getChannel();
        LogTools.info((String)"Opened file channel in {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        startTime = System.nanoTime();
        this.mcap = new MCAP(mcapFileChannel);
        LogTools.info((String)"Created MCAP object in {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        startTime = System.nanoTime();
        this.chunkBuffer = new MCAPBufferedChunk(this.mcap, desiredLogDT);
        LogTools.info((String)"Created chunk buffer in {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        startTime = System.nanoTime();
        this.messageManager = new MCAPMessageManager(this.mcap, this.chunkBuffer, desiredLogDT);
        LogTools.info((String)"Created message manager in {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        this.currentTimestamp.addListener(v -> this.chunkBuffer.preloadChunks(this.currentTimestamp.getValue(), TimeUnit.MILLISECONDS.toNanos(500L)));
        this.initialTimestamp = this.messageManager.firstMessageTimestamp();
        this.finalTimestamp = this.messageManager.lastMessageTimestamp();
        startTime = System.nanoTime();
        this.frameTransformManager = new MCAPFrameTransformManager(inertialFrame);
        mcapRegistry.addChild(this.frameTransformManager.getRegistry());
        LogTools.info((String)"Created frame transform manager in {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        startTime = System.nanoTime();
        this.loadSchemas();
        LogTools.info((String)"Loaded schemas in {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        startTime = System.nanoTime();
        this.loadChannels();
        LogTools.info((String)"Loaded channels in {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        startTime = System.nanoTime();
        this.consoleLogManager = new MCAPConsoleLogManager(this.mcap, this.chunkBuffer, desiredLogDT);
        LogTools.info((String)"Created console log manager in {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
    }

    public long getDesiredLogDT() {
        return this.desiredLogDT;
    }

    public long getInitialTimestamp() {
        return this.initialTimestamp;
    }

    public long getFinalTimestamp() {
        return this.finalTimestamp;
    }

    public long getTimestampAtIndex(int index) {
        return this.messageManager.getTimestampAtIndex(index);
    }

    public YoLong getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    public long getRelativeTimestampAtIndex(int index) {
        return this.messageManager.getRelativeTimestampAtIndex(index);
    }

    public int getCurrentIndex() {
        return this.messageManager.getIndexFromTimestamp(this.currentTimestamp.getValue());
    }

    public int getIndexFromTimestamp(long timestamp) {
        return this.messageManager.getIndexFromTimestamp(timestamp);
    }

    public int getNumberOfEntries() {
        return this.messageManager.getNumberOfEntries();
    }

    private void loadSchemas() throws IOException {
        try {
            this.frameTransformManager.initialize(this.mcap, this.chunkBuffer);
        }
        catch (Exception e) {
            Schema schema = this.frameTransformManager.getMCAPSchema();
            File debugFile = MCAPLogFileReader.exportSchemaToFile(SCS2_MCAP_DEBUG_HOME, schema, e);
            LogTools.error((String)("Failed to load schema: " + schema.name() + ", saved to: " + debugFile.getAbsolutePath()));
            throw e;
        }
        for (Record record : this.mcap.records()) {
            if (record.op() != Opcode.SCHEMA) continue;
            Schema schema = (Schema)record.body();
            this.rawSchemas.put(schema.id(), (Object)schema);
            if (SCHEMA_TO_IGNORE.contains(schema.name()) || this.frameTransformManager.hasMCAPFrameTransforms() && schema.id() == this.frameTransformManager.getFrameTransformSchema().getId()) continue;
            try {
                if (schema.encoding().equalsIgnoreCase("ros2msg")) {
                    this.schemas.put(schema.id(), (Object)ROS2SchemaParser.loadSchema(schema));
                    continue;
                }
                if (schema.encoding().equalsIgnoreCase("omgidl")) {
                    this.schemas.put(schema.id(), (Object)OMGIDLSchemaParser.loadSchema(schema));
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported encoding: " + schema.encoding());
            }
            catch (Exception e) {
                File debugFile = MCAPLogFileReader.exportSchemaToFile(SCS2_MCAP_DEBUG_HOME, schema, e);
                LogTools.error((String)("Failed to load schema: " + schema.name() + ", saved to: " + debugFile.getAbsolutePath()));
                throw e;
            }
        }
    }

    private void loadChannels() throws IOException {
        for (Record record : this.mcap.records()) {
            if (record.op() != Opcode.CHANNEL) continue;
            Channel channel = (Channel)record.body();
            if (this.frameTransformManager.hasMCAPFrameTransforms() && channel.schemaId() == this.frameTransformManager.getFrameTransformSchema().getId()) continue;
            MCAPSchema schema = (MCAPSchema)this.schemas.get(channel.schemaId());
            if (schema == null) {
                Schema rawSchema = (Schema)this.rawSchemas.get(channel.schemaId());
                if (rawSchema != null && SCHEMA_TO_IGNORE.contains(rawSchema.name())) continue;
                LogTools.error((String)("Failed to find schema for channel: " + channel.id() + ", schema ID: " + channel.schemaId()));
                continue;
            }
            try {
                if (!"cdr".equalsIgnoreCase(channel.messageEncoding())) {
                    throw new UnsupportedOperationException("Only CDR encoding is supported for now.");
                }
                String topic = channel.topic();
                if ((topic = topic.replace("/", YoTools.NAMESPACE_SEPERATOR_STRING)).startsWith(YoTools.NAMESPACE_SEPERATOR_STRING)) {
                    topic = topic.substring(YoTools.NAMESPACE_SEPERATOR_STRING.length());
                }
                YoNamespace namespace = new YoNamespace(topic).prepend(this.mcapRegistry.getNamespace());
                YoRegistry channelRegistry = SharedMemoryTools.ensurePathExists((YoRegistry)this.mcapRegistry, (YoNamespace)namespace);
                YoMCAPMessage newMessage = YoMCAPMessage.newMessage(schema, channel.id(), channelRegistry);
                if (channelRegistry.getNumberOfVariablesDeep() > 15000) {
                    LogTools.warn((String)"Message registry has more than 15000 variables, schema {}, topic {}. This may cause performance issues.", (Object)schema.getName(), (Object)channel.topic());
                }
                this.yoMessageMap.put(channel.id(), (Object)newMessage);
            }
            catch (Exception e) {
                MCAPLogFileReader.exportChannelToFile(SCS2_MCAP_DEBUG_HOME, channel, schema, e);
                LogTools.error((String)("Failed to load channel: " + channel.id() + ", schema ID: " + channel.schemaId() + ", saved to: " + String.valueOf(SCS2_MCAP_DEBUG_HOME)));
                e.printStackTrace();
            }
        }
    }

    public double getCurrentTimeInLog() {
        return (double)(this.currentTimestamp.getValue() - this.getInitialTimestamp()) / 1.0E9;
    }

    public long getCurrentRelativeTimestamp() {
        return this.currentTimestamp.getValue() - this.getInitialTimestamp();
    }

    public void initialize() throws IOException {
        this.currentTimestamp.set(this.initialTimestamp);
        this.readMessagesAtCurrentTimestamp();
    }

    public void setCurrentTimestamp(long timestamp) {
        this.currentTimestamp.set(timestamp);
        this.chunkBuffer.requestLoadChunk(timestamp, false);
    }

    public YoGraphicDefinition getYoGraphic() {
        return this.frameTransformManager.getYoGraphic();
    }

    public boolean incrementTimestamp() {
        long nextTimestamp = this.messageManager.nextMessageTimestamp(this.currentTimestamp.getValue());
        if (nextTimestamp == -1L) {
            return true;
        }
        this.currentTimestamp.set(nextTimestamp);
        return false;
    }

    public void readMessagesAtCurrentTimestamp() throws IOException {
        List<Message> messages = this.messageManager.loadMessages(this.currentTimestamp.getValue());
        if (messages == null) {
            LogTools.warn((String)"No messages at timestamp {}.", (Object)this.currentTimestamp.getValue());
            return;
        }
        this.currentChunkStartTimestamp.set(this.messageManager.getActiveChunkStartTimestamp());
        this.currentChunkEndTimestamp.set(this.messageManager.getActiveChunkEndTimestamp());
        for (Message message : messages) {
            YoMCAPMessage yoMCAPMessage;
            try {
                boolean wasAFrameTransform = this.frameTransformManager.readMessage(message);
                if (wasAFrameTransform || (yoMCAPMessage = (YoMCAPMessage)this.yoMessageMap.get(message.channelId())) == null) continue;
                yoMCAPMessage.readMessage(message);
            }
            catch (Exception e) {
                e.printStackTrace();
                yoMCAPMessage = (YoMCAPMessage)this.yoMessageMap.get(message.channelId());
                if (yoMCAPMessage == null) continue;
                LogTools.error((String)"Failed to read message. Channel ID {}, schema name: {}. Exporting message data & schema to file.", (Object)message.channelId(), (Object)yoMCAPMessage.getSchema().getName());
                MCAPLogFileReader.exportMessageDataToFile(SCS2_MCAP_DEBUG_HOME, message, yoMCAPMessage.getSchema(), e);
                MCAPLogFileReader.exportSchemaToFile(SCS2_MCAP_DEBUG_HOME, (Schema)this.rawSchemas.get(yoMCAPMessage.getSchema().getId()), e);
            }
        }
        this.frameTransformManager.update();
    }

    public static File exportSchemaToFile(Path path, Schema schema, Exception e) throws IOException {
        String filename = e != null ? "schema-%s-%s.txt".formatted(MCAPLogFileReader.cleanupName(schema.name()), e.getClass().getSimpleName()) : "schema-%s.txt".formatted(MCAPLogFileReader.cleanupName(schema.name()));
        File debugFile = path.resolve(filename).toFile();
        if (debugFile.exists()) {
            debugFile.delete();
        }
        debugFile.createNewFile();
        FileOutputStream os = new FileOutputStream(debugFile);
        os.getChannel().write(schema.data());
        os.close();
        return debugFile;
    }

    public static void exportChannelToFile(Path path, Channel channel, MCAPSchema schema, Exception e) throws IOException {
        File debugFile = e != null ? path.resolve("channel-%d-schema-%s-%s.txt".formatted(channel.id(), MCAPLogFileReader.cleanupName(schema.getName()), e.getClass().getSimpleName())).toFile() : path.resolve("channel-%d-schema-%s.txt".formatted(channel.id(), MCAPLogFileReader.cleanupName(schema.getName()))).toFile();
        if (debugFile.exists()) {
            debugFile.delete();
        }
        debugFile.createNewFile();
        PrintWriter pw = new PrintWriter(debugFile);
        pw.write(channel.toString());
        pw.close();
    }

    public static void exportMessageDataToFile(Path path, Message message, MCAPSchema schema, Exception e) throws IOException {
        String prefix = "messageData-timestamp-%d-schema-%s";
        File debugFile = e != null ? path.resolve((prefix + "-%s.txt").formatted(message.logTime(), MCAPLogFileReader.cleanupName(schema.getName()), e.getClass().getSimpleName())).toFile() : path.resolve((prefix + ".txt").formatted(message.logTime(), MCAPLogFileReader.cleanupName(schema.getName()))).toFile();
        if (debugFile.exists()) {
            debugFile.delete();
        }
        debugFile.createNewFile();
        FileOutputStream os = new FileOutputStream(debugFile);
        os.write(message.messageData());
        os.close();
    }

    public static void exportChunkToFile(Path path, Chunk chunk, Exception e) throws IOException {
        File debugFile = e != null ? path.resolve("chunk-%d-%s.txt".formatted(chunk.messageStartTime(), e.getClass().getSimpleName())).toFile() : path.resolve("chunk-%d.txt".formatted(chunk.messageStartTime())).toFile();
        if (debugFile.exists()) {
            debugFile.delete();
        }
        debugFile.createNewFile();
        FileOutputStream os = new FileOutputStream(debugFile);
        MCAPDataOutput dataOutput = MCAPDataOutput.wrap(os.getChannel());
        chunk.write(dataOutput);
        dataOutput.close();
    }

    private static String cleanupName(String name) {
        return name.replace(':', '-');
    }

    public MCAPMessageManager getMessageManager() {
        return this.messageManager;
    }

    public MCAPConsoleLogManager getConsoleLogManager() {
        return this.consoleLogManager;
    }

    public MCAP getMCAP() {
        return this.mcap;
    }

    public File getMCAPFile() {
        return this.mcapFile;
    }

    public MCAPFrameTransformManager getFrameTransformManager() {
        return this.frameTransformManager;
    }

    public RobotStateUpdater createRobotStateUpdater(Robot robot) {
        if (this.frameTransformManager.hasMCAPFrameTransforms()) {
            return new MCAPFrameTransformBasedRobotStateUpdater(robot, this.frameTransformManager);
        }
        for (YoMCAPMessage yoMCAPMessage : this.yoMessageMap.valueCollection()) {
            if (!MCAPMujocoBasedRobotStateUpdater.isRobotMujocoStateMessage(robot, yoMCAPMessage)) continue;
            return new MCAPMujocoBasedRobotStateUpdater(robot, yoMCAPMessage);
        }
        return null;
    }

    static {
        try {
            FileTools.ensureDirectoryExists((Path)SCS2_MCAP_DEBUG_HOME);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

