/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.log;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.bytedeco.javacpp.Pointer;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.session.log.TimestampScrubber;
import us.ihmc.zed.SL_InitParameters;
import us.ihmc.zed.SL_RuntimeParameters;
import us.ihmc.zed.ZEDTools;
import us.ihmc.zed.global.zed;
import us.ihmc.zed.library.ZEDJavaAPINativeLibrary;

public class ZEDSVOScrubber {
    private static final boolean ZED_SDK_LOADED = ZEDJavaAPINativeLibrary.load();
    private static final AtomicInteger NEXT_CAMERA_ID = new AtomicInteger(0);
    private final String sensorName;
    private final String perceptionDirectory;
    private final TimestampScrubber timestampScrubber;
    private long currentTimestamp;
    private final Map<String, SVOFile> svoFiles = new HashMap<String, SVOFile>();
    private int imageWidth;
    private int imageHeight;
    private float fps;
    private Pointer leftColorImageSlMatPointer;
    private Pointer rightColorImageSlMatPointer;
    int lastGrabbedFrameNumber = -1;

    public static File[] findZEDSensorDatFiles(File logDataDirectory) {
        ArrayList<File> zedSensorDatFiles = new ArrayList<File>();
        Path perceptionDirectory = logDataDirectory.toPath().resolve("perception");
        try {
            File[] files;
            if (perceptionDirectory.toFile().exists() && (files = perceptionDirectory.toFile().listFiles()) != null) {
                TreeSet<String> zedSensorNames = new TreeSet<String>();
                for (File file : files) {
                    if (!file.getName().endsWith(".svo2")) continue;
                    String partAfterDate = file.getName().substring("yyyyMMdd_HHmmss_".length());
                    String partBeforeExtension = partAfterDate.substring(0, partAfterDate.length() - ".svo2".length());
                    zedSensorNames.add(partBeforeExtension);
                }
                for (String sensorName : zedSensorNames) {
                    for (File file : files) {
                        if (!file.getName().equals("%s_Timestamps.dat".formatted(sensorName))) continue;
                        if (ZED_SDK_LOADED) {
                            zedSensorDatFiles.add(file);
                            continue;
                        }
                        LogTools.warn((String)"ZED sensor data is present but ZED SDK is not installed. ZED data will be excluded.");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return zedSensorDatFiles.toArray(new File[0]);
    }

    public ZEDSVOScrubber(File timestampsDatFile) {
        this.sensorName = timestampsDatFile.getName().replaceAll("_Timestamps.dat$", "");
        this.perceptionDirectory = timestampsDatFile.toPath().getParent().toAbsolutePath().toString();
        this.timestampScrubber = (TimestampScrubber)ExceptionTools.handle(() -> new TimestampScrubber(timestampsDatFile, false, false), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
    }

    public void scrub(long timestamp) {
        boolean requestedFrameIsOneOfTheNext10;
        int frameNumber;
        int cameraID;
        this.timestampScrubber.getVideoTimestampFromRobotTimestamp(timestamp);
        String videoFilename = this.timestampScrubber.getCurrentVideoFilename();
        SVOFile svoFile = this.svoFiles.get(videoFilename);
        if (svoFile == null) {
            cameraID = NEXT_CAMERA_ID.getAndIncrement();
            String svoFileName = "%s%s%s_%s.svo2".formatted(this.perceptionDirectory, File.separator, videoFilename, this.sensorName);
            SL_InitParameters initParameters = new SL_InitParameters();
            initParameters.camera_device_id(cameraID);
            initParameters.input_type(1);
            initParameters.sdk_verbose(0);
            initParameters.svo_real_time_mode(false);
            initParameters.coordinate_unit(2);
            initParameters.coordinate_system(5);
            SL_RuntimeParameters runtimeParameters = new SL_RuntimeParameters();
            runtimeParameters.enable_depth(false);
            zed.sl_create_camera((int)cameraID);
            LogTools.info((String)("Opening SVO file: " + svoFileName));
            this.printOnError(zed.sl_open_camera((int)cameraID, (SL_InitParameters)initParameters, (int)0, (String)svoFileName, (String)"", (int)0, (String)"", (String)"", (String)""));
            svoFile = new SVOFile(cameraID, svoFileName, initParameters, runtimeParameters);
            this.svoFiles.put(videoFilename, svoFile);
        }
        cameraID = svoFile.cameraID;
        this.imageWidth = zed.sl_get_width((int)cameraID);
        this.imageHeight = zed.sl_get_height((int)cameraID);
        int numberOfFrames = zed.sl_get_svo_number_of_frames((int)cameraID);
        this.fps = zed.sl_get_camera_fps((int)cameraID);
        if (this.leftColorImageSlMatPointer == null) {
            this.leftColorImageSlMatPointer = zed.sl_mat_create_new((int)this.imageWidth, (int)this.imageHeight, (int)7, (int)0);
        }
        if (this.rightColorImageSlMatPointer == null) {
            this.rightColorImageSlMatPointer = zed.sl_mat_create_new((int)this.imageWidth, (int)this.imageHeight, (int)7, (int)0);
        }
        if ((frameNumber = (int)this.timestampScrubber.getCurrentVideoFrameNumber()) < 0 || frameNumber >= numberOfFrames - 1) {
            return;
        }
        if (this.lastGrabbedFrameNumber == frameNumber) {
            return;
        }
        boolean haventGrabbedAFrameYet = this.lastGrabbedFrameNumber < 0;
        int framesForward = frameNumber - this.lastGrabbedFrameNumber;
        boolean bl = requestedFrameIsOneOfTheNext10 = framesForward > 0 && framesForward <= 10;
        if (haventGrabbedAFrameYet || !requestedFrameIsOneOfTheNext10) {
            zed.sl_set_svo_position((int)cameraID, (int)frameNumber);
            framesForward = 1;
        }
        int errorCode = 0;
        for (int i = 0; i < framesForward; ++i) {
            errorCode = zed.sl_grab((int)cameraID, (SL_RuntimeParameters)svoFile.runtimeParameters);
        }
        if (errorCode != 0) {
            LogTools.warn((int)1, (Object)ZEDTools.errorMessage((int)errorCode));
            return;
        }
        this.printOnError(zed.sl_retrieve_image((int)cameraID, (Pointer)this.leftColorImageSlMatPointer, (int)0, (int)0, (int)this.imageWidth, (int)this.imageHeight));
        this.printOnError(zed.sl_retrieve_image((int)cameraID, (Pointer)this.rightColorImageSlMatPointer, (int)1, (int)0, (int)this.imageWidth, (int)this.imageHeight));
        this.currentTimestamp = zed.sl_get_current_timestamp((int)cameraID);
        this.lastGrabbedFrameNumber = frameNumber;
    }

    public void cropVideo(File outputFile, File timestampFile, long startTimestamp, long endTimestamp, ProgressConsumer monitor) {
        int totalFrames = this.timestampScrubber.getRobotTimestampsArray().length;
        this.timestampScrubber.getVideoTimestampFromRobotTimestamp(startTimestamp);
        int cropStartIndex = this.timestampScrubber.getCurrentIndex();
        this.timestampScrubber.getVideoTimestampFromRobotTimestamp(endTimestamp);
        int cropEndIndex = this.timestampScrubber.getCurrentIndex();
        if (cropEndIndex >= totalFrames) {
            cropEndIndex = totalFrames - 1;
        }
        int startOfDatToCopy = -1;
        int endOfDatToCopy = -1;
        ArrayList<SVOToCrop> svosToCrop = new ArrayList<SVOToCrop>();
        String[] videoFileNames = this.timestampScrubber.getVideoFileNames();
        for (int i = 0; i < videoFileNames.length; ++i) {
            int length;
            boolean skip;
            int videoFileStartIndex = (int)this.timestampScrubber.getVideoFileStartIndices()[i];
            int videoFileEndIndex = totalFrames - 1;
            if (videoFileNames.length > i + 1) {
                videoFileEndIndex = (int)this.timestampScrubber.getVideoFileStartIndices()[i + 1] - 1;
            }
            boolean isEntirelyBeforeCropZone = --videoFileEndIndex <= cropStartIndex;
            boolean isEntirelyAfterCropZone = videoFileStartIndex >= cropEndIndex;
            boolean bl = skip = isEntirelyBeforeCropZone || isEntirelyAfterCropZone;
            if (skip) continue;
            boolean copyOnly = true;
            if (videoFileStartIndex < cropStartIndex) {
                videoFileStartIndex = cropStartIndex;
                copyOnly = false;
            }
            if (videoFileEndIndex > cropEndIndex) {
                videoFileEndIndex = cropEndIndex;
                copyOnly = false;
            }
            if ((length = videoFileEndIndex - videoFileStartIndex) <= 5) continue;
            if (startOfDatToCopy == -1) {
                startOfDatToCopy = videoFileStartIndex;
            }
            if (videoFileEndIndex > endOfDatToCopy) {
                endOfDatToCopy = videoFileEndIndex;
            }
            svosToCrop.add(new SVOToCrop("%s%s%s_%s.svo2".formatted(this.perceptionDirectory, File.separator, videoFileNames[i], this.sensorName), copyOnly, this.timestampScrubber.calculateVideoFrameNumber(videoFileStartIndex, i), this.timestampScrubber.calculateVideoFrameNumber(videoFileEndIndex, i)));
        }
        Path outputDirectory = outputFile.toPath().getParent().resolve("perception");
        FileTools.ensureDirectoryExists((Path)outputDirectory, (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        for (int i = 0; i < svosToCrop.size(); ++i) {
            SVOToCrop svoToCrop = (SVOToCrop)svosToCrop.get(i);
            Path sourceFile = Paths.get(svoToCrop.svoFileName, new String[0]);
            Path destinationFile = outputDirectory.resolve(sourceFile.getFileName());
            if (svoToCrop.copyOnly) {
                try {
                    message = "Moving SVO file from " + String.valueOf(sourceFile.toAbsolutePath()) + " to " + String.valueOf(destinationFile.toAbsolutePath());
                    monitor.info(message);
                    LogTools.info((String)message);
                    Files.copy(sourceFile, destinationFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    LogTools.error((String)("Failed to move SVO file: " + e.getMessage()));
                }
            } else {
                try {
                    message = "Cropping SVO file from " + String.valueOf(sourceFile.toAbsolutePath()) + " to " + String.valueOf(destinationFile.toAbsolutePath());
                    monitor.info(message);
                    LogTools.info((String)message);
                    CharSequence[] command = new String[]{"/usr/local/zed/tools/ZED_SVO_Editor", "-cut", svoToCrop.svoFileName, "-s", "" + svoToCrop.startFrame, "-e", "" + svoToCrop.endFrame, destinationFile.toAbsolutePath().toString()};
                    LogTools.info((String)String.join((CharSequence)" ", command));
                    ProcessBuilder processBuilder = new ProcessBuilder((String[])command);
                    processBuilder.redirectErrorStream(true);
                    Process process = processBuilder.start();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            LogTools.info((String)line);
                        }
                    }
                    int exitCode = process.waitFor();
                    if (exitCode != 0) {
                        LogTools.error((String)("Command exited with non-zero code: " + exitCode));
                    }
                }
                catch (IOException | InterruptedException e) {
                    LogTools.error((String)("Error executing system command: " + e.getMessage()));
                }
            }
            monitor.progress((float)(i + 1) / (float)svosToCrop.size());
        }
        Path sourceDatFile = Paths.get(this.perceptionDirectory, new String[0]).resolve(timestampFile.getName());
        Path outputDatFile = outputDirectory.resolve(timestampFile.getName());
        LogTools.info((String)"Writing lines %d-%d to %s".formatted(startOfDatToCopy, endOfDatToCopy, outputDatFile.toAbsolutePath().toString()));
        try (BufferedReader reader = Files.newBufferedReader(sourceDatFile);
             PrintWriter writer = new PrintWriter(Files.newBufferedWriter(outputDatFile, new OpenOption[0]));){
            String line;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                if (++lineNumber < startOfDatToCopy || lineNumber > endOfDatToCopy) continue;
                writer.println(line);
            }
        }
        catch (IOException e) {
            LogTools.error((String)("Failed to write to output .dat file: " + e.getMessage()));
        }
    }

    public void close() {
        System.out.println("Closing " + this.getClass().getSimpleName());
        if (this.leftColorImageSlMatPointer != null && !this.leftColorImageSlMatPointer.isNull()) {
            zed.sl_mat_free((Pointer)this.leftColorImageSlMatPointer, (int)0);
            this.leftColorImageSlMatPointer.close();
        }
        if (this.rightColorImageSlMatPointer != null && !this.rightColorImageSlMatPointer.isNull()) {
            zed.sl_mat_free((Pointer)this.rightColorImageSlMatPointer, (int)0);
            this.rightColorImageSlMatPointer.close();
        }
        for (SVOFile svoFile : this.svoFiles.values()) {
            if (zed.sl_is_opened((int)svoFile.cameraID)) {
                zed.sl_close_camera((int)svoFile.cameraID);
            }
            svoFile.initParameters.close();
            svoFile.runtimeParameters.close();
        }
        System.out.println("Closed " + this.getClass().getSimpleName());
    }

    public int getCameraID() {
        String videoFilename = this.timestampScrubber.getCurrentVideoFilename();
        SVOFile svoFile = this.svoFiles.get(videoFilename);
        if (svoFile != null) {
            return svoFile.cameraID;
        }
        return -1;
    }

    public long getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    public Pointer getLeftColorImageSlMatPointer() {
        return this.leftColorImageSlMatPointer;
    }

    public Pointer getRightColorImageSlMatPointer() {
        return this.rightColorImageSlMatPointer;
    }

    public TimestampScrubber getTimestampScrubber() {
        return this.timestampScrubber;
    }

    public String getName() {
        return this.sensorName;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public float getFps() {
        return this.fps;
    }

    private void printOnError(int errorCode) {
        if (errorCode != 0) {
            LogTools.error((int)1, (Object)ZEDTools.errorMessage((int)errorCode));
        }
    }

    private record SVOFile(int cameraID, String currentVideoFilename, SL_InitParameters initParameters, SL_RuntimeParameters runtimeParameters) {
    }

    private record SVOToCrop(String svoFileName, boolean copyOnly, int startFrame, int endFrame) {
    }
}

