/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.lang.ref.WeakReference;
import java.util.List;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.ChannelMessageCount;
import us.ihmc.scs2.session.mcap.specs.records.Statistics;

public class StatisticsDataInputBacked
implements Statistics {
    private final MCAPDataInput dataInput;
    private final long elementLength;
    private final long messageCount;
    private final int schemaCount;
    private final long channelCount;
    private final long attachmentCount;
    private final long metadataCount;
    private final long chunkCount;
    private final long messageStartTime;
    private final long messageEndTime;
    private WeakReference<List<ChannelMessageCount>> channelMessageCountsRef;
    private final long channelMessageCountsOffset;
    private final long channelMessageCountsLength;

    public StatisticsDataInputBacked(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        this.dataInput = dataInput;
        this.elementLength = elementLength;
        dataInput.position(elementPosition);
        this.messageCount = MCAP.checkPositiveLong(dataInput.getLong(), "messageCount");
        this.schemaCount = dataInput.getUnsignedShort();
        this.channelCount = dataInput.getUnsignedInt();
        this.attachmentCount = dataInput.getUnsignedInt();
        this.metadataCount = dataInput.getUnsignedInt();
        this.chunkCount = dataInput.getUnsignedInt();
        this.messageStartTime = MCAP.checkPositiveLong(dataInput.getLong(), "messageStartTime");
        this.messageEndTime = MCAP.checkPositiveLong(dataInput.getLong(), "messageEndTime");
        this.channelMessageCountsLength = dataInput.getUnsignedInt();
        this.channelMessageCountsOffset = dataInput.position();
    }

    @Override
    public long getElementLength() {
        return this.elementLength;
    }

    @Override
    public long messageCount() {
        return this.messageCount;
    }

    @Override
    public int schemaCount() {
        return this.schemaCount;
    }

    @Override
    public long channelCount() {
        return this.channelCount;
    }

    @Override
    public long attachmentCount() {
        return this.attachmentCount;
    }

    @Override
    public long metadataCount() {
        return this.metadataCount;
    }

    @Override
    public long chunkCount() {
        return this.chunkCount;
    }

    @Override
    public long messageStartTime() {
        return this.messageStartTime;
    }

    @Override
    public long messageEndTime() {
        return this.messageEndTime;
    }

    @Override
    public List<ChannelMessageCount> channelMessageCounts() {
        List<ChannelMessageCount> channelMessageCounts;
        List<ChannelMessageCount> list = channelMessageCounts = this.channelMessageCountsRef == null ? null : (List<ChannelMessageCount>)this.channelMessageCountsRef.get();
        if (channelMessageCounts == null) {
            channelMessageCounts = MCAP.parseList(this.dataInput, ChannelMessageCount::new, this.channelMessageCountsOffset, this.channelMessageCountsLength);
            this.channelMessageCountsRef = new WeakReference<List<ChannelMessageCount>>(channelMessageCounts);
        }
        return channelMessageCounts;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        Statistics other;
        return object instanceof Statistics && Statistics.super.equals(other = (Statistics)object);
    }
}

