/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.List;
import java.util.Objects;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.ChunkIndexDataInputBacked;
import us.ihmc.scs2.session.mcap.specs.records.Compression;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndexOffset;
import us.ihmc.scs2.session.mcap.specs.records.Record;

public interface ChunkIndex
extends MCAPElement {
    public static ChunkIndex load(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        return new ChunkIndexDataInputBacked(dataInput, elementPosition, elementLength);
    }

    public Record chunk();

    public long messageStartTime();

    public long messageEndTime();

    public long chunkOffset();

    public long chunkLength();

    public long messageIndexOffsetsLength();

    public List<MessageIndexOffset> messageIndexOffsets();

    public long messageIndexLength();

    public Compression compression();

    public long recordsCompressedLength();

    public long recordsUncompressedLength();

    @Override
    default public void write(MCAPDataOutput dataOutput) {
        dataOutput.putLong(this.messageStartTime());
        dataOutput.putLong(this.messageEndTime());
        dataOutput.putLong(this.chunkOffset());
        dataOutput.putLong(this.chunkLength());
        dataOutput.putCollection(this.messageIndexOffsets());
        dataOutput.putLong(this.messageIndexLength());
        dataOutput.putString(this.compression().getName());
        dataOutput.putLong(this.recordsCompressedLength());
        dataOutput.putLong(this.recordsUncompressedLength());
    }

    @Override
    default public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addLong(this.messageStartTime());
        crc32.addLong(this.messageEndTime());
        crc32.addLong(this.chunkOffset());
        crc32.addLong(this.chunkLength());
        crc32.addCollection(this.messageIndexOffsets());
        crc32.addLong(this.messageIndexLength());
        crc32.addString(this.compression().getName());
        crc32.addLong(this.recordsCompressedLength());
        crc32.addLong(this.recordsUncompressedLength());
        return crc32;
    }

    @Override
    default public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ":";
        out = out + "\n\t-messageStartTime = " + this.messageStartTime();
        out = out + "\n\t-messageEndTime = " + this.messageEndTime();
        out = out + "\n\t-chunkOffset = " + this.chunkOffset();
        out = out + "\n\t-chunkLength = " + this.chunkLength();
        out = out + "\n\t-messageIndexOffsetsLength = " + this.messageIndexOffsetsLength();
        List<MessageIndexOffset> messageIndexOffsets = this.messageIndexOffsets();
        out = out + "\n\t-messageIndexOffsets = " + (String)(messageIndexOffsets == null ? "null" : "\n" + EuclidCoreIOTools.getCollectionString((String)"\n", messageIndexOffsets, e -> e.toString(indent + 1)));
        out = out + "\n\t-messageIndexLength = " + this.messageIndexLength();
        out = out + "\n\t-compression = " + String.valueOf((Object)this.compression());
        out = out + "\n\t-compressedSize = " + this.recordsCompressedLength();
        out = out + "\n\t-uncompressedSize = " + this.recordsUncompressedLength();
        return MCAPElement.indent(out, indent);
    }

    @Override
    default public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof ChunkIndex) {
            ChunkIndex other = (ChunkIndex)mcapElement;
            if (this.messageStartTime() != other.messageStartTime()) {
                return false;
            }
            if (this.messageEndTime() != other.messageEndTime()) {
                return false;
            }
            if (this.chunkOffset() != other.chunkOffset()) {
                return false;
            }
            if (this.chunkLength() != other.chunkLength()) {
                return false;
            }
            if (this.messageIndexOffsetsLength() != other.messageIndexOffsetsLength()) {
                return false;
            }
            if (!Objects.equals(this.messageIndexOffsets(), other.messageIndexOffsets())) {
                return false;
            }
            if (this.messageIndexLength() != other.messageIndexLength()) {
                return false;
            }
            if (this.compression() != other.compression()) {
                return false;
            }
            if (this.recordsCompressedLength() != other.recordsCompressedLength()) {
                return false;
            }
            return this.recordsUncompressedLength() == other.recordsUncompressedLength();
        }
        return false;
    }
}

