/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointBasics;
import us.ihmc.scs2.session.mcap.MCAPFrameTransformManager;
import us.ihmc.scs2.session.mcap.RobotStateUpdater;
import us.ihmc.scs2.simulation.robot.Robot;

public class MCAPFrameTransformBasedRobotStateUpdater
implements RobotStateUpdater {
    private final List<Runnable> jointStateUpdaters = new ArrayList<Runnable>();

    public MCAPFrameTransformBasedRobotStateUpdater(Robot robot, MCAPFrameTransformManager frameTransformManager) {
        for (JointBasics joint : robot.getAllJoints()) {
            String successorName = joint.getSuccessor().getName();
            String predecessorName = joint.getPredecessor().getName();
            MCAPFrameTransformManager.YoFoxGloveFrameTransform transform = frameTransformManager.getTransformFromSanitizedName(successorName);
            if (transform == null) {
                LogTools.error((String)("No transform found for " + successorName));
                continue;
            }
            MCAPFrameTransformManager.YoFoxGloveFrameTransform parentJointTransform = frameTransformManager.getTransformFromSanitizedName(predecessorName);
            if (parentJointTransform == null) {
                LogTools.error((String)("No transform found for " + predecessorName));
                continue;
            }
            if (joint instanceof OneDoFJointBasics) {
                OneDoFJointBasics oneDoFJoint = (OneDoFJointBasics)joint;
                this.jointStateUpdaters.add(new OneDoFJointStateUpdater(oneDoFJoint, transform, parentJointTransform));
                continue;
            }
            if (!(joint instanceof SixDoFJointBasics)) continue;
            SixDoFJointBasics sixDoFJoint = (SixDoFJointBasics)joint;
            this.jointStateUpdaters.add(new SixDoFJointStateUpdater(sixDoFJoint, transform));
        }
    }

    @Override
    public void updateRobotState() {
        for (Runnable jointStateUpdater : this.jointStateUpdaters) {
            jointStateUpdater.run();
        }
    }

    public static class OneDoFJointStateUpdater
    implements Runnable {
        private final OneDoFJointBasics joint;
        private final MCAPFrameTransformManager.YoFoxGloveFrameTransform transform;
        private final MCAPFrameTransformManager.YoFoxGloveFrameTransform parentJointTransform;
        private final RigidBodyTransform jointConfiguration = new RigidBodyTransform();

        public OneDoFJointStateUpdater(OneDoFJointBasics joint, MCAPFrameTransformManager.YoFoxGloveFrameTransform transform, MCAPFrameTransformManager.YoFoxGloveFrameTransform parentJointTransform) {
            this.joint = joint;
            this.transform = transform;
            this.parentJointTransform = parentJointTransform;
        }

        @Override
        public void run() {
            RigidBodyTransform beforeJointTransform = this.joint.getFrameBeforeJoint().getTransformToParent();
            RigidBodyTransformReadOnly transformParentJointToRoot = this.parentJointTransform.getTransformToRoot();
            RigidBodyTransformReadOnly transformToRoot = this.transform.getTransformToRoot();
            this.jointConfiguration.setIdentity();
            this.jointConfiguration.setAndInvert((RigidBodyTransformReadOnly)beforeJointTransform);
            this.jointConfiguration.multiplyInvertOther(transformParentJointToRoot);
            this.jointConfiguration.multiply(transformToRoot);
            this.joint.setJointConfiguration((RigidBodyTransformReadOnly)this.jointConfiguration);
        }
    }

    public static class SixDoFJointStateUpdater
    implements Runnable {
        private final SixDoFJointBasics joint;
        private final MCAPFrameTransformManager.YoFoxGloveFrameTransform transform;

        public SixDoFJointStateUpdater(SixDoFJointBasics joint, MCAPFrameTransformManager.YoFoxGloveFrameTransform transform) {
            this.joint = joint;
            this.transform = transform;
        }

        @Override
        public void run() {
            RigidBodyTransformReadOnly transformToParentJoint = this.transform.getTransformToParent();
            this.joint.setJointConfiguration(transformToParentJoint);
        }
    }
}

