/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.List;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.Records;

public class SummaryOffset
implements MCAPElement {
    int ELEMENT_LENGTH = 17;
    private final MCAPDataInput dataInput;
    private final Opcode groupOpcode;
    private final long groupOffset;
    private final long groupLength;
    private Reference<Records> groupRef;

    public SummaryOffset(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        this.dataInput = dataInput;
        dataInput.position(elementPosition);
        this.groupOpcode = Opcode.byId(dataInput.getUnsignedByte());
        this.groupOffset = MCAP.checkPositiveLong(dataInput.getLong(), "offsetGroup");
        this.groupLength = MCAP.checkPositiveLong(dataInput.getLong(), "lengthGroup");
        MCAP.checkLength(elementLength, this.getElementLength());
    }

    public SummaryOffset(Opcode groupOpcode, long groupOffset, long groupLength) {
        this.dataInput = null;
        this.groupOpcode = groupOpcode;
        this.groupOffset = groupOffset;
        this.groupLength = groupLength;
    }

    public SummaryOffset(long groupOffset, List<Record> recordGroup) {
        if (recordGroup.isEmpty()) {
            throw new IllegalArgumentException("The record group cannot be empty");
        }
        this.groupOpcode = recordGroup.get(0).op();
        if (recordGroup.stream().anyMatch(record -> record.op() != this.groupOpcode)) {
            throw new IllegalArgumentException("All records in the group must have the same opcode");
        }
        this.groupOffset = groupOffset;
        this.groupLength = recordGroup.stream().mapToLong(MCAPElement::getElementLength).sum();
        this.groupRef = new SoftReference<Records>(new Records(recordGroup));
        this.dataInput = null;
    }

    @Override
    public long getElementLength() {
        return this.ELEMENT_LENGTH;
    }

    public Records group() {
        Records group;
        Records records = group = this.groupRef == null ? null : this.groupRef.get();
        if (group == null) {
            if (this.dataInput == null) {
                throw new IllegalStateException("This record is not backed by a data input.");
            }
            group = Records.load(this.dataInput, this.groupOffset, (int)this.groupLength);
            this.groupRef = new WeakReference<Records>(group);
        }
        return group;
    }

    public Opcode groupOpcode() {
        return this.groupOpcode;
    }

    public long groupOffset() {
        return this.groupOffset;
    }

    public long groupLength() {
        return this.groupLength;
    }

    @Override
    public void write(MCAPDataOutput dataOutput) {
        dataOutput.putUnsignedByte(this.groupOpcode().id());
        dataOutput.putLong(this.groupOffset());
        dataOutput.putLong(this.groupLength());
    }

    @Override
    public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addUnsignedByte(this.groupOpcode().id());
        crc32.addLong(this.groupOffset());
        crc32.addLong(this.groupLength());
        return crc32;
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ": ";
        out = out + "\n\t-groupOpcode = " + String.valueOf((Object)this.groupOpcode());
        out = out + "\n\t-groupOffset = " + this.groupOffset();
        out = out + "\n\t-groupLength = " + this.groupLength();
        return MCAPElement.indent(out, indent);
    }

    public boolean equals(Object object) {
        SummaryOffset other;
        return object instanceof SummaryOffset && this.equals(other = (SummaryOffset)object);
    }

    @Override
    public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof SummaryOffset) {
            SummaryOffset other = (SummaryOffset)mcapElement;
            if (this.groupOpcode() != other.groupOpcode()) {
                return false;
            }
            if (this.groupOffset() != other.groupOffset()) {
                return false;
            }
            return this.groupLength() == other.groupLength();
        }
        return false;
    }
}

