/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Schema;

public class SchemaDataInputBacked
implements Schema {
    private final MCAPDataInput dataInput;
    private final int id;
    private final String name;
    private final String encoding;
    private final long dataLength;
    private final long dataOffset;
    private WeakReference<ByteBuffer> dataRef;

    public SchemaDataInputBacked(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        this.dataInput = dataInput;
        dataInput.position(elementPosition);
        this.id = dataInput.getUnsignedShort();
        this.name = dataInput.getString();
        this.encoding = dataInput.getString();
        this.dataLength = dataInput.getUnsignedInt();
        this.dataOffset = dataInput.position();
        MCAP.checkLength(elementLength, this.getElementLength());
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String encoding() {
        return this.encoding;
    }

    @Override
    public long dataLength() {
        return this.dataLength;
    }

    @Override
    public ByteBuffer data() {
        ByteBuffer data;
        ByteBuffer byteBuffer = data = this.dataRef == null ? null : (ByteBuffer)this.dataRef.get();
        if (data == null) {
            data = this.dataInput.getByteBuffer(this.dataOffset, (int)this.dataLength, false);
            this.dataRef = new WeakReference<ByteBuffer>(data);
        }
        return data;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        Schema schema;
        return object instanceof Schema && Schema.super.equals(schema = (Schema)object);
    }
}

