/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.Objects;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.AttachmentIndexDataInputBacked;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.Record;

public interface AttachmentIndex
extends MCAPElement {
    public static AttachmentIndex load(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        return new AttachmentIndexDataInputBacked(dataInput, elementPosition, elementLength);
    }

    @Override
    default public long getElementLength() {
        return 48 + this.name().length() + this.mediaType().length();
    }

    public Record attachment();

    public long attachmentOffset();

    public long attachmentLength();

    public long logTime();

    public long createTime();

    public long dataLength();

    public String name();

    public String mediaType();

    @Override
    default public void write(MCAPDataOutput dataOutput) {
        dataOutput.putLong(this.attachmentOffset());
        dataOutput.putLong(this.attachmentLength());
        dataOutput.putLong(this.logTime());
        dataOutput.putLong(this.createTime());
        dataOutput.putLong(this.dataLength());
        dataOutput.putString(this.name());
        dataOutput.putString(this.mediaType());
    }

    @Override
    default public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addLong(this.attachmentOffset());
        crc32.addLong(this.attachmentLength());
        crc32.addLong(this.logTime());
        crc32.addLong(this.createTime());
        crc32.addLong(this.dataLength());
        crc32.addString(this.name());
        crc32.addString(this.mediaType());
        return crc32;
    }

    @Override
    default public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ":";
        out = out + "\n\t-attachmentOffset = " + this.attachmentOffset();
        out = out + "\n\t-attachmentLength = " + this.attachmentLength();
        out = out + "\n\t-logTime = " + this.logTime();
        out = out + "\n\t-createTime = " + this.createTime();
        out = out + "\n\t-dataLength = " + this.dataLength();
        out = out + "\n\t-name = " + this.name();
        out = out + "\n\t-mediaType = " + this.mediaType();
        return MCAPElement.indent(out, indent);
    }

    @Override
    default public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof AttachmentIndex) {
            AttachmentIndex other = (AttachmentIndex)mcapElement;
            if (this.attachmentOffset() != other.attachmentOffset()) {
                return false;
            }
            if (this.attachmentLength() != other.attachmentLength()) {
                return false;
            }
            if (this.logTime() != other.logTime()) {
                return false;
            }
            if (this.createTime() != other.createTime()) {
                return false;
            }
            if (this.dataLength() != other.dataLength()) {
                return false;
            }
            if (!Objects.equals(this.name(), other.name())) {
                return false;
            }
            return Objects.equals(this.mediaType(), other.mediaType());
        }
        return false;
    }
}

