/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;

public class ChannelMessageCount
implements MCAPElement {
    public static final long ELEMENT_LENGTH = 10L;
    private final int channelId;
    private long messageCount;

    public ChannelMessageCount(MCAPDataInput dataInput, long elementPosition) {
        dataInput.position(elementPosition);
        this.channelId = dataInput.getUnsignedShort();
        this.messageCount = dataInput.getLong();
    }

    public ChannelMessageCount(int channelId) {
        this(channelId, 0L);
    }

    public ChannelMessageCount(int channelId, long messageCount) {
        this.channelId = channelId;
        this.messageCount = messageCount;
    }

    @Override
    public long getElementLength() {
        return 10L;
    }

    public int channelId() {
        return this.channelId;
    }

    public void incrementMessageCount() {
        ++this.messageCount;
    }

    public void setMessageCount(long messageCount) {
        this.messageCount = messageCount;
    }

    public long messageCount() {
        return this.messageCount;
    }

    @Override
    public void write(MCAPDataOutput dataOutput) {
        dataOutput.putUnsignedShort(this.channelId);
        dataOutput.putLong(this.messageCount);
    }

    @Override
    public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addUnsignedShort(this.channelId);
        crc32.addLong(this.messageCount);
        return crc32;
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ":";
        out = out + "\n\t-channelId = " + this.channelId;
        out = out + "\n\t-messageCount = " + this.messageCount;
        return MCAPElement.indent(out, indent);
    }

    public boolean equals(Object object) {
        ChannelMessageCount other;
        return object instanceof ChannelMessageCount && this.equals(other = (ChannelMessageCount)object);
    }

    @Override
    public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof ChannelMessageCount) {
            ChannelMessageCount other = (ChannelMessageCount)mcapElement;
            if (this.channelId() != other.channelId()) {
                return false;
            }
            return this.messageCount() == other.messageCount();
        }
        return false;
    }
}

