/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Chunk;
import us.ihmc.scs2.session.mcap.specs.records.ChunkIndex;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Record;

public class MCAPValidator {
    public static boolean validateChunkTimestamps(MCAP mcap) {
        for (Record record : mcap.records()) {
            long endTime;
            if (record.op() != Opcode.CHUNK) continue;
            Chunk chunk = (Chunk)record.body();
            long startTime = chunk.messageStartTime();
            if (startTime > (endTime = chunk.messageEndTime())) {
                return false;
            }
            if (startTime != chunk.records().getMessageStartTime()) {
                return false;
            }
            if (endTime == chunk.records().getMessageEndTime()) continue;
            return false;
        }
        for (Record record : mcap.records()) {
            if (record.op() != Opcode.CHUNK_INDEX) continue;
            ChunkIndex chunkIndex = (ChunkIndex)record.body();
            Chunk chunk = null;
            try {
                chunk = (Chunk)chunkIndex.chunk().body();
            }
            catch (Exception e) {
                return false;
            }
            long startTime = chunkIndex.messageStartTime();
            long endTime = chunkIndex.messageEndTime();
            if (startTime > endTime) {
                return false;
            }
            if (startTime != chunk.messageStartTime()) {
                return false;
            }
            if (endTime == chunk.messageEndTime()) continue;
            return false;
        }
        return true;
    }
}

