/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import us.ihmc.scs2.session.mcap.specs.records.Chunk;
import us.ihmc.scs2.session.mcap.specs.records.ChunkIndex;
import us.ihmc.scs2.session.mcap.specs.records.Compression;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndexOffset;
import us.ihmc.scs2.session.mcap.specs.records.Record;

public class MutableChunkIndex
implements ChunkIndex {
    private Record chunk;
    private long messageStartTime;
    private long messageEndTime;
    private long chunkOffset;
    private long chunkLength;
    private long messageIndexOffsetsLength;
    private List<MessageIndexOffset> messageIndexOffsets;
    private long messageIndexLength;
    private Compression compression;
    private long recordsCompressedLength;
    private long recordsUncompressedLength;

    @Override
    public Record chunk() {
        return this.chunk;
    }

    public void setChunk(Record chunk) {
        this.chunk = chunk;
        Chunk body = (Chunk)chunk.body();
        this.messageStartTime = body.messageStartTime();
        this.messageEndTime = body.messageEndTime();
        this.chunkLength = chunk.getElementLength();
        this.messageIndexOffsets = new ArrayList<MessageIndexOffset>();
        this.messageIndexOffsetsLength = 0L;
        this.compression = body.compression();
        this.recordsCompressedLength = body.recordsCompressedLength();
        this.recordsUncompressedLength = body.recordsUncompressedLength();
    }

    @Override
    public long messageStartTime() {
        return this.messageStartTime;
    }

    public void setMessageStartTime(long messageStartTime) {
        this.messageStartTime = messageStartTime;
    }

    @Override
    public long messageEndTime() {
        return this.messageEndTime;
    }

    public void setMessageEndTime(long messageEndTime) {
        this.messageEndTime = messageEndTime;
    }

    @Override
    public long chunkOffset() {
        return this.chunkOffset;
    }

    public void setChunkOffset(long chunkOffset) {
        this.chunkOffset = chunkOffset;
    }

    @Override
    public long chunkLength() {
        return this.chunkLength;
    }

    public void setChunkLength(long chunkLength) {
        this.chunkLength = chunkLength;
    }

    @Override
    public long messageIndexOffsetsLength() {
        return this.messageIndexOffsetsLength;
    }

    public void setMessageIndexOffsetsLength(long messageIndexOffsetsLength) {
        this.messageIndexOffsetsLength = messageIndexOffsetsLength;
    }

    @Override
    public List<MessageIndexOffset> messageIndexOffsets() {
        return this.messageIndexOffsets;
    }

    public void setMessageIndexOffsets(List<MessageIndexOffset> messageIndexOffsets) {
        this.messageIndexOffsets = messageIndexOffsets;
        this.messageIndexOffsetsLength = messageIndexOffsets.stream().mapToLong(MessageIndexOffset::getElementLength).sum();
    }

    @Override
    public long messageIndexLength() {
        return this.messageIndexLength;
    }

    public void setMessageIndexLength(long messageIndexLength) {
        this.messageIndexLength = messageIndexLength;
    }

    @Override
    public Compression compression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    @Override
    public long recordsCompressedLength() {
        return this.recordsCompressedLength;
    }

    public void setRecordsCompressedLength(long recordsCompressedLength) {
        this.recordsCompressedLength = recordsCompressedLength;
    }

    @Override
    public long recordsUncompressedLength() {
        return this.recordsUncompressedLength;
    }

    public void setRecordsUncompressedLength(long recordsUncompressedLength) {
        this.recordsUncompressedLength = recordsUncompressedLength;
    }

    @Override
    public long getElementLength() {
        Objects.requireNonNull(this.messageIndexOffsets, "The message index offsets must be set before calling this method.");
        Objects.requireNonNull(this.compression, "The compression must be set before calling this method.");
        return 60L + this.messageIndexOffsetsLength + (long)this.compression.getLength();
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        ChunkIndex other;
        return object instanceof ChunkIndex && ChunkIndex.super.equals(other = (ChunkIndex)object);
    }
}

