/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.lang.ref.WeakReference;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.MetadataIndex;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.RecordDataInputBacked;

public class MetadataIndexDataInputBacked
implements MetadataIndex {
    private final MCAPDataInput dataInput;
    private final long metadataOffset;
    private final long metadataLength;
    private final String name;
    private WeakReference<Record> metadataRef;

    MetadataIndexDataInputBacked(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        this.dataInput = dataInput;
        dataInput.position(elementPosition);
        this.metadataOffset = MCAP.checkPositiveLong(dataInput.getLong(), "metadataOffset");
        this.metadataLength = MCAP.checkPositiveLong(dataInput.getLong(), "metadataLength");
        this.name = dataInput.getString();
        MCAP.checkLength(elementLength, this.getElementLength());
    }

    @Override
    public Record metadata() {
        Record metadata;
        Record record = metadata = this.metadataRef == null ? null : (Record)this.metadataRef.get();
        if (metadata == null) {
            metadata = new RecordDataInputBacked(this.dataInput, this.metadataOffset);
            this.metadataRef = new WeakReference<Record>(metadata);
        }
        return metadata;
    }

    @Override
    public long metadataOffset() {
        return this.metadataOffset;
    }

    @Override
    public long metadataLength() {
        return this.metadataLength;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        MetadataIndex other;
        return object instanceof MetadataIndex && MetadataIndex.super.equals(other = (MetadataIndex)object);
    }
}

