/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.lang.ref.WeakReference;
import java.util.List;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndex;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndexEntry;

public class MessageIndexDataInputBacked
implements MessageIndex {
    private final MCAPDataInput dataInput;
    private final long elementLength;
    private final int channelId;
    private WeakReference<List<MessageIndexEntry>> messageIndexEntriesRef;
    private final long messageIndexEntriesOffset;
    private final long messageIndexEntriesLength;

    public MessageIndexDataInputBacked(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        this.dataInput = dataInput;
        this.elementLength = elementLength;
        dataInput.position(elementPosition);
        this.channelId = dataInput.getUnsignedShort();
        this.messageIndexEntriesLength = dataInput.getUnsignedInt();
        this.messageIndexEntriesOffset = dataInput.position();
    }

    @Override
    public long getElementLength() {
        return this.elementLength;
    }

    @Override
    public int channelId() {
        return this.channelId;
    }

    @Override
    public List<MessageIndexEntry> messageIndexEntries() {
        List<MessageIndexEntry> messageIndexEntries;
        List<MessageIndexEntry> list = messageIndexEntries = this.messageIndexEntriesRef == null ? null : (List<MessageIndexEntry>)this.messageIndexEntriesRef.get();
        if (messageIndexEntries == null) {
            messageIndexEntries = MCAP.parseList(this.dataInput, MessageIndexEntry::new, this.messageIndexEntriesOffset, this.messageIndexEntriesLength);
            this.messageIndexEntriesRef = new WeakReference<List<MessageIndexEntry>>(messageIndexEntries);
        }
        return messageIndexEntries;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        MessageIndex other;
        return object instanceof MessageIndex && MessageIndex.super.equals(other = (MessageIndex)object);
    }
}

