/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;

public class MessageIndexOffset
implements MCAPElement {
    private final int channelId;
    private final long offset;

    public MessageIndexOffset(MCAPDataInput dataInput, long elementPosition) {
        dataInput.position(elementPosition);
        this.channelId = dataInput.getUnsignedShort();
        this.offset = MCAP.checkPositiveLong(dataInput.getLong(), "offset");
    }

    public MessageIndexOffset(int channelId, long offset) {
        this.channelId = channelId;
        this.offset = offset;
    }

    @Override
    public long getElementLength() {
        return 10L;
    }

    public int channelId() {
        return this.channelId;
    }

    public long offset() {
        return this.offset;
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public void write(MCAPDataOutput dataOutput) {
        dataOutput.putUnsignedShort(this.channelId);
        dataOutput.putLong(this.offset);
    }

    @Override
    public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addUnsignedShort(this.channelId);
        crc32.addLong(this.offset);
        return crc32;
    }

    @Override
    public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ":";
        out = out + "\n\t-channelId = " + this.channelId();
        out = out + "\n\t-offset = " + this.offset();
        return MCAPElement.indent(out, indent);
    }

    public boolean equals(Object object) {
        MessageIndexOffset other;
        return object instanceof MessageIndexOffset && this.equals(other = (MessageIndexOffset)object);
    }

    @Override
    public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof MessageIndexOffset) {
            MessageIndexOffset other = (MessageIndexOffset)mcapElement;
            if (this.channelId() != other.channelId()) {
                return false;
            }
            return this.offset() == other.offset();
        }
        return false;
    }
}

