/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.Objects;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Record;

public class MutableRecord
implements Record {
    private Opcode op;
    private Object body;

    public MutableRecord() {
    }

    public MutableRecord(Object body) {
        this.op = body == null ? null : Opcode.byBodyType(body.getClass());
        this.body = body;
    }

    public void setOp(Opcode op) {
        this.op = op;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    @Override
    public Opcode op() {
        return this.op;
    }

    @Override
    public <T> T body() {
        return (T)this.body;
    }

    @Override
    public void write(MCAPDataOutput dataOutput, boolean writeBody) {
        dataOutput.putUnsignedByte(this.op == null ? 0 : this.op.id());
        dataOutput.putLong(this.bodyLength());
        if (writeBody) {
            if (this.body instanceof MCAPElement) {
                ((MCAPElement)this.body).write(dataOutput);
            } else if (this.body instanceof byte[]) {
                dataOutput.putBytes((byte[])this.body);
            } else {
                throw new UnsupportedOperationException("Unsupported body type: " + this.body.getClass());
            }
        }
    }

    @Override
    public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addUnsignedByte(this.op == null ? 0 : this.op.id());
        crc32.addLong(this.bodyLength());
        if (this.body instanceof MCAPElement) {
            ((MCAPElement)this.body).updateCRC(crc32);
        } else if (this.body instanceof byte[]) {
            crc32.addBytes((byte[])this.body);
        } else {
            throw new UnsupportedOperationException("Unsupported body type: " + this.body.getClass());
        }
        return crc32;
    }

    @Override
    public long getElementLength() {
        return 9L + this.bodyLength();
    }

    @Override
    public long bodyLength() {
        long bodyLength;
        Objects.requireNonNull(this.body);
        if (this.body instanceof MCAPElement) {
            bodyLength = ((MCAPElement)this.body).getElementLength();
        } else if (this.body instanceof byte[]) {
            bodyLength = ((byte[])this.body).length;
        } else {
            throw new UnsupportedOperationException("Unsupported body type: " + this.body.getClass());
        }
        return bodyLength;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        Record other;
        return object instanceof Record && Record.super.equals(other = (Record)object);
    }
}

