/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.nio.ByteBuffer;
import java.util.Objects;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.MessageDataInputBacked;

public interface Message
extends MCAPElement {
    public static Message load(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        return new MessageDataInputBacked(dataInput, elementPosition, elementLength);
    }

    public int channelId();

    public long sequence();

    public long logTime();

    public long publishTime();

    public long dataOffset();

    public int dataLength();

    public ByteBuffer messageBuffer();

    public byte[] messageData();

    @Override
    default public void write(MCAPDataOutput dataOutput) {
        dataOutput.putUnsignedShort(this.channelId());
        dataOutput.putUnsignedInt(this.sequence());
        dataOutput.putLong(this.logTime());
        dataOutput.putLong(this.publishTime());
        dataOutput.putUnsignedInt(this.dataLength());
        dataOutput.putByteBuffer(this.messageBuffer());
    }

    @Override
    default public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addUnsignedShort(this.channelId());
        crc32.addUnsignedInt(this.sequence());
        crc32.addLong(this.logTime());
        crc32.addLong(this.publishTime());
        crc32.addUnsignedInt(this.dataLength());
        crc32.addByteBuffer(this.messageBuffer());
        return crc32;
    }

    @Override
    default public long getElementLength() {
        return this.dataLength() + 2 + 4 + 16;
    }

    @Override
    default public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof Message) {
            Message other = (Message)mcapElement;
            if (this.channelId() != other.channelId()) {
                return false;
            }
            if (this.sequence() != other.sequence()) {
                return false;
            }
            if (this.logTime() != other.logTime()) {
                return false;
            }
            if (this.publishTime() != other.publishTime()) {
                return false;
            }
            if (this.dataLength() != other.dataLength()) {
                return false;
            }
            return Objects.equals(this.messageBuffer(), other.messageBuffer());
        }
        return false;
    }
}

