/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import com.github.luben.zstd.ZstdCompressCtx;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Objects;
import us.ihmc.scs2.session.mcap.encoding.LZ4FrameEncoder;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.output.MCAPByteBufferDataOutput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.Chunk;
import us.ihmc.scs2.session.mcap.specs.records.Compression;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.Records;

public class MutableChunk
implements Chunk {
    private Compression compression = Compression.LZ4;
    private Records records;
    private long lastRecordsCRC32 = -1L;
    private ByteBuffer recordsCompressedData;

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public void setRecords(Collection<? extends Record> records) {
        this.records = new Records(records);
    }

    @Override
    public long messageStartTime() {
        return this.records.getMessageStartTime();
    }

    @Override
    public long messageEndTime() {
        return this.records.getMessageEndTime();
    }

    @Override
    public long recordsUncompressedLength() {
        return this.records.getElementLength();
    }

    @Override
    public long uncompressedCRC32() {
        return this.records.getCRC32();
    }

    @Override
    public Compression compression() {
        return this.compression;
    }

    @Override
    public long recordsCompressedLength() {
        return this.getRecordsCompressedBuffer().remaining();
    }

    @Override
    public Records records() {
        return this.records;
    }

    @Override
    public long getElementLength() {
        this.getRecordsCompressedBuffer();
        return (long)(36 + this.compression.getLength()) + this.recordsCompressedLength();
    }

    @Override
    public ByteBuffer getRecordsCompressedBuffer(boolean directBuffer) {
        long newRecordsCRC32 = this.uncompressedCRC32();
        if (this.recordsCompressedData == null || this.lastRecordsCRC32 != newRecordsCRC32) {
            ByteBuffer byteBuffer;
            this.lastRecordsCRC32 = newRecordsCRC32;
            Objects.requireNonNull(this.compression, "The compression has not been set yet.");
            Objects.requireNonNull(this.records, "The records have not been set yet.");
            ByteBuffer uncompressedBuffer = this.getRecordsUncompressedBuffer(this.compression == Compression.ZSTD);
            MutableChunk mutableChunk = this;
            switch (this.compression) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NONE: {
                    ByteBuffer byteBuffer2 = uncompressedBuffer;
                    MutableChunk mutableChunk2 = mutableChunk;
                    byteBuffer = byteBuffer2;
                    break;
                }
                case LZ4: {
                    LZ4FrameEncoder lz4FrameEncoder = new LZ4FrameEncoder();
                    ByteBuffer byteBuffer3 = lz4FrameEncoder.encode(uncompressedBuffer, null);
                    MutableChunk mutableChunk2 = mutableChunk;
                    byteBuffer = byteBuffer3;
                    break;
                }
                case ZSTD: {
                    MutableChunk mutableChunk2;
                    try (ZstdCompressCtx zstdCompressCtx = new ZstdCompressCtx();){
                        ByteBuffer byteBuffer4 = zstdCompressCtx.compress(uncompressedBuffer);
                        mutableChunk2 = mutableChunk;
                        byteBuffer = byteBuffer4;
                        break;
                    }
                }
            }
            mutableChunk2.recordsCompressedData = byteBuffer;
            this.recordsCompressedData.order(ByteOrder.LITTLE_ENDIAN);
        }
        return this.recordsCompressedData.duplicate();
    }

    @Override
    public ByteBuffer getRecordsUncompressedBuffer(boolean directBuffer) {
        MCAPByteBufferDataOutput recordsOutput = new MCAPByteBufferDataOutput((int)this.records.getElementLength(), 2, directBuffer);
        this.records.forEach(element -> element.write(recordsOutput));
        recordsOutput.close();
        return recordsOutput.getBuffer();
    }

    @Override
    public void write(MCAPDataOutput dataOutput) {
        dataOutput.putLong(this.messageStartTime());
        dataOutput.putLong(this.messageEndTime());
        dataOutput.putLong(this.recordsUncompressedLength());
        dataOutput.putUnsignedInt(this.uncompressedCRC32());
        dataOutput.putString(this.compression.getName());
        ByteBuffer recordsCompressedBuffer = this.getRecordsCompressedBuffer();
        dataOutput.putLong(recordsCompressedBuffer.remaining());
        dataOutput.putByteBuffer(recordsCompressedBuffer);
    }

    @Override
    public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addLong(this.messageStartTime());
        crc32.addLong(this.messageEndTime());
        crc32.addLong(this.recordsUncompressedLength());
        crc32.addUnsignedInt(this.uncompressedCRC32());
        crc32.addString(this.compression.getName());
        ByteBuffer recordsCompressedBuffer = this.getRecordsCompressedBuffer();
        crc32.addLong(recordsCompressedBuffer.remaining());
        crc32.addByteBuffer(recordsCompressedBuffer);
        return crc32;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        Chunk other;
        return object instanceof Chunk && Chunk.super.equals(other = (Chunk)object);
    }
}

