/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.Locale;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import net.jpountz.xxhash.StreamingXXHash32;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;

public class LZ4FrameDecoder {
    static final String PREMATURE_EOS = "Stream ended prematurely";
    static final String NOT_SUPPORTED = "Stream unsupported";
    static final String BLOCK_HASH_MISMATCH = "Block checksum mismatch";
    static final String DESCRIPTOR_HASH_MISMATCH = "Stream frame descriptor corrupted";
    static final int MAGIC_SKIPPABLE_BASE = 407710288;
    static final int MAGIC = 407708164;
    static final int LZ4_MAX_HEADER_LENGTH = 15;
    static final int INTEGER_BYTES = 4;
    static final int LONG_BYTES = 8;
    static final int LZ4_FRAME_INCOMPRESSIBLE_MASK = Integer.MIN_VALUE;
    private final LZ4SafeDecompressor decompressor;
    private final XXHash32 checksum;
    private final byte[] headerArray = new byte[15];
    private final ByteBuffer headerBuffer = ByteBuffer.wrap(this.headerArray).order(ByteOrder.LITTLE_ENDIAN);
    private byte[] compressedBuffer;
    private byte[] rawBuffer = null;
    private int maxBlockSize = -1;
    private long expectedContentSize = -1L;
    private long totalContentSize = 0L;
    private boolean firstFrameHeaderRead = false;
    private FrameInfo frameInfo = null;

    public LZ4FrameDecoder() {
        this(LZ4Factory.fastestInstance().safeDecompressor(), XXHashFactory.fastestInstance().hash32());
    }

    public LZ4FrameDecoder(LZ4SafeDecompressor decompressor, XXHash32 checksum) {
        this.decompressor = decompressor;
        this.checksum = checksum;
    }

    private boolean nextFrameInfo(ByteBuffer in) {
        while (true) {
            if (in.remaining() < 4) {
                throw new IllegalStateException(PREMATURE_EOS);
            }
            int magic = in.getInt();
            if (magic == 407708164) {
                this.readHeader(in);
                return true;
            }
            if (magic >>> 4 != 25481893) break;
            this.skippableFrame(in);
        }
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    private void skippableFrame(ByteBuffer in) {
        int skipSize = in.getInt();
        in.position(in.position() + skipSize);
        this.firstFrameHeaderRead = true;
    }

    private void readHeader(ByteBuffer in) {
        byte expectedHash;
        this.headerBuffer.rewind();
        byte flgByte = in.get();
        byte bdByte = in.get();
        FLG flg = FLG.fromByte(flgByte);
        this.headerBuffer.put(flgByte);
        BD bd = BD.fromByte(bdByte);
        this.headerBuffer.put(bdByte);
        this.frameInfo = new FrameInfo(flg, bd);
        if (flg.isEnabled(FLG.Bits.CONTENT_SIZE)) {
            this.expectedContentSize = in.getLong();
            this.headerBuffer.putLong(this.expectedContentSize);
        }
        this.totalContentSize = 0L;
        byte hash = (byte)(this.checksum.hash(this.headerArray, 0, this.headerBuffer.position(), 0) >> 8 & 0xFF);
        if (hash != (expectedHash = in.get())) {
            throw new IllegalStateException(DESCRIPTOR_HASH_MISMATCH);
        }
        this.maxBlockSize = this.frameInfo.getBD().getBlockMaximumSize();
        this.compressedBuffer = new byte[this.maxBlockSize];
        this.rawBuffer = new byte[this.maxBlockSize];
        this.firstFrameHeaderRead = true;
    }

    private ByteBuffer readBlock(ByteBuffer in, ByteBuffer out) {
        int currentBufferSize;
        int hashCheck;
        boolean compressed;
        int blockSize = in.getInt();
        boolean bl = compressed = (blockSize & Integer.MIN_VALUE) == 0;
        if ((blockSize &= Integer.MAX_VALUE) == 0) {
            int contentChecksum;
            if (this.frameInfo.isEnabled(FLG.Bits.CONTENT_CHECKSUM) && (contentChecksum = in.getInt()) != this.frameInfo.currentStreamHash()) {
                throw new IllegalStateException("Content checksum mismatch");
            }
            if (this.frameInfo.isEnabled(FLG.Bits.CONTENT_SIZE) && this.expectedContentSize != this.totalContentSize) {
                throw new IllegalStateException("Size check mismatch");
            }
            this.frameInfo.finish();
            return null;
        }
        byte[] tmpBuffer = compressed ? this.compressedBuffer : this.rawBuffer;
        if (blockSize > this.maxBlockSize) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Block size %s exceeded max: %s", blockSize, this.maxBlockSize));
        }
        in.get(tmpBuffer, 0, blockSize);
        if (this.frameInfo.isEnabled(FLG.Bits.BLOCK_CHECKSUM) && (hashCheck = in.getInt()) != this.checksum.hash(tmpBuffer, 0, blockSize, 0)) {
            throw new IllegalStateException(BLOCK_HASH_MISMATCH);
        }
        if (compressed) {
            try {
                currentBufferSize = this.decompressor.decompress(tmpBuffer, 0, blockSize, this.rawBuffer, 0, this.rawBuffer.length);
            }
            catch (LZ4Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            currentBufferSize = blockSize;
        }
        if (this.frameInfo.isEnabled(FLG.Bits.CONTENT_CHECKSUM)) {
            this.frameInfo.updateStreamHash(this.rawBuffer, 0, currentBufferSize);
        }
        this.totalContentSize += (long)currentBufferSize;
        if (out != null) {
            out.put(this.rawBuffer, 0, currentBufferSize);
            return out;
        }
        ByteBuffer blockOut = ByteBuffer.wrap(this.rawBuffer);
        blockOut.limit(currentBufferSize);
        blockOut.position(0);
        return blockOut;
    }

    public byte[] decode(byte[] in, byte[] out) {
        return this.decode(in, 0, in.length, out, 0);
    }

    public byte[] decode(byte[] in, int inOffset, int inLength, byte[] out, int outOffset) {
        ByteBuffer result = this.decode(ByteBuffer.wrap(in, inOffset, inLength), out == null ? null : ByteBuffer.wrap(out, outOffset, out.length - outOffset));
        return result == null ? null : result.array();
    }

    public ByteBuffer decode(ByteBuffer in, ByteBuffer out) {
        return this.decode(in, 0, in.remaining(), out, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer decode(ByteBuffer in, int inOffset, int inLength, ByteBuffer out, int outOffset) {
        int limitPrev = in.limit();
        in.position(inOffset);
        in.limit(inOffset + inLength);
        in.order(ByteOrder.LITTLE_ENDIAN);
        if (out != null) {
            out.position(outOffset);
        }
        ByteBuffer whenOutIsNull = null;
        try {
            ByteBuffer byteBuffer;
            while (in.hasRemaining()) {
                if (!(this.firstFrameHeaderRead && !this.frameInfo.isFinished() || this.nextFrameInfo(in))) {
                    throw new IllegalStateException("Could not find the Frame Descriptor!");
                }
                ByteBuffer blockOut = this.readBlock(in, out);
                if (blockOut == null) break;
                if (out != null) continue;
                if (whenOutIsNull == null) {
                    whenOutIsNull = ByteBuffer.allocate(blockOut.remaining());
                    whenOutIsNull.put(0, blockOut, 0, blockOut.limit());
                    continue;
                }
                ByteBuffer extended = ByteBuffer.allocate(whenOutIsNull.remaining() + blockOut.remaining());
                extended.put(whenOutIsNull);
                extended.put(blockOut);
                whenOutIsNull = extended;
            }
            if (out != null) {
                out.flip();
                byteBuffer = out;
                return byteBuffer;
            }
            whenOutIsNull.flip();
            byteBuffer = whenOutIsNull;
            return byteBuffer;
        }
        finally {
            in.limit(limitPrev);
        }
    }

    static class FrameInfo {
        private final FLG flg;
        private final BD bd;
        private final StreamingXXHash32 streamHash;
        private boolean finished = false;

        public FrameInfo(FLG flg, BD bd) {
            this.flg = flg;
            this.bd = bd;
            this.streamHash = flg.isEnabled(FLG.Bits.CONTENT_CHECKSUM) ? XXHashFactory.fastestInstance().newStreamingHash32(0) : null;
        }

        public boolean isEnabled(FLG.Bits bit) {
            return this.flg.isEnabled(bit);
        }

        public FLG getFLG() {
            return this.flg;
        }

        public BD getBD() {
            return this.bd;
        }

        public void updateStreamHash(byte[] buff, int off, int len) {
            this.streamHash.update(buff, off, len);
        }

        public int currentStreamHash() {
            return this.streamHash.getValue();
        }

        public void finish() {
            this.finished = true;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }

    public static class FLG {
        private static final int DEFAULT_VERSION = 1;
        private final BitSet bitSet;
        private final int version;

        public FLG(int version, Bits ... bits) {
            this.bitSet = new BitSet(8);
            this.version = version;
            if (bits != null) {
                for (Bits bit : bits) {
                    this.bitSet.set(bit.position);
                }
            }
            this.validate();
        }

        private FLG(int version, byte b) {
            this.bitSet = BitSet.valueOf(new byte[]{b});
            this.version = version;
            this.validate();
        }

        public static FLG fromByte(byte flg) {
            byte versionMask = (byte)(flg & 0xC0);
            return new FLG(versionMask >>> 6, (byte)(flg ^ versionMask));
        }

        public byte toByte() {
            return (byte)(this.bitSet.toByteArray()[0] | (this.version & 3) << 6);
        }

        private void validate() {
            if (this.bitSet.get(Bits.RESERVED_0.position)) {
                throw new RuntimeException("Reserved0 field must be 0");
            }
            if (this.bitSet.get(Bits.RESERVED_1.position)) {
                throw new RuntimeException("Reserved1 field must be 0");
            }
            if (!this.bitSet.get(Bits.BLOCK_INDEPENDENCE.position)) {
                throw new RuntimeException("Dependent block stream is unsupported (BLOCK_INDEPENDENCE must be set)");
            }
            if (this.version != 1) {
                throw new RuntimeException(String.format(Locale.ROOT, "Version %d is unsupported", this.version));
            }
        }

        public boolean isEnabled(Bits bit) {
            return this.bitSet.get(bit.position);
        }

        public int getVersion() {
            return this.version;
        }

        public static enum Bits {
            RESERVED_0(0),
            RESERVED_1(1),
            CONTENT_CHECKSUM(2),
            CONTENT_SIZE(3),
            BLOCK_CHECKSUM(4),
            BLOCK_INDEPENDENCE(5);

            private final int position;

            private Bits(int position) {
                this.position = position;
            }
        }
    }

    public static class BD {
        private static final int RESERVED_MASK = 143;
        private final BLOCKSIZE blockSizeValue;

        private BD(BLOCKSIZE blockSizeValue) {
            this.blockSizeValue = blockSizeValue;
        }

        public static BD fromByte(byte bd) {
            int blockMaximumSize = bd >>> 4 & 7;
            if ((bd & 0x8F) > 0) {
                throw new RuntimeException("Reserved fields must be 0");
            }
            return new BD(BLOCKSIZE.valueOf(blockMaximumSize));
        }

        public int getBlockMaximumSize() {
            return 1 << 2 * this.blockSizeValue.getIndicator() + 8;
        }

        public byte toByte() {
            return (byte)((this.blockSizeValue.getIndicator() & 7) << 4);
        }
    }

    public static enum BLOCKSIZE {
        SIZE_64KB(4),
        SIZE_256KB(5),
        SIZE_1MB(6),
        SIZE_4MB(7);

        private final int indicator;

        private BLOCKSIZE(int indicator) {
            this.indicator = indicator;
        }

        public int getIndicator() {
            return this.indicator;
        }

        public static BLOCKSIZE valueOf(int indicator) {
            switch (indicator) {
                case 7: {
                    return SIZE_4MB;
                }
                case 6: {
                    return SIZE_1MB;
                }
                case 5: {
                    return SIZE_256KB;
                }
                case 4: {
                    return SIZE_64KB;
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Block size must be 4-7. Cannot use value of [%d]", indicator));
        }
    }
}

