/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.mcap.CDRDeserializer;
import us.ihmc.scs2.session.mcap.MCAP;
import us.ihmc.scs2.session.mcap.MCAPSchema;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public final class YoMCAPMessage {
    private final MCAPSchema schema;
    private final int channelId;
    private final YoRegistry registry;
    private final Consumer<CDRDeserializer> deserializer;
    private final CDRDeserializer cdr = new CDRDeserializer();
    public static final Map<String, YoConversionToolbox<?>> conversionMap;

    public static YoMCAPMessage newMessage(MCAPSchema schema, int channelId, YoRegistry registry) {
        return YoMCAPMessage.newMessage(schema, channelId, registry, schema.getSubSchemaMap());
    }

    private static YoMCAPMessage newMessage(MCAPSchema schema, int channelId, YoRegistry messageRegistry, Map<String, MCAPSchema> subSchemaMap) {
        Objects.requireNonNull(schema, "Schema cannot be null. name = " + messageRegistry.getName());
        ArrayList<Consumer<CDRDeserializer>> deserializers = new ArrayList<Consumer<CDRDeserializer>>();
        for (MCAPSchema.MCAPSchemaField field : schema.getFields()) {
            String fieldName = field.getName();
            if (field.isVector() && field.isArray()) {
                throw new IllegalArgumentException("Field cannot be both a vector and an array: " + field + ", registry: " + messageRegistry);
            }
            boolean isArrayOrVector = field.isArray() || field.isVector();
            Consumer<CDRDeserializer> deserializer = null;
            deserializer = !isArrayOrVector ? YoMCAPMessage.createYoVariable(field, messageRegistry) : YoMCAPMessage.createYoVariableArray(field, messageRegistry);
            if (deserializer != null) {
                deserializers.add(deserializer);
                continue;
            }
            if (!field.isComplexType()) {
                throw new IllegalStateException("Could not deserialize non-complex field of type: %s".formatted(field.getType()));
            }
            MCAPSchema subSchema = subSchemaMap.get(field.getType());
            if (subSchema == null) {
                throw new IllegalStateException("Could not find a schema for the type: %s. Might be missing a primitive type.".formatted(field.getType()));
            }
            if (!isArrayOrVector) {
                YoRegistry fieldRegistry = new YoRegistry(fieldName);
                messageRegistry.addChild(fieldRegistry);
                YoMCAPMessage subMessage = YoMCAPMessage.newMessage(subSchema, -1, fieldRegistry, subSchemaMap);
                deserializers.add(subMessage.deserializer);
                continue;
            }
            BiFunction<String, YoRegistry, YoMCAPMessage> elementBuilder = (name, yoRegistry) -> {
                YoMCAPMessage newElement = YoMCAPMessage.newMessage(subSchema, -1, new YoRegistry(name), subSchemaMap);
                messageRegistry.addChild(newElement.getRegistry());
                return newElement;
            };
            deserializers.add(YoMCAPMessage.createFieldArray(YoMCAPMessage.class, elementBuilder, YoMCAPMessage::deserialize, YoMCAPMessage::clearData, fieldName, field.isArray(), field.getMaxLength(), messageRegistry));
        }
        return new YoMCAPMessage(schema, channelId, messageRegistry, cdr -> {
            for (Consumer deserializer : deserializers) {
                deserializer.accept(cdr);
            }
        });
    }

    private YoMCAPMessage(MCAPSchema schema, int channelId, YoRegistry registry, Consumer<CDRDeserializer> deserializer) {
        this.schema = schema;
        this.channelId = channelId;
        this.registry = registry;
        this.deserializer = deserializer;
    }

    public MCAPSchema getSchema() {
        return this.schema;
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public void readMessage(MCAP.Message message) {
        if (message.channelId() != this.channelId) {
            throw new IllegalArgumentException("Expected channel ID: " + this.channelId + ", but received: " + message.channelId());
        }
        this.cdr.initialize(message.messageBuffer(), message.offsetData(), message.lengthData());
        try {
            this.deserialize(this.cdr);
        }
        catch (Exception e) {
            LogTools.error((String)("Deserialization failed for message: " + this.registry.getName() + ", schema ID: " + this.schema.getId() + ", schema name: " + this.schema.getName()));
            throw e;
        }
        finally {
            this.cdr.finalize(false);
        }
    }

    protected void deserialize(CDRDeserializer cdr) {
        this.deserializer.accept(cdr);
    }

    protected void clearData() {
        this.deserializer.accept(null);
    }

    protected static Consumer<CDRDeserializer> createYoVariable(MCAPSchema.MCAPSchemaField field, YoRegistry registry) {
        String fieldName = field.getName();
        String fieldType = field.getType();
        YoConversionToolbox<?> conversion = conversionMap.get(fieldType);
        return conversion != null ? conversion.createYoVariable(fieldName, registry) : null;
    }

    protected static Consumer<CDRDeserializer> createYoVariableArray(MCAPSchema.MCAPSchemaField field, YoRegistry registry) {
        int maxLength = field.getMaxLength();
        String fieldName = field.getName();
        String fieldType = field.getType();
        if (field.isVector() == field.isArray()) {
            throw new IllegalArgumentException("Field is neither a vector nor an array: " + field + ", registry: " + registry);
        }
        boolean isFixedSize = field.isArray();
        YoConversionToolbox<?> conversion = conversionMap.get(fieldType);
        if (conversion != null) {
            return YoMCAPMessage.createFieldArray(conversion.yoType(), conversion.yoBuilder(), conversion.deserializer(), conversion.yoResetter(), fieldName, isFixedSize, maxLength, registry);
        }
        return null;
    }

    protected static <T> Consumer<CDRDeserializer> createFieldArray(Class<T> variableType, BiFunction<String, YoRegistry, T> elementBuilder, BiConsumer<T, CDRDeserializer> elementDeserializer, Consumer<T> elementResetter, String name, boolean isFixedSize, int length, YoRegistry registry) {
        Object[] array = (Object[])Array.newInstance(variableType, length);
        for (int i = 0; i < length; ++i) {
            array[i] = elementBuilder.apply(name + "[" + i + "]", registry);
        }
        return cdr -> {
            if (cdr == null) {
                for (int i = 0; i < length; ++i) {
                    elementResetter.accept(array[i]);
                }
            } else if (isFixedSize) {
                cdr.read_array((elementIndex, des) -> elementDeserializer.accept(array[elementIndex], des), length);
            } else {
                int size;
                for (int i = size = cdr.read_sequence((elementIndex, des) -> elementDeserializer.accept(array[elementIndex], des)); i < length; ++i) {
                    elementResetter.accept(array[i]);
                }
            }
        };
    }

    static {
        ArrayList<YoConversionToolbox<Object>> allConversions = new ArrayList<YoConversionToolbox<Object>>();
        Consumer<YoBoolean> yoBooleanResetter = v -> v.set(false);
        Consumer<YoDouble> yoDoubleResetter = v -> v.set(Double.NaN);
        Consumer<YoInteger> yoIntegerResetter = v -> v.set(0);
        Consumer<YoLong> yoLongResetter = v -> v.set(0L);
        allConversions.add(new YoConversionToolbox<YoBoolean>("bool", YoBoolean.class, YoBoolean::new, (v, cdr) -> v.set(cdr.read_bool()), yoBooleanResetter));
        allConversions.add(new YoConversionToolbox<YoBoolean>("boolean", YoBoolean.class, YoBoolean::new, (v, cdr) -> v.set(cdr.read_bool()), yoBooleanResetter));
        allConversions.add(new YoConversionToolbox<YoDouble>("float64", YoDouble.class, YoDouble::new, (v, cdr) -> v.set(cdr.read_float64()), yoDoubleResetter));
        allConversions.add(new YoConversionToolbox<YoDouble>("double", YoDouble.class, YoDouble::new, (v, cdr) -> v.set(cdr.read_float64()), yoDoubleResetter));
        allConversions.add(new YoConversionToolbox<YoDouble>("float32", YoDouble.class, YoDouble::new, (v, cdr) -> v.set((double)cdr.read_float32()), yoDoubleResetter));
        allConversions.add(new YoConversionToolbox<YoDouble>("float", YoDouble.class, YoDouble::new, (v, cdr) -> v.set((double)cdr.read_float32()), yoDoubleResetter));
        allConversions.add(new YoConversionToolbox<YoInteger>("byte", YoInteger.class, YoInteger::new, (v, cdr) -> v.set((int)cdr.read_byte()), yoIntegerResetter));
        allConversions.add(new YoConversionToolbox<YoInteger>("char", YoInteger.class, YoInteger::new, (v, cdr) -> v.set((int)cdr.read_byte()), yoIntegerResetter));
        allConversions.add(new YoConversionToolbox<YoInteger>("octet", YoInteger.class, YoInteger::new, (v, cdr) -> v.set((int)cdr.read_byte()), yoIntegerResetter));
        allConversions.add(new YoConversionToolbox<YoInteger>("int8", YoInteger.class, YoInteger::new, (v, cdr) -> v.set((int)cdr.read_int8()), yoIntegerResetter));
        allConversions.add(new YoConversionToolbox<YoInteger>("uint8", YoInteger.class, YoInteger::new, (v, cdr) -> v.set(cdr.read_uint8()), yoIntegerResetter));
        allConversions.add(new YoConversionToolbox<YoInteger>("int16", YoInteger.class, YoInteger::new, (v, cdr) -> v.set((int)cdr.read_int16()), yoIntegerResetter));
        allConversions.add(new YoConversionToolbox<YoInteger>("short", YoInteger.class, YoInteger::new, (v, cdr) -> v.set((int)cdr.read_int16()), yoIntegerResetter));
        allConversions.add(new YoConversionToolbox<YoInteger>("uint16", YoInteger.class, YoInteger::new, (v, cdr) -> v.set(cdr.read_uint16()), yoIntegerResetter));
        allConversions.add(new YoConversionToolbox<YoInteger>("unsignedshort", YoInteger.class, YoInteger::new, (v, cdr) -> v.set(cdr.read_uint16()), yoIntegerResetter));
        allConversions.add(new YoConversionToolbox<YoInteger>("int32", YoInteger.class, YoInteger::new, (v, cdr) -> v.set(cdr.read_int32()), yoIntegerResetter));
        allConversions.add(new YoConversionToolbox<YoInteger>("long", YoInteger.class, YoInteger::new, (v, cdr) -> v.set(cdr.read_int32()), yoIntegerResetter));
        allConversions.add(new YoConversionToolbox<YoLong>("uint32", YoLong.class, YoLong::new, (v, cdr) -> v.set(cdr.read_uint32()), yoLongResetter));
        allConversions.add(new YoConversionToolbox<YoLong>("unsignedlong", YoLong.class, YoLong::new, (v, cdr) -> v.set(cdr.read_uint32()), yoLongResetter));
        allConversions.add(new YoConversionToolbox<YoLong>("int64", YoLong.class, YoLong::new, (v, cdr) -> v.set(cdr.read_int64()), yoLongResetter));
        allConversions.add(new YoConversionToolbox<YoLong>("longlong", YoLong.class, YoLong::new, (v, cdr) -> v.set(cdr.read_int64()), yoLongResetter));
        allConversions.add(new YoConversionToolbox<YoLong>("uint64", YoLong.class, YoLong::new, (v, cdr) -> v.set(cdr.read_uint64()), yoLongResetter));
        allConversions.add(new YoConversionToolbox<YoLong>("unsignedlonglong", YoLong.class, YoLong::new, (v, cdr) -> v.set(cdr.read_uint64()), yoLongResetter));
        allConversions.add(new YoConversionToolbox<YoVariable>("string", null, null, (v, cdr) -> cdr.read_string(), null));
        conversionMap = allConversions.stream().collect(Collectors.toMap(YoConversionToolbox::primitiveType, conversion -> conversion));
    }

    public record YoConversionToolbox<T extends YoVariable>(String primitiveType, Class<T> yoType, BiFunction<String, YoRegistry, T> yoBuilder, BiConsumer<T, CDRDeserializer> deserializer, Consumer<T> yoResetter) {
        public Consumer<CDRDeserializer> createYoVariable(String name, YoRegistry registry) {
            if (this.yoBuilder != null) {
                YoVariable yoVariable = (YoVariable)this.yoBuilder.apply(name, registry);
                return cdr -> {
                    if (cdr == null) {
                        try {
                            this.yoResetter.accept(yoVariable);
                        }
                        catch (Exception e) {
                            LogTools.error((String)("Failed to reset variable: " + yoVariable + ", registry: " + registry));
                            throw new RuntimeException(e);
                        }
                    }
                    try {
                        this.deserializer.accept(yoVariable, (CDRDeserializer)cdr);
                    }
                    catch (Exception e) {
                        LogTools.error((String)("Failed to deserialize variable: " + yoVariable + ", registry: " + registry));
                        throw new RuntimeException(e);
                    }
                };
            }
            if (this.deserializer != null) {
                return cdr -> {
                    if (cdr == null) {
                        if (this.yoResetter == null) {
                            return;
                        }
                        try {
                            this.yoResetter.accept(null);
                        }
                        catch (Exception e) {
                            LogTools.error((String)("Failed to reset variable: " + name + ", registry: " + registry));
                            throw new RuntimeException(e);
                        }
                    }
                    try {
                        this.deserializer.accept(null, (CDRDeserializer)cdr);
                    }
                    catch (Exception e) {
                        LogTools.error((String)("Failed to deserialize variable: " + name + ", registry: " + registry));
                        throw new RuntimeException(e);
                    }
                };
            }
            return null;
        }
    }
}

