/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.scs2.session.mcap.MCAP;
import us.ihmc.scs2.session.mcap.MCAPSchema;

public class ROS2SchemaParser {
    public static final String SUB_SCHEMA_SEPARATOR_REGEX = "\n(=+)\n";
    public static final String SUB_SCHEMA_PREFIX = "MSG: fastdds/";

    public static MCAPSchema loadSchema(MCAP.Schema mcapSchema) {
        MCAPSchema schema = ROS2SchemaParser.loadSchema(mcapSchema.name(), mcapSchema.id(), mcapSchema.data());
        mcapSchema.unloadData();
        return schema;
    }

    public static MCAPSchema loadSchema(String name, int id, byte[] data) {
        String schemasBundledString = new String(data);
        schemasBundledString = schemasBundledString.replaceAll("\r\n", "\n");
        String[] schemasStrings = schemasBundledString.split(SUB_SCHEMA_SEPARATOR_REGEX);
        List<MCAPSchema.MCAPSchemaField> fields = schemasStrings[0].lines().map(ROS2SchemaParser::parseMCAPSchemaField).collect(Collectors.toList());
        LinkedHashMap<String, MCAPSchema> subSchemaMap = new LinkedHashMap<String, MCAPSchema>();
        for (int i = 1; i < schemasStrings.length; ++i) {
            String schemaString = schemasStrings[i];
            int firstNewLineCharacter = schemaString.indexOf("\n");
            String firstLine = schemaString.substring(0, firstNewLineCharacter);
            String subName = firstLine.replace(SUB_SCHEMA_PREFIX, "").trim();
            List<MCAPSchema.MCAPSchemaField> subFields = schemaString.substring(firstNewLineCharacter + 1).lines().map(ROS2SchemaParser::parseMCAPSchemaField).collect(Collectors.toList());
            subSchemaMap.put(subName, new MCAPSchema(subName, -1, subFields, null));
        }
        for (MCAPSchema.MCAPSchemaField field : fields) {
            if (subSchemaMap.containsKey(field.getType())) {
                field.setComplexType(true);
            }
            for (MCAPSchema subSchema : subSchemaMap.values()) {
                for (MCAPSchema.MCAPSchemaField subField : subSchema.getFields()) {
                    if (!subSchemaMap.containsKey(subField.getType())) continue;
                    subField.setComplexType(true);
                }
            }
        }
        return new MCAPSchema(name, id, fields, subSchemaMap);
    }

    public static MCAPSchema.MCAPSchemaField parseMCAPSchemaField(String line) {
        MCAPSchema.MCAPSchemaField field = new MCAPSchema.MCAPSchemaField();
        field.setType(line.substring(0, line.indexOf(32)).trim());
        field.setName(line.substring(line.indexOf(32) + 1).trim());
        int lBracketIndex = field.getType().indexOf(91);
        int rBracketIndex = field.getType().indexOf(93);
        if (lBracketIndex < rBracketIndex) {
            String maxLengthStr = field.getType().substring(lBracketIndex + 1, rBracketIndex);
            if (maxLengthStr.startsWith("<=")) {
                field.setArray(false);
                field.setVector(true);
                maxLengthStr = maxLengthStr.substring(2);
            } else {
                field.setArray(true);
                field.setVector(false);
            }
            field.setComplexType(true);
            try {
                field.setMaxLength(Integer.parseInt(maxLengthStr));
            }
            catch (NumberFormatException e) {
                maxLengthStr = maxLengthStr.replace("<=", "");
                field.setMaxLength(Integer.parseInt(maxLengthStr));
            }
            field.setType(field.getType().substring(0, lBracketIndex));
        } else {
            field.setArray(false);
            field.setVector(false);
            field.setMaxLength(-1);
        }
        return field;
    }
}

