/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.PaintDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinitionFactory;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.scs2.session.mcap.CDRDeserializer;
import us.ihmc.scs2.session.mcap.MCAP;
import us.ihmc.scs2.session.mcap.MCAPSchema;
import us.ihmc.scs2.session.mcap.OMGIDLSchemaParser;
import us.ihmc.scs2.session.mcap.ROS2SchemaParser;
import us.ihmc.yoVariables.euclid.YoPoint3D;
import us.ihmc.yoVariables.euclid.YoPose3D;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.registry.YoRegistry;

public class MCAPFrameTransformManager {
    private static final String FOXGLOVE_PREFIX = "foxglove::FrameTransform.";
    private static final String WORLD_FRAME_NAME = "world";
    private static final String FRAME_FIELD_TYPE = "string";
    private static final String PARENT_FRAME_FIELD_NAME = "parent_frame_id";
    private static final String CHILD_FRAME_FIELD_NAME = "child_frame_id";
    private static final String ROTATION_FIELD_NAME = "rotation";
    private static final String ROTATION_X_FIELD_NAME = "rotation.x";
    private static final String ROTATION_Y_FIELD_NAME = "rotation.y";
    private static final String ROTATION_Z_FIELD_NAME = "rotation.z";
    private static final String ROTATION_W_FIELD_NAME = "rotation.w";
    private static final String TRANSLATION_FIELD_NAME = "translation";
    private static final String TRANSLATION_X_FIELD_NAME = "translation.x";
    private static final String TRANSLATION_Y_FIELD_NAME = "translation.y";
    private static final String TRANSLATION_Z_FIELD_NAME = "translation.z";
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final ReferenceFrame inertialFrame;
    private MCAPSchema foxgloveFrameTransformSchema;
    private final List<YoFoxGloveFrameTransform> transformList = new ArrayList<YoFoxGloveFrameTransform>();
    private final Map<String, YoFoxGloveFrameTransform> rawNameToTransformMap = new LinkedHashMap<String, YoFoxGloveFrameTransform>();
    private final Map<String, YoFoxGloveFrameTransform> sanitizedNameToTransformMap = new LinkedHashMap<String, YoFoxGloveFrameTransform>();
    private final TIntHashSet channelIds = new TIntHashSet();
    private final Set<String> unattachedRootNames = new LinkedHashSet<String>();
    private final YoGraphicGroupDefinition yoGraphicGroupDefinition = new YoGraphicGroupDefinition("FoxgloveFrameTransforms");
    private MCAP.Schema mcapSchema;
    private final CDRDeserializer cdr = new CDRDeserializer();

    public MCAPFrameTransformManager(ReferenceFrame inertialFrame) {
        this.inertialFrame = inertialFrame;
    }

    public void initialize(MCAP mcap) throws IOException {
        for (MCAP.Record record : mcap.records()) {
            if (record.op() != MCAP.Opcode.SCHEMA) continue;
            this.mcapSchema = (MCAP.Schema)record.body();
            if (!this.mcapSchema.name().equalsIgnoreCase("foxglove::FrameTransform")) continue;
            if (this.mcapSchema.encoding().equalsIgnoreCase("ros2msg")) {
                this.foxgloveFrameTransformSchema = ROS2SchemaParser.loadSchema(this.mcapSchema);
                break;
            }
            if (this.mcapSchema.encoding().equalsIgnoreCase("omgidl")) {
                this.foxgloveFrameTransformSchema = OMGIDLSchemaParser.loadSchema(this.mcapSchema);
                break;
            }
            throw new UnsupportedOperationException("Unsupported encoding: " + this.mcapSchema.encoding());
        }
        if (this.foxgloveFrameTransformSchema == null) {
            throw new RuntimeException("Could not find the schema for foxglove::FrameTransform");
        }
        this.foxgloveFrameTransformSchema = this.foxgloveFrameTransformSchema.flattenSchema();
        for (String string : Arrays.asList(PARENT_FRAME_FIELD_NAME, CHILD_FRAME_FIELD_NAME, ROTATION_FIELD_NAME, ROTATION_X_FIELD_NAME, ROTATION_Y_FIELD_NAME, ROTATION_Z_FIELD_NAME, ROTATION_W_FIELD_NAME, TRANSLATION_FIELD_NAME, TRANSLATION_X_FIELD_NAME, TRANSLATION_Y_FIELD_NAME, TRANSLATION_Z_FIELD_NAME)) {
            if (!this.foxgloveFrameTransformSchema.getFields().stream().noneMatch(field -> field.getName().equalsIgnoreCase(string))) continue;
            throw new RuntimeException("Could not find the field " + string + " in the schema for foxglove::FrameTransform");
        }
        TIntObjectHashMap channelIdToTopicMap = new TIntObjectHashMap();
        for (MCAP.Record record : mcap.records()) {
            if (record.op() != MCAP.Opcode.CHANNEL) continue;
            MCAP.Channel channel = (MCAP.Channel)record.body();
            if (channel.schemaId() == this.foxgloveFrameTransformSchema.getId()) {
                channelIdToTopicMap.put(channel.id(), (Object)channel.topic());
            }
            record.unloadBody();
        }
        this.channelIds.addAll(channelIdToTopicMap.keys());
        LinkedHashMap<String, BasicTransformInfo> linkedHashMap = new LinkedHashMap<String, BasicTransformInfo>();
        for (MCAP.Record record : mcap.records()) {
            MCAP.Message message;
            String topic;
            if (record.op() == MCAP.Opcode.CHUNK) {
                MCAP.Chunk chunk = (MCAP.Chunk)record.body();
                for (MCAP.Record chunkRecord : chunk.records()) {
                    MCAP.Message message2;
                    String topic2;
                    if (chunkRecord.op() != MCAP.Opcode.MESSAGE || (topic2 = (String)channelIdToTopicMap.get((message2 = (MCAP.Message)chunkRecord.body()).channelId())) == null) continue;
                    BasicTransformInfo transformInfo = MCAPFrameTransformManager.extractFromMessage(this.foxgloveFrameTransformSchema, topic2, message2);
                    linkedHashMap.put(transformInfo.childFrameName(), transformInfo);
                }
                chunk.unloadRecords();
                record.unloadBody();
                continue;
            }
            if (record.op() != MCAP.Opcode.MESSAGE || (topic = (String)channelIdToTopicMap.get((message = (MCAP.Message)record.body()).channelId())) == null) continue;
            BasicTransformInfo transformInfo = MCAPFrameTransformManager.extractFromMessage(this.foxgloveFrameTransformSchema, topic, message);
            linkedHashMap.put(transformInfo.childFrameName(), transformInfo);
            record.unloadBody();
        }
        for (BasicTransformInfo transformInfo : linkedHashMap.values()) {
            if (linkedHashMap.containsKey(transformInfo.parentFrameName()) || transformInfo.parentFrameName().equals(WORLD_FRAME_NAME)) continue;
            this.unattachedRootNames.add(transformInfo.parentFrameName());
        }
        if (!linkedHashMap.isEmpty()) {
            LinkedList<BasicTransformInfo> linkedList = MCAPFrameTransformManager.sortTransforms(linkedHashMap);
            while (!linkedList.isEmpty()) {
                BasicTransformInfo basicTransformInfo = linkedList.poll();
                YoFoxGloveFrameTransform transform = new YoFoxGloveFrameTransform(basicTransformInfo, this.rawNameToTransformMap.get(basicTransformInfo.parentFrameName()), this.inertialFrame, this.registry);
                this.yoGraphicGroupDefinition.addChild((YoGraphicDefinition)YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D((String)transform.rawName, (YoFramePose3D)transform.poseToRoot, (double)0.2, (PaintDefinition)ColorDefinitions.SeaGreen()));
                this.rawNameToTransformMap.put(basicTransformInfo.childFrameName(), transform);
            }
            this.transformList.addAll(this.rawNameToTransformMap.values());
            for (YoFoxGloveFrameTransform transform : this.transformList) {
                this.sanitizedNameToTransformMap.put(transform.sanitizedName, transform);
            }
            this.yoGraphicGroupDefinition.setVisible(false);
        }
    }

    private static LinkedList<BasicTransformInfo> sortTransforms(Map<String, BasicTransformInfo> allTransforms) {
        LinkedList<BasicTransformInfo> ordered = new LinkedList<BasicTransformInfo>(allTransforms.values());
        ordered.sort((o1, o2) -> {
            int distanceToRoot1 = 0;
            int distanceToRoot2 = 0;
            while (o1 != null) {
                ++distanceToRoot1;
                o1 = (BasicTransformInfo)allTransforms.get(o1.parentFrameName());
            }
            while (o2 != null) {
                ++distanceToRoot1;
                o2 = (BasicTransformInfo)allTransforms.get(o2.parentFrameName());
            }
            return Integer.compare(distanceToRoot1, distanceToRoot2);
        });
        return ordered;
    }

    public void update() {
        for (YoFoxGloveFrameTransform transform : this.transformList) {
            transform.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readMessage(MCAP.Message message) {
        String childFrameName;
        String parentFrameName;
        double tx;
        double ty;
        double tz;
        double rx;
        double ry;
        double rz;
        double rw;
        if (!this.channelIds.contains(message.channelId())) {
            return false;
        }
        this.cdr.initialize(message.messageBuffer(), message.offsetData(), message.lengthData());
        try {
            List<MCAPSchema.MCAPSchemaField> fields = this.foxgloveFrameTransformSchema.getFields();
            rw = 1.0;
            rz = 0.0;
            ry = 0.0;
            rx = 0.0;
            tz = 0.0;
            ty = 0.0;
            tx = 0.0;
            parentFrameName = null;
            childFrameName = null;
            for (int i = 0; i < fields.size(); ++i) {
                MCAPSchema.MCAPSchemaField field = fields.get(i);
                if (field.isComplexType()) {
                    MCAPSchema.MCAPSchemaField zField;
                    MCAPSchema.MCAPSchemaField yField;
                    MCAPSchema.MCAPSchemaField xField;
                    if (field.getName().equalsIgnoreCase(ROTATION_FIELD_NAME)) {
                        xField = fields.get(i + 1);
                        yField = fields.get(i + 2);
                        zField = fields.get(i + 3);
                        MCAPSchema.MCAPSchemaField wField = fields.get(i + 4);
                        if (!xField.getName().equalsIgnoreCase(ROTATION_X_FIELD_NAME)) {
                            throw new RuntimeException("Unexpected field name: " + xField.getName());
                        }
                        if (!yField.getName().equalsIgnoreCase(ROTATION_Y_FIELD_NAME)) {
                            throw new RuntimeException("Unexpected field name: " + yField.getName());
                        }
                        if (!zField.getName().equalsIgnoreCase(ROTATION_Z_FIELD_NAME)) {
                            throw new RuntimeException("Unexpected field name: " + zField.getName());
                        }
                        if (!wField.getName().equalsIgnoreCase(ROTATION_W_FIELD_NAME)) {
                            throw new RuntimeException("Unexpected field name: " + wField.getName());
                        }
                        rx = this.cdr.readTypeAsDouble(CDRDeserializer.Type.parseType(xField.getType()));
                        ry = this.cdr.readTypeAsDouble(CDRDeserializer.Type.parseType(yField.getType()));
                        rz = this.cdr.readTypeAsDouble(CDRDeserializer.Type.parseType(zField.getType()));
                        rw = this.cdr.readTypeAsDouble(CDRDeserializer.Type.parseType(wField.getType()));
                        i += 4;
                        continue;
                    }
                    if (!field.getName().equalsIgnoreCase(TRANSLATION_FIELD_NAME)) continue;
                    xField = fields.get(i + 1);
                    yField = fields.get(i + 2);
                    zField = fields.get(i + 3);
                    if (!xField.getName().equalsIgnoreCase(TRANSLATION_X_FIELD_NAME)) {
                        throw new RuntimeException("Unexpected field name: " + xField.getName());
                    }
                    if (!yField.getName().equalsIgnoreCase(TRANSLATION_Y_FIELD_NAME)) {
                        throw new RuntimeException("Unexpected field name: " + yField.getName());
                    }
                    if (!zField.getName().equalsIgnoreCase(TRANSLATION_Z_FIELD_NAME)) {
                        throw new RuntimeException("Unexpected field name: " + zField.getName());
                    }
                    tx = this.cdr.readTypeAsDouble(CDRDeserializer.Type.parseType(xField.getType()));
                    ty = this.cdr.readTypeAsDouble(CDRDeserializer.Type.parseType(yField.getType()));
                    tz = this.cdr.readTypeAsDouble(CDRDeserializer.Type.parseType(zField.getType()));
                    i += 3;
                    continue;
                }
                if (field.getType().equalsIgnoreCase(FRAME_FIELD_TYPE)) {
                    if (field.getName().equalsIgnoreCase(PARENT_FRAME_FIELD_NAME)) {
                        parentFrameName = this.cdr.read_string();
                        continue;
                    }
                    if (!field.getName().equalsIgnoreCase(CHILD_FRAME_FIELD_NAME)) continue;
                    childFrameName = this.cdr.read_string();
                    continue;
                }
                this.cdr.skipNext(CDRDeserializer.Type.parseType(field.getType()));
            }
        }
        finally {
            this.cdr.finalize(false);
        }
        YoFoxGloveFrameTransform transform = this.rawNameToTransformMap.get(childFrameName);
        if (transform != null) {
            if (!Objects.equals(parentFrameName, transform.parentFrameName)) {
                LogTools.error((String)("Unexpected parent frame name: " + parentFrameName + " for child frame: " + childFrameName + " expected: " + transform.parentFrameName));
            }
            transform.poseToParent.getOrientation().set(rx, ry, rz, rw);
            transform.poseToParent.getPosition().set(tx, ty, tz);
            transform.markPoseToRootAsDirty();
        } else {
            LogTools.error((String)("Could not find transform for child frame: " + childFrameName));
        }
        return true;
    }

    public YoGraphicDefinition getYoGraphic() {
        return this.yoGraphicGroupDefinition;
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public MCAP.Schema getMCAPSchema() {
        return this.mcapSchema;
    }

    public MCAPSchema getFrameTransformSchema() {
        return this.foxgloveFrameTransformSchema;
    }

    public YoFoxGloveFrameTransform getTransformFromSanitizedName(String name) {
        return this.sanitizedNameToTransformMap.get(name);
    }

    private static BasicTransformInfo extractFromMessage(MCAPSchema flatSchema, String topic, MCAP.Message message) {
        if (!flatSchema.isSchemaFlat()) {
            throw new IllegalArgumentException("The schema is not flat.");
        }
        CDRDeserializer cdr = new CDRDeserializer();
        cdr.initialize(message.messageBuffer(), message.offsetData(), message.lengthData());
        String parentFrameName = null;
        String childFrameName = null;
        for (MCAPSchema.MCAPSchemaField field : flatSchema.getFields()) {
            if (field.isComplexType()) continue;
            if (field.getType().equalsIgnoreCase(FRAME_FIELD_TYPE)) {
                if (field.getName().equalsIgnoreCase(PARENT_FRAME_FIELD_NAME)) {
                    parentFrameName = cdr.read_string();
                    continue;
                }
                if (!field.getName().equalsIgnoreCase(CHILD_FRAME_FIELD_NAME)) continue;
                childFrameName = cdr.read_string();
                continue;
            }
            cdr.skipNext(CDRDeserializer.Type.parseType(field.getType()));
        }
        cdr.finalize(true);
        if (parentFrameName == null) {
            throw new RuntimeException("Could not find the parent frame name for topic: " + topic);
        }
        return new BasicTransformInfo(topic, Objects.requireNonNull(parentFrameName, "Parent frame name is null for topic: " + topic + " and child: " + childFrameName), Objects.requireNonNull(childFrameName, "Child frame name is null for topic: " + topic + " and parent: " + parentFrameName));
    }

    private record BasicTransformInfo(String topic, String parentFrameName, String childFrameName) {
    }

    public static class YoFoxGloveFrameTransform {
        private final String parentFrameName;
        private final String rawName;
        private final String sanitizedName;
        private YoFoxGloveFrameTransform parent;
        private final List<YoFoxGloveFrameTransform> children;
        private final YoPose3D poseToParent;
        private final YoFramePose3D poseToRoot;
        private boolean isPoseToRootDirty = true;

        private YoFoxGloveFrameTransform(BasicTransformInfo info, YoFoxGloveFrameTransform parent, ReferenceFrame inertialFrame, YoRegistry registry) {
            this.parentFrameName = info.parentFrameName();
            this.rawName = info.childFrameName();
            this.sanitizedName = YoFoxGloveFrameTransform.sanitizeName(this.rawName);
            this.children = new ArrayList<YoFoxGloveFrameTransform>();
            String namePrefix = this.sanitizedName;
            String worldNamePrefix = YoFoxGloveFrameTransform.sanitizeName(namePrefix + "_world");
            this.poseToParent = new YoPose3D(namePrefix, registry);
            if (parent == null) {
                YoPoint3D yoPosition = this.poseToParent.getPosition();
                YoQuaternion yoOrientation = this.poseToParent.getOrientation();
                this.poseToRoot = new YoFramePose3D(new YoFramePoint3D(yoPosition.getYoX(), yoPosition.getYoY(), yoPosition.getYoZ(), inertialFrame), new YoFrameQuaternion(yoOrientation.getYoQx(), yoOrientation.getYoQy(), yoOrientation.getYoQz(), yoOrientation.getYoQs(), inertialFrame));
            } else {
                this.poseToRoot = new YoFramePose3D(worldNamePrefix, inertialFrame, registry);
            }
            this.setParent(parent);
        }

        private static String sanitizeName(String name) {
            return (name = name.replace('.', '_').replaceAll("_+", "_")).startsWith("_") ? name.substring(1) : name;
        }

        public void setParent(YoFoxGloveFrameTransform parent) {
            if (this.parent != null) {
                throw new IllegalStateException("Parent already set.");
            }
            this.parent = parent;
            if (parent != null) {
                if (!parent.rawName.equals(this.parentFrameName)) {
                    throw new IllegalArgumentException("Unexpected parent frame name: " + parent.rawName + " expected: " + this.parentFrameName);
                }
                parent.addChild(this);
            }
        }

        public void addChild(YoFoxGloveFrameTransform child) {
            this.children.add(child);
        }

        public void markPoseToRootAsDirty() {
            this.isPoseToRootDirty = true;
            for (YoFoxGloveFrameTransform child : this.children) {
                child.markPoseToRootAsDirty();
            }
        }

        public void update() {
            if (this.parent != null && this.isPoseToRootDirty) {
                if (this.parent.isPoseToRootDirty) {
                    this.parent.update();
                }
                this.poseToRoot.set((FramePose3DReadOnly)this.parent.poseToRoot);
                this.poseToRoot.multiply((RigidBodyTransformReadOnly)this.poseToParent);
            }
            this.isPoseToRootDirty = false;
        }

        public String getRawName() {
            return this.rawName;
        }

        public String getSanitizedName() {
            return this.sanitizedName;
        }

        public YoFoxGloveFrameTransform getParent() {
            return this.parent;
        }

        public RigidBodyTransformReadOnly getTransformToParent() {
            return this.poseToParent;
        }

        public RigidBodyTransformReadOnly getTransformToRoot() {
            return this.poseToRoot;
        }
    }
}

