/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import com.github.luben.zstd.ZstdDecompressCtx;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.scs2.session.mcap.LZ4FrameDecoder;

public class MCAP {
    protected FileChannel fileChannel;
    private Magic headerMagic;
    private ArrayList<Record> records;
    private Magic footerMagic;
    private Record footer;

    public MCAP(FileChannel fileChannel) throws IOException {
        this.fileChannel = fileChannel;
        this._read();
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    private void _read() throws IOException {
        long currentPos = 0L;
        this.headerMagic = new Magic(this.fileChannel, currentPos);
        currentPos += (long)this.headerMagic.getItemTotalLength();
        this.records = new ArrayList();
        Record lastRecord = null;
        do {
            lastRecord = new Record(this.fileChannel, currentPos);
            currentPos += (long)lastRecord.getItemTotalLength();
            this.records.add(lastRecord);
        } while (lastRecord.op() != Opcode.FOOTER);
        this.footerMagic = new Magic(this.fileChannel, currentPos);
    }

    public Magic headerMagic() {
        return this.headerMagic;
    }

    public ArrayList<Record> records() {
        return this.records;
    }

    public Magic footerMagic() {
        return this.footerMagic;
    }

    public Record footer() throws IOException {
        if (this.footer == null) {
            this.footer = new Record(this.fileChannel, (long)MCAP.computeOffsetFooter(this.fileChannel));
        }
        return this.footer;
    }

    public static int computeOffsetFooter(FileChannel fileChannel) throws IOException {
        return (int)(fileChannel.size() - 1L - 8L - 20L - 8L);
    }

    public static String parseString(ByteBuffer buffer) {
        return MCAP.parseString(buffer, Integer.toUnsignedLong(buffer.getInt()));
    }

    public static String parseString(ByteBuffer buffer, long length) {
        byte[] bytes = new byte[(int)length];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static <T extends Sizeable> List<T> parseList(ByteBuffer buffer, ByteBufferReader<T> elementParser) throws IOException {
        return MCAP.parseList(buffer, elementParser, Integer.toUnsignedLong(buffer.getInt()));
    }

    public static <T extends Sizeable> List<T> parseList(ByteBuffer buffer, ByteBufferReader<T> elementParser, long length) throws IOException {
        return MCAP.parseList(buffer, elementParser, (long)buffer.position(), length);
    }

    public static <T extends Sizeable> List<T> parseList(ByteBuffer buffer, ByteBufferReader<T> elementParser, long offset, long length) throws IOException {
        return MCAP.parseList(buffer, elementParser, offset, length, null);
    }

    public static <T extends Sizeable> List<T> parseList(ByteBuffer buffer, ByteBufferReader<T> elementParser, long offset, long length, List<T> listToPack) throws IOException {
        buffer.position((int)offset);
        int position = buffer.position();
        long limit = (long)position + length;
        if (listToPack == null) {
            listToPack = new ArrayList<T>();
        }
        while ((long)position < limit) {
            buffer.position(position);
            T parsed = elementParser.parse(buffer);
            listToPack.add(parsed);
            position += parsed.getItemTotalLength();
        }
        return listToPack;
    }

    public static <T extends Sizeable> List<T> parseList(FileChannel fileChannel, FileChannelReader<T> elementParser, long offset, long length) throws IOException {
        return MCAP.parseList(fileChannel, elementParser, offset, length, null);
    }

    public static <T extends Sizeable> List<T> parseList(FileChannel fileChannel, FileChannelReader<T> elementParser, long offset, long length, List<T> listToPack) throws IOException {
        long position = offset;
        long limit = position + length;
        if (listToPack == null) {
            listToPack = new ArrayList<T>();
        }
        while (position < limit) {
            T parsed = elementParser.parse(fileChannel, position);
            listToPack.add(parsed);
            position += (long)parsed.getItemTotalLength();
        }
        return listToPack;
    }

    private static String indent(String stringToIndent, int indent) {
        if (indent <= 0) {
            return stringToIndent;
        }
        String indentStr = "\t".repeat(indent);
        return indentStr + stringToIndent.replace("\n", "\n" + indentStr);
    }

    public static class Magic
    extends KaitaiStruct {
        public static final int MAGIC_SIZE = 8;
        public static final byte[] MAGIC_BYTES = new byte[]{-119, 77, 67, 65, 80, 48, 13, 10};
        private byte[] magic;

        public Magic(FileChannel fileChannel, long _pos) throws IOException {
            super(fileChannel, _pos, 8);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.magic = new byte[8];
            this.buffer.get(this.magic);
            if (!Arrays.equals(this.magic, MAGIC_BYTES)) {
                throw new ValidationNotEqualError(MAGIC_BYTES, this.magic, this.buffer);
            }
        }

        public byte[] magic() {
            return this.magic;
        }

        @Override
        public String toString() {
            return this.toString(0);
        }

        @Override
        public String toString(int indent) {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-magic = " + Arrays.toString(this.magic);
            return MCAP.indent(out, indent);
        }
    }

    public static class Record
    extends KaitaiStruct {
        public static final int RECORD_HEADER_LENGTH = 9;
        private Opcode op;
        private long lengthBody;
        private long bodyPos;
        private Object body;

        public Record(ByteBuffer buffer) throws IOException {
            this(buffer, (long)buffer.position());
        }

        public Record(ByteBuffer buffer, long _pos) throws IOException {
            super(buffer, _pos, -1);
            this._read();
        }

        public Record(FileChannel fileChannel, long _pos) throws IOException {
            super(fileChannel, _pos, -1);
            this.createBuffer(9);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.op = Opcode.byId(Byte.toUnsignedInt(this.buffer.get()));
            this.lengthBody = this.buffer.getLong();
            this.bodyPos = this.fileChannel != null ? this._pos + 9L : (long)this.buffer.position();
            this.setComputedLength(9 + (int)this.lengthBody);
        }

        public void readBody() throws IOException {
            if (this.body != null) {
                return;
            }
            if (this.op == null) {
                if (this.fileChannel != null) {
                    ByteBuffer bb = ByteBuffer.allocate((int)this.lengthBody);
                    this.fileChannel.read(bb, this.bodyPos);
                    this.body = bb.array();
                } else {
                    this.body = new byte[(int)this.lengthBody];
                    this.buffer.get((int)this.bodyPos, (byte[])this.body);
                }
                return;
            }
            if (this.fileChannel != null) {
                this.body = switch (this.op) {
                    default -> throw new IncompatibleClassChangeError();
                    case Opcode.MESSAGE -> new Message(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.METADATA_INDEX -> new MetadataIndex(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.CHUNK -> new Chunk(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.SCHEMA -> new Schema(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.CHUNK_INDEX -> new ChunkIndex(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.DATA_END -> new DataEnd(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.ATTACHMENT_INDEX -> new AttachmentIndex(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.STATISTICS -> new Statistics(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.MESSAGE_INDEX -> new MessageIndex(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.CHANNEL -> new Channel(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.METADATA -> new Metadata(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.ATTACHMENT -> new Attachment(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.HEADER -> new Header(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.FOOTER -> new Footer(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                    case Opcode.SUMMARY_OFFSET -> new SummaryOffset(this.fileChannel, this.bodyPos, (int)this.lengthBody);
                };
            } else {
                this.body = switch (this.op) {
                    default -> throw new IncompatibleClassChangeError();
                    case Opcode.MESSAGE -> new Message(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.METADATA_INDEX -> new MetadataIndex(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.CHUNK -> new Chunk(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.SCHEMA -> new Schema(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.CHUNK_INDEX -> new ChunkIndex(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.DATA_END -> new DataEnd(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.ATTACHMENT_INDEX -> new AttachmentIndex(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.STATISTICS -> new Statistics(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.MESSAGE_INDEX -> new MessageIndex(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.CHANNEL -> new Channel(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.METADATA -> new Metadata(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.ATTACHMENT -> new Attachment(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.HEADER -> new Header(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.FOOTER -> new Footer(this.buffer, this.bodyPos, (int)this.lengthBody);
                    case Opcode.SUMMARY_OFFSET -> new SummaryOffset(this.buffer, this.bodyPos, (int)this.lengthBody);
                };
            }
            this.setComputedLength(9 + ((KaitaiStruct)this.body).getItemTotalLength());
        }

        public Opcode op() {
            return this.op;
        }

        public long lengthBody() {
            return this.lengthBody;
        }

        public Object body() {
            try {
                this.readBody();
                return this.body;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void unloadBody() {
            this.body = null;
        }

        @Override
        public String toString() {
            return this.toString(0);
        }

        @Override
        public String toString(int indent) {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-op = " + this.op;
            out = out + "\n\t-lengthBody = " + this.lengthBody;
            out = out + "\n\t-body = " + (String)(this.body == null ? "null" : "\n" + ((KaitaiStruct)this.body).toString(indent + 2));
            return MCAP.indent(out, indent);
        }
    }

    public static enum Opcode {
        HEADER(1L),
        FOOTER(2L),
        SCHEMA(3L),
        CHANNEL(4L),
        MESSAGE(5L),
        CHUNK(6L),
        MESSAGE_INDEX(7L),
        CHUNK_INDEX(8L),
        ATTACHMENT(9L),
        ATTACHMENT_INDEX(10L),
        STATISTICS(11L),
        METADATA(12L),
        METADATA_INDEX(13L),
        SUMMARY_OFFSET(14L),
        DATA_END(15L);

        private final long id;
        private static final TLongObjectHashMap<Opcode> byId;

        private Opcode(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static Opcode byId(long id) {
            return (Opcode)((Object)byId.get(id));
        }

        static {
            byId = new TLongObjectHashMap(15);
            for (Opcode e : Opcode.values()) {
                byId.put(e.id(), (Object)e);
            }
        }
    }

    public static interface ByteBufferReader<T extends Sizeable> {
        public T parse(ByteBuffer var1) throws IOException;
    }

    public static interface Sizeable {
        public int getItemTotalLength();
    }

    public static interface FileChannelReader<T extends Sizeable> {
        public T parse(FileChannel var1, long var2) throws IOException;
    }

    public static class ValidationNotEqualError
    extends ValidationFailedError {
        private static final long serialVersionUID = -6127683772774212751L;

        public ValidationNotEqualError(byte[] expected, byte[] actual, ByteBuffer io) {
            super("not equal, expected " + ValidationNotEqualError.byteArrayToHex(expected) + ", but got " + ValidationNotEqualError.byteArrayToHex(actual), io);
        }

        public ValidationNotEqualError(Object expected, Object actual, ByteBuffer io) {
            super("not equal, expected " + expected + ", but got " + actual, io);
        }
    }

    public static class ValidationFailedError
    extends KaitaiStructError {
        private static final long serialVersionUID = 4069741066320518907L;

        public ValidationFailedError(String msg, ByteBuffer buffer) {
            super("at pos " + buffer.position() + ": validation failed: " + msg);
        }

        protected static String byteArrayToHex(byte[] arr) {
            StringBuilder sb = new StringBuilder("[");
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(String.format("%02x", arr[i]));
            }
            sb.append(']');
            return sb.toString();
        }
    }

    public static class KaitaiStructError
    extends RuntimeException {
        private static final long serialVersionUID = 3448466497836212719L;

        public KaitaiStructError(String msg) {
            super(msg);
        }
    }

    private static abstract class KaitaiStruct
    implements Sizeable {
        protected final FileChannel fileChannel;
        protected long _pos;
        protected int _length;
        protected ByteBuffer buffer;

        public KaitaiStruct(ByteBuffer buffer) {
            this(buffer, -1);
        }

        public KaitaiStruct(ByteBuffer buffer, int _length) {
            this(buffer, (long)buffer.position(), _length);
        }

        public KaitaiStruct(ByteBuffer buffer, long _pos, int _length) {
            this.buffer = buffer;
            this.fileChannel = null;
            this._pos = _pos;
            this._length = _length;
            if (buffer != null) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
            }
        }

        public KaitaiStruct(FileChannel fileChannel, long _pos, int _length) {
            this.fileChannel = fileChannel;
            this._pos = _pos;
            this._length = _length;
            this.createBuffer(_length);
        }

        protected void createBuffer(int _length) {
            if (_length == -1) {
                this.buffer = null;
            } else {
                this.buffer = ByteBuffer.allocate(_length);
                this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            }
        }

        protected void _readIntoBuffer() throws IOException {
            if (this.fileChannel == null) {
                this.buffer.position((int)this._pos);
            } else {
                this.fileChannel.position(this._pos);
                this.fileChannel.read(this.buffer);
                this.buffer.flip();
            }
        }

        public abstract void _read() throws IOException;

        protected void setComputedLength(int computedLength) {
            if (this._length == -1) {
                this._length = computedLength;
            } else if (this._length != computedLength) {
                throw new ValidationNotEqualError(computedLength, this._length, this.buffer);
            }
        }

        @Override
        public int getItemTotalLength() {
            if (this._length == -1) {
                throw new RuntimeException("Cannot get total length of an item with unknown length.");
            }
            return this._length;
        }

        public long getPosition() {
            if (this._pos == -1L) {
                throw new RuntimeException("Cannot get position of an item with unknown position.");
            }
            return this._pos;
        }

        public abstract String toString();

        public String toString(int indent) {
            return MCAP.indent(this.toString(), indent);
        }
    }

    public static class ChunkIndex
    extends KaitaiStruct {
        private long messageStartTime;
        private long messageEndTime;
        private long ofsChunk;
        private long lenChunk;
        private long lenMessageIndexOffsets;
        private MessageIndexOffsets messageIndexOffsets;
        private long messageIndexLength;
        private String compression;
        private long compressedSize;
        private long uncompressedSize;
        private Record chunk;

        public ChunkIndex(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public ChunkIndex(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.messageStartTime = this.buffer.getLong();
            this.messageEndTime = this.buffer.getLong();
            this.ofsChunk = this.buffer.getLong();
            this.lenChunk = this.buffer.getLong();
            this.lenMessageIndexOffsets = Integer.toUnsignedLong(this.buffer.getInt());
            this.messageIndexOffsets = new MessageIndexOffsets(this.buffer, (int)this.lenMessageIndexOffsets);
            this.messageIndexLength = this.buffer.getLong();
            this.compression = MCAP.parseString(this.buffer);
            this.compressedSize = this.buffer.getLong();
            this.uncompressedSize = this.buffer.getLong();
            this.setComputedLength(64 + this.messageIndexOffsets.getItemTotalLength() + this.compression.length());
        }

        public Record chunk() throws IOException {
            if (this.chunk == null) {
                this.chunk = new Record(this.fileChannel, this.ofsChunk);
            }
            return this.chunk;
        }

        public void unloadChunk() {
            if (this.chunk != null) {
                this.chunk.unloadBody();
            }
            this.chunk = null;
        }

        public long messageStartTime() {
            return this.messageStartTime;
        }

        public long messageEndTime() {
            return this.messageEndTime;
        }

        public long ofsChunk() {
            return this.ofsChunk;
        }

        public long lenChunk() {
            return this.lenChunk;
        }

        public long lenMessageIndexOffsets() {
            return this.lenMessageIndexOffsets;
        }

        public MessageIndexOffsets messageIndexOffsets() {
            return this.messageIndexOffsets;
        }

        public long messageIndexLength() {
            return this.messageIndexLength;
        }

        public String compression() {
            return this.compression;
        }

        public long compressedSize() {
            return this.compressedSize;
        }

        public long uncompressedSize() {
            return this.uncompressedSize;
        }

        @Override
        public String toString() {
            return this.toString(0);
        }

        @Override
        public String toString(int indent) {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-messageStartTime = " + this.messageStartTime;
            out = out + "\n\t-messageEndTime = " + this.messageEndTime;
            out = out + "\n\t-ofsChunk = " + this.ofsChunk;
            out = out + "\n\t-lenChunk = " + this.lenChunk;
            out = out + "\n\t-lenMessageIndexOffsets = " + this.lenMessageIndexOffsets;
            out = out + "\n\t-messageIndexOffsets = " + (String)(this.messageIndexOffsets == null ? "null" : "\n" + this.messageIndexOffsets.toString(indent + 1));
            out = out + "\n\t-messageIndexLength = " + this.messageIndexLength;
            out = out + "\n\t-compression = " + this.compression;
            out = out + "\n\t-compressedSize = " + this.compressedSize;
            out = out + "\n\t-uncompressedSize = " + this.uncompressedSize;
            return MCAP.indent(out, indent);
        }

        public static class MessageIndexOffsets
        extends KaitaiStruct {
            private List<MessageIndexOffset> entries;

            public MessageIndexOffsets(ByteBuffer buffer, int _length) throws IOException {
                super(buffer, _length);
                this._read();
            }

            @Override
            public void _read() throws IOException {
                MessageIndexOffset entry;
                this._readIntoBuffer();
                this.entries = new ArrayList<MessageIndexOffset>();
                for (int remaining = this._length; remaining > 0; remaining -= entry.getItemTotalLength()) {
                    entry = new MessageIndexOffset(this.buffer);
                    this.entries.add(entry);
                }
            }

            public List<MessageIndexOffset> entries() {
                return this.entries;
            }

            @Override
            public String toString() {
                return this.toString(0);
            }

            @Override
            public String toString(int indent) {
                String out = this.getClass().getSimpleName() + ":";
                out = out + "\n\t-entries = " + (String)(this.entries == null ? "null" : "\n" + EuclidCoreIOTools.getCollectionString((String)"\n", this.entries, e -> e.toString(indent + 1)));
                return MCAP.indent(out, indent);
            }
        }

        public static class MessageIndexOffset
        extends KaitaiStruct {
            private int channelId;
            private long offset;

            public MessageIndexOffset(ByteBuffer buffer) throws IOException {
                super(buffer);
                this._read();
            }

            @Override
            public void _read() throws IOException {
                this._readIntoBuffer();
                this.channelId = Short.toUnsignedInt(this.buffer.getShort());
                this.offset = this.buffer.getLong();
                this.setComputedLength(10);
            }

            public int channelId() {
                return this.channelId;
            }

            public long offset() {
                return this.offset;
            }

            @Override
            public String toString() {
                return this.toString(0);
            }

            @Override
            public String toString(int indent) {
                String out = this.getClass().getSimpleName() + ":";
                out = out + "\n\t-channelId = " + this.channelId;
                out = out + "\n\t-offset = " + this.offset;
                return MCAP.indent(out, indent);
            }
        }
    }

    public static class Footer
    extends KaitaiStruct {
        private long ofsSummarySection;
        private long ofsSummaryOffsetSection;
        private long summaryCrc32;
        private Integer ofsSummaryCrc32Input;
        private Records summaryOffsetSection;
        private Records summarySection;
        private byte[] summaryCrc32Input;

        public Footer(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public Footer(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.ofsSummarySection = this.buffer.getLong();
            this.ofsSummaryOffsetSection = this.buffer.getLong();
            this.summaryCrc32 = Integer.toUnsignedLong(this.buffer.getInt());
            this.setComputedLength(20);
        }

        public Records summarySection() throws IOException {
            if (this.summarySection == null && this.ofsSummarySection != 0L) {
                long length = (this.ofsSummaryOffsetSection != 0L ? this.ofsSummaryOffsetSection : (long)MCAP.computeOffsetFooter(this.fileChannel)) - this.ofsSummarySection;
                this.summarySection = new Records(this.fileChannel, this.ofsSummarySection, (int)length);
            }
            return this.summarySection;
        }

        public Records summaryOffsetSection() throws IOException {
            if (this.summaryOffsetSection == null && this.ofsSummaryOffsetSection != 0L) {
                this.summaryOffsetSection = new Records(this.fileChannel, this.ofsSummaryOffsetSection, (int)((long)MCAP.computeOffsetFooter(this.fileChannel) - this.ofsSummaryOffsetSection));
            }
            return this.summaryOffsetSection;
        }

        public Integer ofsSummaryCrc32Input() throws IOException {
            if (this.ofsSummaryCrc32Input == null) {
                this.ofsSummaryCrc32Input = (int)(this.ofsSummarySection() != 0L ? this.ofsSummarySection() : (long)MCAP.computeOffsetFooter(this.fileChannel));
            }
            return this.ofsSummaryCrc32Input;
        }

        public byte[] summaryCrc32Input() throws IOException {
            if (this.summaryCrc32Input == null) {
                ByteBuffer tmpBuffer = ByteBuffer.allocate((int)(this.fileChannel.size() - (long)this.ofsSummaryCrc32Input().intValue() - 8L - 4L));
                this.fileChannel.position(this.ofsSummaryCrc32Input().intValue());
                this.fileChannel.read(tmpBuffer);
                this.summaryCrc32Input = tmpBuffer.array();
            }
            return this.summaryCrc32Input;
        }

        public long ofsSummarySection() {
            return this.ofsSummarySection;
        }

        public long ofsSummaryOffsetSection() {
            return this.ofsSummaryOffsetSection;
        }

        public long summaryCrc32() {
            return this.summaryCrc32;
        }

        @Override
        public String toString() {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-ofsSummarySection = " + this.ofsSummarySection;
            out = out + "\n\t-ofsSummaryOffsetSection = " + this.ofsSummaryOffsetSection;
            out = out + "\n\t-summaryCrc32 = " + this.summaryCrc32;
            return out;
        }
    }

    public static class Records
    extends ArrayList<Record> {
        public Records(ByteBuffer buffer) throws IOException {
            this(buffer, buffer.remaining());
        }

        public Records(ByteBuffer buffer, int _length) throws IOException {
            this(buffer, (long)buffer.position(), _length);
        }

        public Records(ByteBuffer buffer, long _pos, int _length) throws IOException {
            MCAP.parseList(buffer, Record::new, _pos, (long)_length, this);
        }

        public Records(FileChannel fileChannel, long _pos, int _length) throws IOException {
            MCAP.parseList(fileChannel, Record::new, _pos, (long)_length, this);
        }

        @Override
        public String toString() {
            return this.toString(0);
        }

        public String toString(int indent) {
            if (this.isEmpty()) {
                return MCAP.indent(this.getClass().getSimpleName() + ": []", indent);
            }
            String out = this.getClass().getSimpleName() + "[\n";
            out = out + EuclidCoreIOTools.getCollectionString((String)"\n", (Collection)this, r -> r.toString(indent + 1));
            return MCAP.indent(out, indent);
        }
    }

    public static class MetadataIndex
    extends KaitaiStruct {
        private long offsetMetadata;
        private long lengthMetadata;
        private String name;
        private Record metadata;

        public MetadataIndex(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public MetadataIndex(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.offsetMetadata = this.buffer.getLong();
            this.lengthMetadata = this.buffer.getLong();
            this.name = MCAP.parseString(this.buffer);
            this.setComputedLength(20 + this.name.length());
        }

        public Record metadata() throws IOException {
            if (this.metadata == null) {
                this.metadata = new Record(this.fileChannel, this.offsetMetadata);
            }
            return this.metadata;
        }

        public long offsetMetadata() {
            return this.offsetMetadata;
        }

        public long lengthMetadata() {
            return this.lengthMetadata;
        }

        public String name() {
            return this.name;
        }

        @Override
        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-offsetMetadata = " + this.offsetMetadata;
            out = out + "\n\t-lengthMetadata = " + this.lengthMetadata;
            out = out + "\n\t-name = " + this.name;
            return out;
        }
    }

    public static class TupleStrStr
    implements Sizeable {
        private String key;
        private String value;

        public TupleStrStr(ByteBuffer buffer) {
            this.key = MCAP.parseString(buffer);
            this.value = MCAP.parseString(buffer);
        }

        @Override
        public int getItemTotalLength() {
            return this.key.length() + this.value.length() + 8;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return (this.key + ": " + this.value).replace("\n", "");
        }
    }

    public static class Message
    extends KaitaiStruct {
        private int channelId;
        private long sequence;
        private long logTime;
        private long publishTime;
        private int offsetData;
        private int lengthData;
        private byte[] data;

        public static Message createSpoofMessageForTesting(int channelId, byte[] data) {
            Message message = new Message();
            message.channelId = channelId;
            message.data = data;
            return message;
        }

        private Message() {
            super((FileChannel)null, -1L, -1);
        }

        public Message(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public Message(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.channelId = Short.toUnsignedInt(this.buffer.getShort());
            this.sequence = Integer.toUnsignedLong(this.buffer.getInt());
            this.logTime = this.buffer.getLong();
            this.publishTime = this.buffer.getLong();
            this.offsetData = this.buffer.position();
            this.lengthData = this._length - 22;
        }

        public int channelId() {
            return this.channelId;
        }

        public long sequence() {
            return this.sequence;
        }

        public long logTime() {
            return this.logTime;
        }

        public long publishTime() {
            return this.publishTime;
        }

        public int offsetData() {
            return this.offsetData;
        }

        public int lengthData() {
            return this.lengthData;
        }

        public ByteBuffer messageBuffer() {
            return this.buffer;
        }

        public byte[] data() {
            if (this.data == null) {
                this.data = new byte[this.lengthData];
                int previousLimit = this.buffer.limit();
                int previousPosition = this.buffer.position();
                this.buffer.limit(this.offsetData + this.lengthData);
                this.buffer.position(this.offsetData);
                this.buffer.get(this.data);
                this.buffer.limit(previousLimit);
                this.buffer.position(previousPosition);
            }
            return this.data;
        }

        @Override
        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-channelId = " + this.channelId;
            out = out + "\n\t-sequence = " + this.sequence;
            out = out + "\n\t-logTime = " + this.logTime;
            out = out + "\n\t-publishTime = " + this.publishTime;
            return out;
        }
    }

    public static class Header
    extends KaitaiStruct {
        private String profile;
        private String library;

        public Header(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public Header(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.profile = MCAP.parseString(this.buffer);
            this.library = MCAP.parseString(this.buffer);
            this.setComputedLength(8 + this.profile.length() + this.library.length());
        }

        public String profile() {
            return this.profile;
        }

        public String library() {
            return this.library;
        }

        @Override
        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-profile = " + this.profile;
            out = out + "\n\t-library = " + this.library;
            return out;
        }
    }

    public static class Metadata
    extends KaitaiStruct {
        private String name;
        private List<TupleStrStr> metadata;

        public Metadata(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public Metadata(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.name = MCAP.parseString(this.buffer);
            int start = this.buffer.position();
            this.metadata = MCAP.parseList(this.buffer, TupleStrStr::new);
            int metadataLength = this.buffer.position() - start;
            this.setComputedLength(4 + this.name.length() + metadataLength);
        }

        public String name() {
            return this.name;
        }

        public List<TupleStrStr> metadata() {
            return this.metadata;
        }

        @Override
        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-name = " + this.name;
            out = out + "\n\t-metadata = " + EuclidCoreIOTools.getCollectionString((String)", ", this.metadata, e -> e.key());
            return out;
        }
    }

    public static class Attachment
    extends KaitaiStruct {
        private long logTime;
        private long createTime;
        private String name;
        private String mediaType;
        private long lengthData;
        private long offsetData;
        private byte[] data;
        private long crc32;
        private int crc32InputEnd;
        private byte[] crc32Input;

        public Attachment(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public Attachment(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.logTime = this.buffer.getLong();
            this.createTime = this.buffer.getLong();
            this.name = MCAP.parseString(this.buffer);
            this.mediaType = MCAP.parseString(this.buffer);
            this.lengthData = this.buffer.getLong();
            this.offsetData = this.buffer.position();
            this.buffer.position((int)(this.offsetData + this.lengthData));
            this.crc32InputEnd = this.buffer.position();
            this.crc32 = Integer.toUnsignedLong(this.buffer.getInt());
            this.setComputedLength(36 + this.name.length() + this.mediaType.length() + (int)this.lengthData);
        }

        public int crc32InputEnd() {
            return this.crc32InputEnd;
        }

        public byte[] crc32Input() {
            if (this.crc32Input == null) {
                int _pos = this.buffer.position();
                this.buffer.position(0);
                this.crc32Input = new byte[this.crc32InputEnd()];
                this.buffer.get(this.crc32Input);
                this.buffer.position(_pos);
            }
            return this.crc32Input;
        }

        public long logTime() {
            return this.logTime;
        }

        public long createTime() {
            return this.createTime;
        }

        public String name() {
            return this.name;
        }

        public String mediaType() {
            return this.mediaType;
        }

        public long lenData() {
            return this.lengthData;
        }

        public byte[] data() {
            if (this.data == null) {
                this.data = new byte[(int)this.lengthData];
                this.buffer.position((int)this.offsetData);
                this.buffer.get(this.data);
            }
            return this.data;
        }

        public void unloadData() {
            this.data = null;
        }

        public long crc32() {
            return this.crc32;
        }

        @Override
        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-logTime = " + this.logTime;
            out = out + "\n\t-createTime = " + this.createTime;
            out = out + "\n\t-name = " + this.name;
            out = out + "\n\t-mediaType = " + this.mediaType;
            out = out + "\n\t-lengthData = " + this.lengthData;
            out = out + "\n\t-crc32 = " + this.crc32;
            return out;
        }
    }

    public static class SummaryOffset
    extends KaitaiStruct {
        private Opcode groupOpcode;
        private long offsetGroup;
        private long lengthGroup;
        private Records group;

        public SummaryOffset(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public SummaryOffset(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.groupOpcode = Opcode.byId(Byte.toUnsignedInt(this.buffer.get()));
            this.offsetGroup = this.buffer.getLong();
            this.lengthGroup = this.buffer.getLong();
            this.setComputedLength(17);
        }

        public Records group() throws IOException {
            if (this.group == null) {
                this.group = new Records(this.fileChannel, this.offsetGroup, (int)this.lengthGroup);
            }
            return this.group;
        }

        public Opcode groupOpcode() {
            return this.groupOpcode;
        }

        public long offsetGroup() {
            return this.offsetGroup;
        }

        public long lengthGroup() {
            return this.lengthGroup;
        }

        @Override
        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-groupOpcode = " + this.groupOpcode;
            out = out + "\n\t-offsetGroup = " + this.offsetGroup;
            out = out + "\n\t-lengthGroup = " + this.lengthGroup;
            return out;
        }
    }

    public static class Schema
    extends KaitaiStruct {
        private int id;
        private String name;
        private String encoding;
        private long lengthData;
        private long offsetData;
        private byte[] data;

        public Schema(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public Schema(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.id = Short.toUnsignedInt(this.buffer.getShort());
            this.name = MCAP.parseString(this.buffer);
            this.encoding = MCAP.parseString(this.buffer);
            this.lengthData = Integer.toUnsignedLong(this.buffer.getInt());
            this.offsetData = this.buffer.position();
            this.buffer.position((int)(this.offsetData + this.lengthData));
            this.setComputedLength(14 + this.name.length() + this.encoding.length() + (int)this.lengthData);
        }

        public int id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public String encoding() {
            return this.encoding;
        }

        public byte[] data() {
            if (this.data == null) {
                this.data = new byte[(int)this.lengthData];
                this.buffer.position((int)this.offsetData);
                this.buffer.get(this.data);
            }
            return this.data;
        }

        public void unloadData() {
            this.data = null;
        }

        @Override
        public String toString() {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-id = " + this.id;
            out = out + "\n\t-name = " + this.name;
            out = out + "\n\t-encoding = " + this.encoding;
            out = out + "\n\t-lengthData = " + this.lengthData;
            out = out + "\n\t-data = " + Arrays.toString(this.data());
            this.unloadData();
            return out;
        }
    }

    public static class AttachmentIndex
    extends KaitaiStruct {
        private long offsetAttachment;
        private long lengthAttachment;
        private long logTime;
        private long createTime;
        private long dataSize;
        private String name;
        private String mediaType;
        private Record attachment;

        public AttachmentIndex(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public AttachmentIndex(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.offsetAttachment = this.buffer.getLong();
            this.lengthAttachment = this.buffer.getLong();
            this.logTime = this.buffer.getLong();
            this.createTime = this.buffer.getLong();
            this.dataSize = this.buffer.getLong();
            this.name = MCAP.parseString(this.buffer);
            this.mediaType = MCAP.parseString(this.buffer);
            this.setComputedLength(48 + this.name.length() + this.mediaType.length());
        }

        public Record attachment() throws IOException {
            if (this.attachment == null) {
                this.attachment = new Record(this.fileChannel, this.offsetAttachment);
            }
            return this.attachment;
        }

        public long offsetAttachment() {
            return this.offsetAttachment;
        }

        public long lengthAttachment() {
            return this.lengthAttachment;
        }

        public long logTime() {
            return this.logTime;
        }

        public long createTime() {
            return this.createTime;
        }

        public long dataSize() {
            return this.dataSize;
        }

        public String name() {
            return this.name;
        }

        public String mediaType() {
            return this.mediaType;
        }

        @Override
        public String toString() {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-ofsAttachment = " + this.offsetAttachment;
            out = out + "\n\t-lenAttachment = " + this.lengthAttachment;
            out = out + "\n\t-logTime = " + this.logTime;
            out = out + "\n\t-createTime = " + this.createTime;
            out = out + "\n\t-dataSize = " + this.dataSize;
            out = out + "\n\t-name = " + this.name;
            out = out + "\n\t-mediaType = " + this.mediaType;
            return out;
        }
    }

    public static class Statistics
    extends KaitaiStruct {
        private long messageCount;
        private int schemaCount;
        private long channelCount;
        private long attachmentCount;
        private long metadataCount;
        private long chunkCount;
        private long messageStartTime;
        private long messageEndTime;
        private List<ChannelMessageCount> channelMessageCounts;

        public Statistics(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public Statistics(FileChannel fileChannel, long _pos, int length) throws IOException {
            super(fileChannel, _pos, length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.messageCount = this.buffer.getLong();
            this.schemaCount = Short.toUnsignedInt(this.buffer.getShort());
            this.channelCount = Integer.toUnsignedLong(this.buffer.getInt());
            this.attachmentCount = Integer.toUnsignedLong(this.buffer.getInt());
            this.metadataCount = Integer.toUnsignedLong(this.buffer.getInt());
            this.chunkCount = Integer.toUnsignedLong(this.buffer.getInt());
            this.messageStartTime = this.buffer.getLong();
            this.messageEndTime = this.buffer.getLong();
            int start = this.buffer.position();
            this.channelMessageCounts = MCAP.parseList(this.buffer, ChannelMessageCount::new);
            int channelMessageCountsLength = this.buffer.position() - start;
            this.setComputedLength(46 + channelMessageCountsLength);
        }

        public long messageCount() {
            return this.messageCount;
        }

        public int schemaCount() {
            return this.schemaCount;
        }

        public long channelCount() {
            return this.channelCount;
        }

        public long attachmentCount() {
            return this.attachmentCount;
        }

        public long metadataCount() {
            return this.metadataCount;
        }

        public long chunkCount() {
            return this.chunkCount;
        }

        public long messageStartTime() {
            return this.messageStartTime;
        }

        public long messageEndTime() {
            return this.messageEndTime;
        }

        public List<ChannelMessageCount> channelMessageCounts() {
            return this.channelMessageCounts;
        }

        @Override
        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-messageCount = " + this.messageCount;
            out = out + "\n\t-schemaCount = " + this.schemaCount;
            out = out + "\n\t-channelCount = " + this.channelCount;
            out = out + "\n\t-attachmentCount = " + this.attachmentCount;
            out = out + "\n\t-metadataCount = " + this.metadataCount;
            out = out + "\n\t-chunkCount = " + this.chunkCount;
            out = out + "\n\t-messageStartTime = " + this.messageStartTime;
            out = out + "\n\t-messageEndTime = " + this.messageEndTime;
            out = out + "\n\t-channelMessageCounts = \n" + EuclidCoreIOTools.getCollectionString((String)"\n", this.channelMessageCounts, e -> e.toString(1));
            return out;
        }

        public static class ChannelMessageCount
        implements Sizeable {
            private int channelId;
            private long messageCount;

            public ChannelMessageCount(ByteBuffer buffer) {
                this.channelId = Short.toUnsignedInt(buffer.getShort());
                this.messageCount = buffer.getLong();
            }

            @Override
            public int getItemTotalLength() {
                return 10;
            }

            public int channelId() {
                return this.channelId;
            }

            public long messageCount() {
                return this.messageCount;
            }

            public String toString() {
                return this.toString(0);
            }

            public String toString(int indent) {
                String out = this.getClass().getSimpleName() + ":";
                out = out + "\n\t-channelId = " + this.channelId;
                out = out + "\n\t-messageCount = " + this.messageCount;
                return MCAP.indent(out, indent);
            }
        }
    }

    public static class MessageIndex
    extends KaitaiStruct {
        private int channelId;
        private List<MessageIndexEntry> messageIndexEntries;

        public MessageIndex(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public MessageIndex(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.channelId = Short.toUnsignedInt(this.buffer.getShort());
            int start = this.buffer.position();
            this.messageIndexEntries = MCAP.parseList(this.buffer, MessageIndexEntry::new);
            int entriesLength = this.buffer.position() - start;
            this.setComputedLength(2 + entriesLength);
        }

        public int channelId() {
            return this.channelId;
        }

        public List<MessageIndexEntry> records() {
            return this.messageIndexEntries;
        }

        @Override
        public String toString() {
            return this.toString(0);
        }

        @Override
        public String toString(int indent) {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-channelId = " + this.channelId;
            out = out + "\n\t-messageIndexEntries = " + (String)(this.messageIndexEntries == null ? "null" : "\n" + EuclidCoreIOTools.getCollectionString((String)"\n", this.messageIndexEntries, e -> e.toString(indent + 1)));
            return MCAP.indent(out, indent);
        }

        public static class MessageIndexEntry
        implements Sizeable {
            private long logTime;
            private long offset;

            public MessageIndexEntry(ByteBuffer buffer) {
                this.logTime = buffer.getLong();
                this.offset = buffer.getLong();
            }

            @Override
            public int getItemTotalLength() {
                return 16;
            }

            public long logTime() {
                return this.logTime;
            }

            public long offset() {
                return this.offset;
            }

            public String toString() {
                return this.toString(0);
            }

            public String toString(int indent) {
                String out = this.getClass().getSimpleName() + ":";
                out = out + "\n\t-logTime = " + this.logTime;
                out = out + "\n\t-offset = " + this.offset;
                return MCAP.indent(out, indent);
            }
        }
    }

    public static class Channel
    extends KaitaiStruct {
        private int id;
        private int schemaId;
        private String topic;
        private String messageEncoding;
        private List<TupleStrStr> metadata;

        public Channel(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public Channel(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.id = Short.toUnsignedInt(this.buffer.getShort());
            this.schemaId = Short.toUnsignedInt(this.buffer.getShort());
            this.topic = MCAP.parseString(this.buffer);
            this.messageEncoding = MCAP.parseString(this.buffer);
            int start = this.buffer.position();
            this.metadata = MCAP.parseList(this.buffer, TupleStrStr::new);
            int end = this.buffer.position();
            int metadataLength = end - start;
            this.setComputedLength(12 + this.topic.length() + this.messageEncoding.length() + metadataLength);
        }

        public int id() {
            return this.id;
        }

        public int schemaId() {
            return this.schemaId;
        }

        public String topic() {
            return this.topic;
        }

        public String messageEncoding() {
            return this.messageEncoding;
        }

        public List<TupleStrStr> metadata() {
            return this.metadata;
        }

        @Override
        public String toString() {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-id = " + this.id;
            out = out + "\n\t-schemaId = " + this.schemaId;
            out = out + "\n\t-topic = " + this.topic;
            out = out + "\n\t-messageEncoding = " + this.messageEncoding;
            out = out + "\n\t-metadata = [%s]".formatted(this.metadata.toString());
            return out;
        }
    }

    public static class DataEnd
    extends KaitaiStruct {
        private long dataSectionCrc32;

        public DataEnd(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public DataEnd(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.dataSectionCrc32 = Integer.toUnsignedLong(this.buffer.getInt());
            this.setComputedLength(4);
        }

        public long dataSectionCrc32() {
            return this.dataSectionCrc32;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + ":\n\t-dataSectionCrc32 = " + this.dataSectionCrc32;
        }
    }

    public static class Chunk
    extends KaitaiStruct {
        private LZ4FrameDecoder lz4FrameDecoder;
        private ZstdDecompressCtx zstdDecompressCtx;
        private long messageStartTime;
        private long messageEndTime;
        private long uncompressedSize;
        private long uncompressedCrc32;
        private String compression;
        private long offsetRecords;
        private long lengthRecords;
        private Records records;

        public Chunk(ByteBuffer buffer, long _pos, int _length) throws IOException {
            super(buffer, _pos, _length);
            this._read();
        }

        public Chunk(FileChannel fileChannel, long _pos, int _length) throws IOException {
            super(fileChannel, _pos, _length);
            this._read();
        }

        @Override
        public void _read() throws IOException {
            this._readIntoBuffer();
            this.messageStartTime = this.buffer.getLong();
            this.messageEndTime = this.buffer.getLong();
            this.uncompressedSize = this.buffer.getLong();
            this.uncompressedCrc32 = Integer.toUnsignedLong(this.buffer.getInt());
            this.compression = MCAP.parseString(this.buffer);
            this.lengthRecords = this.buffer.getLong();
            this.offsetRecords = this.buffer.position();
            this.buffer.position((int)(this.offsetRecords + this.lengthRecords));
            this.setComputedLength(32 + this.compression.length() + 8 + (int)this.lengthRecords);
        }

        public long messageStartTime() {
            return this.messageStartTime;
        }

        public long messageEndTime() {
            return this.messageEndTime;
        }

        public long uncompressedSize() {
            return this.uncompressedSize;
        }

        public long uncompressedCrc32() {
            return this.uncompressedCrc32;
        }

        public String compression() {
            return this.compression;
        }

        public long lenRecords() {
            return this.lengthRecords;
        }

        public Records records() throws IOException {
            if (this.records == null) {
                if (this.compression.equalsIgnoreCase("")) {
                    this.records = new Records(this.buffer, this.offsetRecords, (int)this.lengthRecords);
                } else if (this.compression.equalsIgnoreCase("lz4")) {
                    if (this.lz4FrameDecoder == null) {
                        this.lz4FrameDecoder = new LZ4FrameDecoder();
                    }
                    ByteBuffer decompressedData = ByteBuffer.allocate((int)this.uncompressedSize);
                    this.lz4FrameDecoder.decode(this.buffer, (int)this.offsetRecords, (int)this.lengthRecords, decompressedData, 0);
                    this.records = new Records(decompressedData);
                } else if (this.compression.equalsIgnoreCase("zstd")) {
                    if (this.zstdDecompressCtx == null) {
                        this.zstdDecompressCtx = new ZstdDecompressCtx();
                    }
                    int previousPosition = this.buffer.position();
                    int previousLimit = this.buffer.limit();
                    this.buffer.limit((int)(this.offsetRecords + this.lengthRecords));
                    this.buffer.position((int)this.offsetRecords);
                    ByteBuffer decompressedData = this.zstdDecompressCtx.decompress(this.buffer, (int)this.uncompressedSize);
                    this.buffer.position(previousPosition);
                    this.buffer.limit(previousLimit);
                    this.records = new Records(decompressedData);
                } else {
                    throw new UnsupportedOperationException("Unsupported compression algorithm: " + this.compression);
                }
            }
            return this.records;
        }

        public void unloadRecords() {
            this.records = null;
        }

        @Override
        public String toString() {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-messageStartTime = " + this.messageStartTime;
            out = out + "\n\t-messageEndTime = " + this.messageEndTime;
            out = out + "\n\t-compression = " + this.compression;
            out = out + "\n\t-compressedSize = " + this.lengthRecords;
            out = out + "\n\t-uncompressedSize = " + this.uncompressedSize;
            out = out + "\n\t-uncompressedCrc32 = " + this.uncompressedCrc32;
            return out;
        }
    }
}

