/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.stream.IntStream;
import us.ihmc.commons.Conversions;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.LogIndex;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.robotDataLogger.jointState.JointState;
import us.ihmc.robotDataLogger.logger.LogPropertiesReader;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.session.tools.RobotDataLogTools;
import us.ihmc.tools.compression.SnappyUtils;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class LogDataReader {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final File logDirectory;
    private final LogPropertiesReader logProperties;
    private final YoVariableHandshakeParser parser;
    private final YoLong timestamp;
    private final YoDouble robotTime;
    private final FileChannel logChannel;
    private final FileInputStream logFileInputStream;
    private final List<YoVariable> yoVariables;
    private final boolean compressed;
    private final LogIndex logIndex;
    private final ByteBuffer compressedBuffer;
    private int index = 0;
    private final List<JointState> jointStates;
    private final ByteBuffer logLine;
    private final LongBuffer logLongArray;
    private final YoInteger currentRecordTick;
    private final int numberOfEntries;
    private final long initialTimestamp;
    private final long finalTimestamp = 0L;

    public LogDataReader(File logDirectory, ProgressConsumer progressConsumer) throws IOException {
        this.logDirectory = logDirectory;
        this.logProperties = new LogPropertiesReader(RobotDataLogTools.propertyFile(logDirectory));
        RobotDataLogTools.updateLogs(logDirectory, (LogProperties)this.logProperties, progressConsumer);
        LogTools.info((String)"Loaded log properties.");
        this.parser = RobotDataLogTools.parseYoVariables(logDirectory, (LogProperties)this.logProperties);
        LogTools.info((String)"Loaded YoVariable definition.");
        LogTools.info((String)("This log contains " + this.parser.getNumberOfVariables() + " YoVariables"));
        this.timestamp = new YoLong("timestamp", this.registry);
        this.robotTime = new YoDouble("robotTime", this.registry);
        this.currentRecordTick = new YoInteger("currentRecordTick", this.registry);
        this.jointStates = this.parser.getJointStates();
        this.yoVariables = this.parser.getYoVariablesList();
        int jointStateOffset = this.yoVariables.size();
        int numberOfJointStates = JointState.getNumberOfJointStates(this.jointStates);
        int bufferSize = (1 + jointStateOffset + numberOfJointStates) * 8;
        File logdata = RobotDataLogTools.logDataFile(logDirectory, (LogProperties)this.logProperties, true);
        this.logFileInputStream = new FileInputStream(logdata);
        this.logChannel = this.logFileInputStream.getChannel();
        this.compressed = this.logProperties.getVariables().getCompressed();
        if (this.compressed) {
            File indexData = new File(logDirectory, this.logProperties.getVariables().getIndexAsString());
            if (!indexData.exists()) {
                throw new RuntimeException("Cannot find " + this.logProperties.getVariables().getIndexAsString());
            }
            this.logIndex = new LogIndex(indexData, this.logChannel.size());
            this.compressedBuffer = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)bufferSize));
            this.numberOfEntries = this.logIndex.getNumberOfEntries();
            LogTools.info((String)"Loaded indexing.");
        } else {
            this.numberOfEntries = (int)(this.logChannel.size() / (long)bufferSize) - 1;
            this.logIndex = null;
            this.compressedBuffer = null;
        }
        this.logLine = ByteBuffer.allocate(bufferSize);
        this.logLongArray = this.logLine.asLongBuffer();
        try {
            if (this.compressed) {
                this.initialTimestamp = this.logIndex.getInitialTimestamp();
                this.positionChannel(0);
            } else {
                this.readLogLine();
                this.initialTimestamp = this.logLine.getLong(0);
                this.positionChannel(0);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getInitialTimestamp() {
        return this.initialTimestamp;
    }

    public long getFinalTimestamp() {
        return 0L;
    }

    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public YoLong getTimestamp() {
        return this.timestamp;
    }

    public void seek(int position) {
        this.currentRecordTick.set(position);
        try {
            this.positionChannel(position);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean read() {
        boolean done = this.readAndProcessALogLineReturnTrueIfDone();
        if (!done) {
            this.currentRecordTick.increment();
        }
        return done;
    }

    private boolean readAndProcessALogLineReturnTrueIfDone() {
        try {
            if (!this.readLogLine()) {
                System.out.println("Reached end of file, stopping simulation thread");
                return true;
            }
            this.timestamp.set(this.logLongArray.get());
            this.robotTime.set(Conversions.nanosecondsToSeconds((long)(this.timestamp.getLongValue() - this.initialTimestamp)));
            IntStream.range(0, this.yoVariables.size()).parallel().forEach(i -> this.yoVariables.get(i).setValueFromLongBits(this.logLongArray.get(this.logLongArray.position() + i), true));
            this.logLongArray.position(this.logLongArray.position() + this.yoVariables.size());
            for (int i2 = 0; i2 < this.jointStates.size(); ++i2) {
                this.jointStates.get(i2).update(this.logLongArray);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void positionChannel(int position) throws IOException {
        if (this.compressed) {
            this.index = position;
            if (this.index < this.logIndex.dataOffsets.length) {
                this.logChannel.position(this.logIndex.dataOffsets[position]);
            }
        } else {
            this.logChannel.position((long)position * (long)this.logLine.capacity());
        }
    }

    public long getTimestamp(int position) {
        if (!this.compressed) {
            throw new RuntimeException("Cannot get timestamp for non-compressed logs");
        }
        return this.logIndex.timestamps[position];
    }

    private boolean readLogLine() throws IOException {
        this.logLine.clear();
        this.logLongArray.clear();
        if (this.compressed) {
            if (this.index >= this.logIndex.getNumberOfEntries()) {
                return false;
            }
            int size = this.logIndex.compressedSizes[this.index];
            this.compressedBuffer.clear();
            this.compressedBuffer.limit(size);
            int read = this.logChannel.read(this.compressedBuffer);
            if (read != size) {
                throw new RuntimeException("Expected read of " + size + ", got " + read + ". TODO: Implement loop for reading the full log line.");
            }
            this.compressedBuffer.flip();
            SnappyUtils.uncompress((ByteBuffer)this.compressedBuffer, (ByteBuffer)this.logLine);
            ++this.index;
            return true;
        }
        int read = this.logChannel.read(this.logLine);
        if (read < 0) {
            return false;
        }
        if (read != this.logLine.capacity()) {
            throw new RuntimeException("Expected read of " + this.logLine.capacity() + ", got " + read + ". TODO: Implement loop for reading the full log line.");
        }
        return true;
    }

    public int getPosition(long timestamp) {
        return this.logIndex.seek(timestamp);
    }

    public long getRelativeTimestamp(int position) {
        return this.getRelativeTimestamp(this.getTimestamp(position));
    }

    public long getRelativeTimestamp(long timestamp) {
        return timestamp - this.initialTimestamp;
    }

    public double getRobotTime(long timestamp) {
        return Conversions.nanosecondsToSeconds((long)(timestamp - this.initialTimestamp));
    }

    public double getCurrentRobotTime() {
        return this.robotTime.getValue();
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public LogPropertiesReader getLogProperties() {
        return this.logProperties;
    }

    public YoVariableHandshakeParser getParser() {
        return this.parser;
    }

    public int getCurrentLogPosition() {
        return this.currentRecordTick.getValue();
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }
}

