/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.session.mcap.MCAPLogCropperTest;
import us.ihmc.scs2.session.mcap.MCAPLogFileReader;
import us.ihmc.scs2.session.mcap.MCAPLogRepacker;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Chunk;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.Records;

public class MCAPLogRepackerTest {
    @Test
    public void testRepack() throws IOException {
        File demoMCAPFile = MCAPLogCropperTest.getDemoMCAPFile();
        MCAP originalMCAP = new MCAP(new FileInputStream(demoMCAPFile).getChannel());
        MCAPLogFileReader.exportChunkToFile((Path)MCAPLogFileReader.SCS2_MCAP_DEBUG_HOME, (Chunk)((Chunk)((Record)originalMCAP.records().get(1)).body()), null);
        MCAPLogRepacker mcapLogRepacker = new MCAPLogRepacker();
        File repackedDemoMCAPFile = MCAPLogCropperTest.createTempMCAPFile("repackedDemo");
        mcapLogRepacker.repack(originalMCAP, new FileOutputStream(repackedDemoMCAPFile), null);
        MCAP repackedMCAP = new MCAP(new FileInputStream(repackedDemoMCAPFile).getChannel());
        MCAPLogRepackerTest.assertChunksEquivalent(originalMCAP.records(), repackedMCAP.records());
        MCAPLogCropperTest.assertSchemasEqual(originalMCAP.records(), repackedMCAP.records());
        MCAPLogCropperTest.assertChannelsEqual(originalMCAP.records(), repackedMCAP.records());
        MCAPLogCropperTest.assertAttachmentsEqual(originalMCAP.records(), repackedMCAP.records());
        MCAPLogCropperTest.assertMetadatasEqual(originalMCAP.records(), repackedMCAP.records());
        MCAPLogCropperTest.validateDataEnd(originalMCAP);
        MCAPLogCropperTest.validateChunkIndices(originalMCAP);
        MCAPLogCropperTest.validateMessageIndices(originalMCAP.records());
        MCAPLogCropperTest.validateFooter(originalMCAP);
        MCAPLogCropperTest.validateDataEnd(repackedMCAP);
        MCAPLogCropperTest.validateChunkIndices(repackedMCAP);
        MCAPLogCropperTest.validateMessageIndices(repackedMCAP.records());
        MCAPLogCropperTest.validateFooter(repackedMCAP);
    }

    public static void assertChunksEquivalent(List<Record> expectedRecords, List<Record> actualRecords) {
        List<Chunk> expectedChunks = expectedRecords.stream().filter(r -> r.op() == Opcode.CHUNK).map(r -> (Chunk)r.body()).toList();
        List<Chunk> actualChunks = actualRecords.stream().filter(r -> r.op() == Opcode.CHUNK).map(r -> (Chunk)r.body()).toList();
        if (expectedChunks.size() != actualChunks.size()) {
            Assertions.fail((String)("Expected " + expectedChunks.size() + " chunks, but found " + actualChunks.size()));
        }
        for (int i = 0; i < expectedChunks.size(); ++i) {
            Chunk expectedChunk = expectedChunks.get(i);
            Chunk actualChunk = actualChunks.stream().filter(c -> c.messageStartTime() == expectedChunk.messageStartTime()).findFirst().orElse(null);
            Assertions.assertNotNull((Object)actualChunk, (String)("Could not find a chunk with message start time " + expectedChunk.messageStartTime()));
            Assertions.assertEquals((long)expectedChunk.messageStartTime(), (long)actualChunk.messageStartTime(), (String)("Chunk " + i + " has different start time"));
            Assertions.assertEquals((long)expectedChunk.messageEndTime(), (long)actualChunk.messageEndTime(), (String)("Chunk " + i + " has different end time"));
            Assertions.assertEquals((long)expectedChunk.recordsUncompressedLength(), (long)actualChunk.recordsUncompressedLength(), (String)("Chunk " + i + " has different uncompressed length"));
            Assertions.assertEquals((Object)expectedChunk.compression(), (Object)actualChunk.compression(), (String)("Chunk " + i + " has different compression"));
            if (expectedChunk.records().equals((Object)actualChunk.records())) {
                Assertions.assertEquals((long)expectedChunk.uncompressedCRC32(), (long)actualChunk.uncompressedCRC32(), (String)("Chunk " + i + " has different uncompressed CRC32"));
                continue;
            }
            Records expectedChunkRecords = new Records((Collection)expectedChunk.records());
            expectedChunkRecords.sortByTimestamp();
            Assertions.assertEquals((int)expectedChunkRecords.size(), (int)actualChunk.records().size(), (String)("Chunk " + i + " has different number of records"));
            for (int j = 0; j < expectedChunkRecords.size(); ++j) {
                Record expectedChunkInnerRecord = expectedChunkRecords.get(j);
                Record actualChunkInnerRecord = actualChunk.records().get(j);
                Assertions.assertEquals((Object)expectedChunkInnerRecord.op(), (Object)actualChunkInnerRecord.op(), (String)("Chunk " + i + " has different record at index " + j));
                Assertions.assertEquals((Object)expectedChunkInnerRecord.body(), (Object)actualChunkInnerRecord.body(), (String)("Chunk " + i + " has different record at index " + j));
            }
            Assertions.assertEquals((long)expectedChunkRecords.getCRC32(), (long)actualChunk.uncompressedCRC32(), (String)("Chunk " + i + " has different uncompressed CRC32"));
        }
    }
}

