/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.io.InputStream;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.session.mcap.MCAPSchema;
import us.ihmc.scs2.session.mcap.OMGIDLSchemaParser;
import us.ihmc.scs2.session.mcap.omgidl_parser.IDLLexer;
import us.ihmc.scs2.session.mcap.omgidl_parser.IDLParser;
import us.ihmc.scs2.session.mcap.omgidl_parser.PrintListener;

public class OMGIDLSchemaTest {
    @Test
    @Disabled
    public void testOMGIDLParser() throws Exception {
        String schemaName = "simple-idl-one-struct.idl";
        CharStream bytesAsChar = CharStreams.fromStream((InputStream)this.getClass().getResourceAsStream(schemaName));
        IDLLexer lexer = new IDLLexer(bytesAsChar);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        IDLParser parser = new IDLParser((TokenStream)tokens);
        parser.setBuildParseTree(true);
        IDLParser.SpecificationContext tree = parser.specification();
        PrintListener printListener = new PrintListener();
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)printListener, (ParseTree)tree);
    }

    @Test
    public void testLoadSchemaFromFile() throws Exception {
        String schemaName = "simple_idl_with_structs";
        InputStream is = this.getClass().getResourceAsStream(schemaName + ".idl");
        MCAPSchema schema = OMGIDLSchemaParser.loadSchema((String)schemaName, (int)0, (byte[])is.readAllBytes());
        Assertions.assertFalse((boolean)schema.isSchemaFlat());
        Assertions.assertEquals((int)1, (int)schema.getStaticFields().size());
        Assertions.assertEquals((int)5, (int)schema.getFields().size());
        Assertions.assertEquals((Object)"double_const", (Object)((MCAPSchema.MCAPSchemaField)schema.getStaticFields().get(0)).getName());
        Assertions.assertEquals((Object)"6.9", (Object)((MCAPSchema.MCAPSchemaField)schema.getStaticFields().get(0)).getDefaultValue());
        Assertions.assertEquals((Object)"float_var", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(0)).getName());
        Assertions.assertEquals((Object)"boolean_var", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(1)).getName());
        Assertions.assertEquals((Object)"long_array_var", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(2)).getName());
        Assertions.assertEquals((Object)"struct_1_var", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(3)).getName());
        Assertions.assertEquals((Object)"long_double_var", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(4)).getName());
        Assertions.assertEquals((Object)"double_const", (Object)((MCAPSchema.MCAPSchemaField)schema.getStaticFields().get(0)).getName());
        Assertions.assertEquals((Object)"double", (Object)((MCAPSchema.MCAPSchemaField)schema.getStaticFields().get(0)).getType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(0)).isComplexType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(0)).isArray());
        Assertions.assertEquals((int)-1, (int)((MCAPSchema.MCAPSchemaField)schema.getFields().get(0)).getMaxLength());
        Assertions.assertNull((Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(0)).getParent());
        Assertions.assertTrue((boolean)schema.getSubSchemaMap().containsKey("struct_1"));
        MCAPSchema expectedSubSchema = (MCAPSchema)schema.getSubSchemaMap().get("struct_1");
        Assertions.assertTrue((boolean)expectedSubSchema.isSchemaFlat());
        Assertions.assertEquals((int)6, (int)expectedSubSchema.getFields().size());
        Assertions.assertEquals((Object)"signed_short_var", (Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(0)).getName());
        Assertions.assertEquals((Object)"short", (Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(0)).getType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(0)).isComplexType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(0)).isArray());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(0)).isVector());
        Assertions.assertEquals((int)-1, (int)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(0)).getMaxLength());
        Assertions.assertNull((Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(0)).getParent());
        Assertions.assertEquals((Object)"unsigned_short_var", (Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(1)).getName());
        Assertions.assertEquals((Object)"unsignedshort", (Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(1)).getType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(1)).isComplexType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(1)).isArray());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(1)).isVector());
        Assertions.assertEquals((int)-1, (int)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(1)).getMaxLength());
        Assertions.assertNull((Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(1)).getParent());
        Assertions.assertEquals((Object)"octet_var", (Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(2)).getName());
        Assertions.assertEquals((Object)"octet", (Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(2)).getType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(2)).isComplexType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(2)).isArray());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(2)).isVector());
        Assertions.assertEquals((int)-1, (int)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(2)).getMaxLength());
        Assertions.assertNull((Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(2)).getParent());
        Assertions.assertEquals((Object)"char_var", (Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(3)).getName());
        Assertions.assertEquals((Object)"char", (Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(3)).getType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(3)).isComplexType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(3)).isArray());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(3)).isVector());
        Assertions.assertEquals((int)-1, (int)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(3)).getMaxLength());
        Assertions.assertNull((Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(3)).getParent());
        Assertions.assertEquals((Object)"string_var", (Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(4)).getName());
        Assertions.assertEquals((Object)"string", (Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(4)).getType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(4)).isComplexType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(4)).isArray());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(4)).isVector());
        Assertions.assertEquals((int)-1, (int)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(4)).getMaxLength());
        Assertions.assertNull((Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(4)).getParent());
        Assertions.assertEquals((Object)"sequence_var", (Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(5)).getName());
        Assertions.assertEquals((Object)"double", (Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(5)).getType());
        Assertions.assertTrue((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(5)).isComplexType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(5)).isArray());
        Assertions.assertTrue((boolean)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(5)).isVector());
        Assertions.assertEquals((int)27, (int)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(5)).getMaxLength());
        Assertions.assertNull((Object)((MCAPSchema.MCAPSchemaField)expectedSubSchema.getFields().get(5)).getParent());
        Assertions.assertFalse((boolean)schema.isSchemaFlat());
        Assertions.assertEquals((int)5, (int)schema.getFields().size());
        Assertions.assertEquals((Object)"float_var", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(0)).getName());
        Assertions.assertEquals((Object)"float", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(0)).getType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(0)).isComplexType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(0)).isArray());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(0)).isVector());
        Assertions.assertEquals((int)-1, (int)((MCAPSchema.MCAPSchemaField)schema.getFields().get(0)).getMaxLength());
        Assertions.assertNull((Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(0)).getParent());
        Assertions.assertEquals((Object)"boolean_var", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(1)).getName());
        Assertions.assertEquals((Object)"boolean", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(1)).getType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(1)).isComplexType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(1)).isArray());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(1)).isVector());
        Assertions.assertEquals((int)-1, (int)((MCAPSchema.MCAPSchemaField)schema.getFields().get(1)).getMaxLength());
        Assertions.assertNull((Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(1)).getParent());
        Assertions.assertEquals((Object)"long_array_var", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(2)).getName());
        Assertions.assertEquals((Object)"long", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(2)).getType());
        Assertions.assertTrue((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(2)).isComplexType());
        Assertions.assertTrue((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(2)).isArray());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(2)).isVector());
        Assertions.assertEquals((int)13, (int)((MCAPSchema.MCAPSchemaField)schema.getFields().get(2)).getMaxLength());
        Assertions.assertNull((Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(2)).getParent());
        Assertions.assertEquals((Object)"struct_1_var", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(3)).getName());
        Assertions.assertEquals((Object)"struct_1", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(3)).getType());
        Assertions.assertTrue((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(3)).isComplexType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(3)).isArray());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(3)).isVector());
        Assertions.assertEquals((int)-1, (int)((MCAPSchema.MCAPSchemaField)schema.getFields().get(3)).getMaxLength());
        Assertions.assertNull((Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(3)).getParent());
        Assertions.assertEquals((Object)"long_double_var", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(4)).getName());
        Assertions.assertEquals((Object)"longdouble", (Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(4)).getType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(4)).isComplexType());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(4)).isArray());
        Assertions.assertFalse((boolean)((MCAPSchema.MCAPSchemaField)schema.getFields().get(4)).isVector());
        Assertions.assertEquals((int)-1, (int)((MCAPSchema.MCAPSchemaField)schema.getFields().get(4)).getMaxLength());
        Assertions.assertNull((Object)((MCAPSchema.MCAPSchemaField)schema.getFields().get(4)).getParent());
    }

    @Disabled
    @Test
    public void testFlattenSchema() throws Exception {
        String schemaName = "NavigationAppHealth";
        InputStream is = this.getClass().getResourceAsStream(schemaName + ".idl");
        MCAPSchema schema = OMGIDLSchemaParser.loadSchema((String)schemaName, (int)0, (byte[])is.readAllBytes());
        MCAPSchema flatSchema = schema.flattenSchema();
        System.out.println(flatSchema);
    }

    @Disabled
    @Test
    public void testFlattenArray() throws Exception {
        String schemaName = "flatten_array_test";
        InputStream is = this.getClass().getResourceAsStream(schemaName + ".idl");
        MCAPSchema schema = OMGIDLSchemaParser.loadSchema((String)schemaName, (int)0, (byte[])is.readAllBytes());
        MCAPSchema.MCAPSchemaField field = (MCAPSchema.MCAPSchemaField)((MCAPSchema)schema.getSubSchemaMap().get(schemaName)).getFields().get(0);
        List flatFields = schema.flattenField(field);
        System.out.println(flatFields);
    }
}

