/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.input;

import com.github.luben.zstd.ZstdCompressCtx;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.session.mcap.input.MCAPBufferedFileChannelInput;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;

public class MCAPBufferedFileChannelInputTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testReadingBytes() {
        ByteBuffer buffer = ByteBuffer.wrap("Hello, World!".getBytes());
        MCAPBufferedFileChannelInput input = new MCAPBufferedFileChannelInput(MCAPBufferedFileChannelInputTest.mockFileChannel(buffer));
        byte[] bytes = new byte[5];
        input.getBytes(bytes);
        Assertions.assertArrayEquals((byte[])"Hello".getBytes(), (byte[])bytes);
    }

    @Test
    public void testRandomAccessesOnLargeByteArray() {
        Random random = new Random(1234L);
        byte[] originalBytes = new byte[100000];
        random.nextBytes(originalBytes);
        ByteBuffer buffer = ByteBuffer.wrap(originalBytes);
        MCAPBufferedFileChannelInput input = new MCAPBufferedFileChannelInput(MCAPBufferedFileChannelInputTest.mockFileChannel(buffer), 1024, false);
        for (int i = 0; i < 1000; ++i) {
            int position = random.nextInt(originalBytes.length);
            int n = random.nextInt(originalBytes.length - position);
            byte[] byArray = new byte[n];
            System.arraycopy(originalBytes, position, byArray, 0, n);
            byte[] actualBytes = new byte[n];
            input.position((long)position);
            input.getBytes(actualBytes);
            Assertions.assertArrayEquals((byte[])byArray, (byte[])actualBytes, (String)("Iteration " + i));
            position = random.nextInt(originalBytes.length);
            int n2 = random.nextInt(originalBytes.length - position);
            byte[] byArray2 = new byte[n2];
            System.arraycopy(originalBytes, position, byArray2, 0, n2);
            ByteBuffer actualBuffer = input.getByteBuffer((long)position, n2, false);
            byte[] actualBytes2 = new byte[n2];
            actualBuffer.get(actualBytes2);
            Assertions.assertArrayEquals((byte[])byArray2, (byte[])actualBytes2);
            position = random.nextInt(originalBytes.length - 8);
            long l = ByteBuffer.wrap(originalBytes, position, 8).order(ByteOrder.LITTLE_ENDIAN).getLong();
            input.position((long)position);
            long actualValue = input.getLong();
            Assertions.assertEquals((long)l, (long)actualValue);
            position = random.nextInt(originalBytes.length - 4);
            int n3 = ByteBuffer.wrap(originalBytes, position, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
            input.position((long)position);
            int n4 = input.getInt();
            Assertions.assertEquals((int)n3, (int)n4);
            position = random.nextInt(originalBytes.length - 2);
            short s = ByteBuffer.wrap(originalBytes, position, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
            input.position((long)position);
            short s2 = input.getShort();
            Assertions.assertEquals((short)s, (short)s2);
            position = random.nextInt(originalBytes.length);
            byte by = originalBytes[position];
            input.position((long)position);
            byte by2 = input.getByte();
            Assertions.assertEquals((byte)by, (byte)by2);
        }
    }

    @Test
    public void testGettingValues() throws IOException {
        ByteBuffer originalBuffer = ByteBuffer.allocate(24);
        originalBuffer.order(ByteOrder.LITTLE_ENDIAN);
        originalBuffer.putLong(123456789L);
        originalBuffer.putInt(987654321);
        originalBuffer.putLong(9047L);
        originalBuffer.putShort((short)12345);
        originalBuffer.put((byte)127);
        originalBuffer.flip();
        MCAPBufferedFileChannelInput input = new MCAPBufferedFileChannelInput(MCAPBufferedFileChannelInputTest.mockFileChannel(MCAPBufferedFileChannelInputTest.duplicate(originalBuffer, false)));
        Assertions.assertEquals((long)123456789L, (long)input.getLong());
        Assertions.assertEquals((int)987654321, (int)input.getInt());
        Assertions.assertEquals((long)9047L, (long)input.getLong());
        Assertions.assertEquals((short)12345, (short)input.getShort());
        Assertions.assertEquals((byte)127, (byte)input.getByte());
        input = new MCAPBufferedFileChannelInput(MCAPBufferedFileChannelInputTest.mockFileChannel(MCAPBufferedFileChannelInputTest.duplicate(originalBuffer, false)), 8, false);
        Assertions.assertEquals((long)123456789L, (long)input.getLong());
        MCAPBufferedFileChannelInputTest.assertInputPositions(input, 8L, 0L, 8);
        Assertions.assertEquals((int)987654321, (int)input.getInt());
        MCAPBufferedFileChannelInputTest.assertInputPositions(input, 12L, 8L, 4);
        Assertions.assertEquals((long)9047L, (long)input.getLong());
        MCAPBufferedFileChannelInputTest.assertInputPositions(input, 20L, 12L, 8);
        Assertions.assertEquals((short)12345, (short)input.getShort());
        MCAPBufferedFileChannelInputTest.assertInputPositions(input, 22L, 20L, 2);
        Assertions.assertEquals((byte)127, (byte)input.getByte());
    }

    private static void assertInputPositions(MCAPBufferedFileChannelInput input, long expectedPosition, long expected_pos, int expectedReadingBufferPosition) {
        Assertions.assertEquals((long)expectedPosition, (long)input.position());
        Assertions.assertEquals((long)expected_pos, (long)input._pos());
        Assertions.assertEquals((int)expectedReadingBufferPosition, (int)input.getReadingBuffer().position());
    }

    @Test
    public void testGettingByteBuffer() {
        ByteBuffer buffer = ByteBuffer.wrap("Hello, World!".getBytes());
        MCAPBufferedFileChannelInput input = new MCAPBufferedFileChannelInput(MCAPBufferedFileChannelInputTest.mockFileChannel(buffer));
        ByteBuffer result = input.getByteBuffer(0L, buffer.capacity(), false);
        Assertions.assertArrayEquals((byte[])buffer.array(), (byte[])result.array());
    }

    @Test
    public void testGetDecompressedByteBufferFromFileChannel() {
        ByteBuffer buffer = ByteBuffer.wrap("Hello, World!".getBytes());
        MCAPBufferedFileChannelInput input = new MCAPBufferedFileChannelInput(MCAPBufferedFileChannelInputTest.mockFileChannel(buffer));
        ByteBuffer decompressedBuffer = input.getDecompressedByteBuffer(0L, (int)input.size(), (int)input.size(), MCAPDataInput.Compression.NONE, false);
        byte[] expectedBytes = "Hello, World!".getBytes();
        byte[] actualBytes = new byte[decompressedBuffer.remaining()];
        decompressedBuffer.get(actualBytes);
        Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])actualBytes);
        ByteBuffer originalBuffer = MCAPBufferedFileChannelInputTest.duplicate(ByteBuffer.wrap("Hello, World!".getBytes()), true);
        ByteBuffer compressedBuffer = new ZstdCompressCtx().compress(originalBuffer);
        MCAPBufferedFileChannelInput input2 = new MCAPBufferedFileChannelInput(MCAPBufferedFileChannelInputTest.mockFileChannel(compressedBuffer));
        ByteBuffer decompressedBuffer2 = input2.getDecompressedByteBuffer(0L, (int)input2.size(), originalBuffer.capacity(), MCAPDataInput.Compression.ZSTD, false);
        byte[] expectedBytes2 = "Hello, World!".getBytes();
        byte[] actualBytes2 = new byte[decompressedBuffer2.remaining()];
        decompressedBuffer2.get(actualBytes2);
        Assertions.assertArrayEquals((byte[])expectedBytes2, (byte[])actualBytes2);
    }

    private static ByteBuffer duplicate(ByteBuffer buffer, boolean direct) {
        ByteBuffer duplicate = direct ? ByteBuffer.allocateDirect(buffer.capacity()) : ByteBuffer.allocate(buffer.capacity());
        duplicate.order(buffer.order());
        duplicate.put(buffer.duplicate());
        duplicate.flip();
        return duplicate;
    }

    private static FileChannel mockFileChannel(final ByteBuffer content) {
        return new FileChannel(){

            @Override
            public int read(ByteBuffer dst) {
                int remaining = content.remaining();
                int toRead = Math.min(dst.remaining(), remaining);
                for (int i = 0; i < toRead; ++i) {
                    dst.put(content.get());
                }
                return toRead;
            }

            @Override
            public int read(ByteBuffer dst, long position) {
                int remaining = (int)((long)content.limit() - position);
                int toRead = Math.min(dst.remaining(), remaining);
                dst.put(dst.position(), content, (int)position, toRead);
                dst.position(dst.position() + toRead);
                return toRead;
            }

            @Override
            public long position() {
                return content.position();
            }

            @Override
            public FileChannel position(long newPosition) {
                content.position((int)newPosition);
                return this;
            }

            @Override
            public long size() {
                return content.limit();
            }

            @Override
            public int write(ByteBuffer src) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int write(ByteBuffer src, long position) {
                throw new UnsupportedOperationException();
            }

            @Override
            public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public FileLock lock(long position, long size, boolean shared) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public FileLock tryLock(long position, long size, boolean shared) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public FileChannel truncate(long size) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void force(boolean metaData) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long read(ByteBuffer[] dsts, int offset, int length) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long write(ByteBuffer[] srcs, int offset, int length) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void implCloseChannel() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

