/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations.bullet;

import us.ihmc.commons.Conversions;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.examples.simulations.bullet.MobileBulletDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerControls;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngineFactory;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyParameters;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class MobileBulletSimulation {
    private static final boolean VISUALIZE_WITH_DEBUG_DRAWING = false;
    private static final double DT = 0.004;

    public static SimulationSession createSession() {
        MobileBulletDefinition definition = new MobileBulletDefinition();
        definition.addControllerDefinition((controllerInput, controllerOutput) -> new Controller(){
            YoRegistry registry = new YoRegistry("MobileBulletRobotController");
            YoDouble realtimeRate = new YoDouble("realtimeRate", this.registry);
            double lastRecord = Double.NaN;

            public void initialize() {
            }

            public void doControl() {
                double currentRecord = Conversions.nanosecondsToSeconds((long)System.nanoTime());
                if (!Double.isNaN(this.lastRecord)) {
                    this.realtimeRate.set(0.004 / (currentRecord - this.lastRecord));
                }
                this.lastRecord = currentRecord;
            }

            public YoRegistry getYoRegistry() {
                return this.registry;
            }
        });
        BulletMultiBodyParameters parameters = BulletMultiBodyParameters.defaultBulletMultiBodyParameters();
        parameters.setHasSelfCollision(false);
        BulletMultiBodyJointParameters jointParameters = BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters();
        SimulationSession simulationSession = new SimulationSession(BulletPhysicsEngineFactory.newBulletPhysicsEngineFactory((BulletMultiBodyParameters)parameters, (BulletMultiBodyJointParameters)jointParameters));
        simulationSession.addRobot((RobotDefinition)definition);
        simulationSession.setSessionDTSeconds(0.004);
        return simulationSession;
    }

    public static void main(String[] args) {
        SimulationSession simulationSession = MobileBulletSimulation.createSession();
        SessionVisualizerControls sessionVisualizerControls = SessionVisualizer.startSessionVisualizer((Session)simulationSession, null);
        sessionVisualizerControls.setCameraFocalPosition(0.0, 0.0, 0.7);
    }
}

